﻿/*	
 *	jQuery Combobox with autocomplete plugin
 *	www.frebsite.nl
 *	Copyright (c) 2009 Fred Heusschen
 *	Licensed under the MIT license.
 *	http://www.opensource.org/licenses/mit-license.php
 */
(function(jQuery){
	
    jQuery.fn.combobox = function(settings){
        var opts = jQuery.extend({}, jQuery.fn.combobox.defaults, settings);
        
        if (!jQuery('#combo_overlay').length) {
            jQuery('body').append('<div id="combobox_overlay"></div>');
            jQuery('#combobox_overlay').unbind('click').click(jQuery.fn.combobox.sluitSelect);
        }
        
        return this.each(function(){
            var el = jQuery(this);
            
            var id = el.attr('id');
            var ic = (id.length > 0) ? ' id="combobox_container_' + id + '"' : '';
            id = (id.length > 0) ? ' id="' + id + '"' : '';
            var na = (el.attr('name').length) ? ' name="' + el.attr('name') + '"' : '';
            var ti = (el.attr('tabindex').length) ? ' tabindex="' + el.attr('tabindex') + '"' : '';
            
            var cb = '<div class="combobox_input" >' + jQuery(':selected', el).text() + '' + ti + '</div>';
            cb += '<input class="combobox_hidden" type="hidden"' + na + '' + id + ' value="' + el.val() + '" />';
            
            cb += '<a ref="#" class="combobox_button"><span></span></a>';
            cb += '<ul class="combobox_summary">';
            
            jQuery('option', el).each(function(){
                var t = jQuery(this).html();
                var c = (jQuery(this).attr('class').length) ? ' class="' + jQuery(this).attr('class') + '"' : '';
                var v = jQuery(this).attr('value');
                if (!v.length) 
                    v = t;
                cb += '<li' + c + '><a ref="' + v + '">' + t + '</a></li>';
            });
            
            cb += '</ul>';
            
            el.wrap('<div class="combobox_container"' + ic + '></div>');
            var di = el.parent();
            di.before("<div class='combobox_container_left'></div>");
            di.after("<div class='combobox_container_right'></div>");
            di.append(cb);
            el.remove();
            
            di.parent().find('.combobox_container_right').mousedown(function(){
                jQuery.fn.combobox.openSelectFromButton(jQuery('a.combobox_button', di), opts);
                return false;
            });
            
            //	selectie openen via button
            if (opts.showOnMouseOver) {
                jQuery(di).mouseover(function(){
                    jQuery.fn.combobox.openSelectFromButton(jQuery(this), opts);
                }).click(function(){
                    return false;
                });
            }
            else 
                if (opts.buttonText.length > 0) {
                    jQuery('a.combobox_button', di).click(function(){
                        jQuery.fn.combobox.openSelectFromButton(jQuery(this), opts);
                        return false;
                    });
                }
            
            //	selectie sluiten na mouse-out
            if (opts.hideOnMouseOut) {
                jQuery(di).mouseout(function(){
                    jQuery.fn.combobox.sluitSelect();
                });
            }
            
            //	selectie openen via autocomplete
            jQuery('input.combobox_input', di).keyup(function(){
                jQuery('input.combobox_hidden', di).val(jQuery(this).val());
            });
            if (opts.autoComplete) {
                jQuery('input.combobox_input', di).keyup(function(){
                    var ul = jQuery(this).parent().find('ul');
                    var va = jQuery(this).val().toLowerCase();
                    var ar = new Array();
                    if (va.length > 0) {
                        jQuery('li', ul).each(function(){
                            var a = jQuery(this).find('a')
                            if (a.html().toLowerCase().indexOf(va) != -1 ||
                            a.attr('ref').toLowerCase().indexOf(va) != -1) {
                                jQuery(this).show();
                                ar.push(a.attr('ref'));
                            }
                            else 
                                jQuery(this).hide();
                        });
                    }
                    jQuery.fn.combobox.sluitSelect();
                    if (ar.length > 0) 
                        jQuery.fn.combobox.openSelect(ul, ar.length, opts);
                    
                    opts.callbackShowOptions(ar);
                    return false;
                });
            }
            
            jQuery('ul.combobox_summary li', di).click(function(){
			var a = jQuery('a', this);
			var v = jQuery(a).attr('ref');
			jQuery('div.combobox_input', di).text(jQuery(a).html());
			jQuery('input.combobox_hidden', di).attr('value', v);
			jQuery.fn.combobox.sluitSelect();
			opts.callbackSelectOption(v);
			jQuery(this).parent().scrollTop(0);
			jQuery('#translator_form').css('height','31px');		
			return false;	
		});

            jQuery('ul.combobox_summary li a', di).click(function(){
                var v = jQuery(this).attr('ref');
                jQuery('div.combobox_input', di).text(jQuery(this).html());
                jQuery('input.combobox_hidden', di).attr('value', v);
                jQuery.fn.combobox.sluitSelect();
                opts.callbackSelectOption(v);
                jQuery(this).parent().parent().scrollTop(0);
				jQuery('#translator_form').css('height','31px');
                return false;
            });
            jQuery.fn.combobox.sluitSelect();
        });
    };
    jQuery.fn.combobox.openSelectFromButton = function(btn, o){
        var ul = btn.parent().find('ul');
        jQuery('li', ul).show();
        jQuery.fn.combobox.sluitSelect();
        jQuery.fn.combobox.openSelect(ul, ul.children('li').size(), o);
        ul.css('left', (btn.parent().offset().left) + 'px');
        var ar = new Array();
        jQuery('li a', ul).each(function(){
            ar.push(jQuery(this).attr('ref'));
        });
        o.callbackShowOptions(ar);
        jQuery('li', ul).width(200);
        //jQuery('li a').mouseout(function(){alert('adsfadsf');});
    }
    jQuery.fn.combobox.openSelect = function(el, aa, o){
        el.show();
        var nh = (aa > o.maxVisibleOptions) ? (o.maxVisibleOptions * jQuery('li:visible', el).height()) + 'px' : '';
        el.css('height', nh);
        //el.scrollTop(0);
        jQuery('#combobox_overlay').show();
    }
    jQuery.fn.combobox.sluitSelect = function(){
        jQuery('ul.combobox_summary').hide();
        jQuery('#combobox_overlay').hide();
    }
    jQuery.fn.combobox.defaults = {
        showOnMouseOver: false,
        hideOnMouseOut: false,
        autoComplete: true,
        maxVisibleOptions: 1000000,
        buttonText: '&gt;',
        callbackShowOptions: function(arr){
        },
        callbackSelectOption: function(arr){
        }
    };
    
    
    
})(jQuery);
