/***************************************
*	dictInterface.js
*	initialize and handle dictionary actions
*
****************************************/
g_FromLanguage = 'English';
g_ToLanguage = 'English';
g_isFromHebrew = 0;
g_isMorfix = 0;

window.onload = function(){
	goButton();
	get_dictionary_languages();
	jQuery('#appResultArea').attr('src', "http://www.whitesmoke.com/translator/alphabetic_client_google.php?uid="+getUserId()+"&distId="+getDistId());
	 	
	var link = ''+window.location;
	if(link.indexOf('?word=') != -1){
	
		dictToLang = window.external.GetRegistryValue("dictToLang",'');
		if(dictToLang =='')
			dictToLang = 'English';
		index = link.indexOf('=');		
		word = String(link).substring(index+1);
		$('#searchText').attr('value',word);
		checkIfHebrew(word);		
		getDictionaryResultKeyPressed(dictToLang);
		//getDictionaryResult();
		
	} // here when we press enter
	else if(link.indexOf('?q=') != -1){
			index = link.indexOf('q=');		
			parameters = String(link).substring(index+2);
			tokens=parameters.split('&');
			if(tokens.length == 3){
				word = tokens[0];
				index = tokens[1].indexOf('=');
				from = String(tokens[1]).substring(index+1);
				index = tokens[2].indexOf('=');
				to = String(tokens[2]).substring(index+1);				
				$('#translate_fromLangId').attr('value',from);										
				$('#translate_toLangId').attr('value',to);
				$('#searchText').attr('value',urldecode(word));
				window.external.AddStatistics("dictionary:enterPressed");
				getDictionaryResult(word);				
			}		
	}	
	$('#searchText').focus();
	window.external.SetTransparentColor(0xffff00);
	
};
/*************************************************************/
function checkIsMorfix(){
	g_isMorfix = $('#translate_fromLangId option[value=Hebrew]').length; //0 or 1
}
/*************************************************************/
function checkIfHebrew(word){
	if(!g_isMorfix)
		return;
	var matches = null;	
	matches = word.match(/[\u05D0-\u05EA]/g);
	if(matches == null)
		g_isFromHebrew = 0;
	else 
		g_isFromHebrew = 1;		
}
/*************************************************************/
goButton = function(){
	$("#submitButton").mouseover(function() {
		$(this).attr('src','img/Buttons/go_over.gif');
	});
	$("#submitButton").mousedown(function() {
		$(this).attr('src','img/Buttons/go_press.gif');
		window.external.AddStatistics("dictionary:dictionaryGoButton");
		getDictionaryResult();
	});
	$("#submitButton").mouseout(function() {
		$(this).attr('src','img/Buttons/go_up.gif');
	});
	$("#submitButton").mouseup(function() {
		$(this).attr('src','img/Buttons/go_up.gif');
	});
};
/*************************************************************/
get_dictionary_languages = function(){
	//the data parameters didnt work in post so i added them to the url
	$.ajax({  
        method: 'post',
        url: "http://www.whitesmoke.com/translator/ajax_actions.php",
		data: {action: "latest_dictionary_languages" , version : "2011" ,userID: getUserId(),distID: getDistId() },
        error: function(){
            setDefaultLanguages();//if the server is down
			//setComboxFullText();
        },
        success: function(data){
			//if(data != 'google')
				eval(data);
				checkIsMorfix();
			//setComboxFullText();
		}  
    });
};
/*************************************************************/
function setDefaultLanguages(){
	jQuery('#translate_from_lang_field').html("<select name='translate_fromLangId' id='translate_fromLangId'>\
<option value='English'>English</option><option value='Arabic'>Arabic</option>\
<option value='French' >French</option><option value='German'>German</option>\
<option value='Italian'>Italian</option><option value='Portuguese'>Portuguese</option>\
<option value='Russian' >Russian</option><option value='Spanish'>Spanish</option>\
<option value='Chinese'>Chinese</option></select>");

	jQuery('#translate_to_lang_field').html("<select name='translate_toLangId' id='translate_toLangId'>\
<option value='English'>English</option>\
<option value='Arabic'>Arabic</option>\
<option value='French' >French</option>\
<option value='German'>German</option>\
<option value='Italian'>Italian</option>\
<option value='Portuguese'>Portuguese</option>\
<option value='Russian' >Russian</option>\
<option value='Spanish'>Spanish</option>\
<option value='Chinese'>Chinese</option>\
</select>");
	
}
/*************************************************************/
getUserId = function(){
    return window.external.GetUserID;
};
/*************************************************************/
getDistId = function(){
	return window.external.GetDist();
};
/*************************************************************/
function setComboxFullText(){
	
	jQuery("#translate_fromLangId").combobox({
        maxVisibleOptions: 6,
        callbackSelectOption: function(value){
		//jQuery('#combobox_container_translate_toLangId .combobox_input').attr('value',value);	
			g_FromLanguage = value;
        }
    });
    jQuery("#translate_toLangId").combobox({
        maxVisibleOptions: 6,
        callbackSelectOption: function(value){		
		//jQuery('#combobox_container_translate_fromLangId .combobox_input').attr('value',value);
			g_ToLanguage = value;
        }
    });

	 jQuery('#combobox_container_translate_fromLangId').mousedown(function(e){
        jQuery('#combobox_container_translate_fromLangId a.combobox_button').click();
    });
    jQuery('#combobox_container_translate_toLangId').mousedown(function(e){
        jQuery('#combobox_container_translate_toLangId a.combobox_button').click();
    });
    	
	
    jQuery("ul.combobox_summary li").hover(function(){
        jQuery('a', this).css({
            "font-weight": "bold"
        });
        jQuery(this).css({
            "background-color": "lightgrey"
        });
    }, function(){
        jQuery('a', this).css({
            "font-weight": "normal"
        });
        jQuery(this).css({
            "background-color": "white"
        });
    });

};
/*************************************************************/
resetDictionaryText = function(){
	var text = jQuery('#searchText').attr('value');
	if(text == "Enter a word"){
		jQuery('#searchText').attr('value','');
		jQuery('#searchText').select();
	}
	else{
			 if(text == "")
				jQuery('#searchText').select();		
		}
};
/*************************************************************/
function getDictionaryResultKeyPressed(dictToLang){
	this.wait('true','ajaxWait');
	var text = jQuery('#searchText').attr('value');
	var from = jQuery('#translate_fromLangId').attr('value');
	if(g_isFromHebrew){
		from = "Hebrew";
		jQuery('#translate_fromLangId').attr('value',from);
	}
	var to = dictToLang;	
	if(from=='English' && g_isMorfix){
		to = 'Hebrew';		
	}
	//alert('from = '+from + 'g_isMorfix = '+g_isMorfix);
	g_ToLanguage = to;
	g_FromLanguage = from;
	uid = getUserId();	
	distId = getDistId();
		
	jQuery('#translate_toLangId').attr('value',to);	
	jQuery('#appResultArea').attr('src', "http://www.whitesmoke.com/translator/alphabetic_client_google.php?uid="+uid+"&distId="+distId+"&word=" + encodeURIComponent(text) + "&from="+from+"&to="+to);
};
/*************************************************************/
getDictionaryResult = function(word)
{
	this.wait('true','ajaxWait');
	var text = jQuery('#searchText').attr('value');
	if(word) // after enter
		text = word;
	var from = jQuery('#translate_fromLangId').attr('value');
	var to = jQuery('#translate_toLangId').attr('value');
	window.external.SetRegistryValue('dictToLang',to); // default
	g_ToLanguage = to;
	g_FromLanguage = from;
	uid = getUserId();	
	distId = getDistId();	
	jQuery('#appResultArea').attr('src', "http://www.whitesmoke.com/translator/alphabetic_client_google.php?uid="+uid+"&distId="+distId+"&word=" + text + "&from="+from+"&to="+to);
	//reAssignLanguages();
};
/*************************************************************/
wait = function(state, id , source){		
    switch (state) {
        case "true":{
           jQuery('#ajaxWait').css('display', 'block');
			
        }
	break;
        case "false":{
           jQuery('#ajaxWait').css('display', 'none');
			if(source == 'translator')
			  setDefaultLanguage();
        }
	break;
    }
};
/*************************************************************/
function closeLanguageDropDown(){	
    jQuery('ul.combobox_summary').hide();
    jQuery('#combobox_overlay').hide();
}
/*************************************************************/
function reAssignLanguages(){
	//jQuery('#combobox_container_translate_fromLangId .combobox_input').attr('value',g_FromLanguage);
	
	//alert('g_FromLanguage '+g_FromLanguage+'  '+'g_ToLanguage '+g_ToLanguage);
	//jQuery('#combobox_container_translate_toLangId .combobox_input').html(g_ToLanguagem);
	//jQuery('#combobox_container_translate_toLangId .combobox_input').attr('value',g_ToLanguage);	
	$('#translate_toLangId option:'+g_ToLanguage).attr("selected", "selected");
	//$("#translate_toLangId").val( g_ToLanguage ).attr('selected',true);
}

function urldecode (str) {
    // *     example 1: urldecode('Kevin+van+Zonneveld%21');
    // *     returns 1: 'Kevin van Zonneveld!'
    // *     example 2: urldecode('http%3A%2F%2Fkevin.vanzonneveld.net%2F');
    // *     returns 2: 'http://kevin.vanzonneveld.net/'
    // *     example 3: urldecode('http%3A%2F%2Fwww.google.nl%2Fsearch%3Fq%3Dphp.js%26ie%3Dutf-8%26oe%3Dutf-8%26aq%3Dt%26rls%3Dcom.ubuntu%3Aen-US%3Aunofficial%26client%3Dfirefox-a');
    // *     returns 3: 'http://www.google.nl/search?q=php.js&ie=utf-8&oe=utf-8&aq=t&rls=com.ubuntu:en-US:unofficial&client=firefox-a'
    return decodeURIComponent((str + '').replace(/\+/g, '%20'));
}












