var g_currentInstance = null;
$ = function(id){
	return document.getElementById(id);
};
WSScreen = function(){
	this.iFrameId = "mainContent";
	g_currentInstance = this;
};
WSScreen.prototype.getSrcLink = function(){
	return window.external.GetWelcomeURL;
};

WSScreen.prototype.getUserId = function() {
	return window.external.GetUserID;
};

WSScreen.prototype.getDistId = function() {
	return window.external.GetDist();
};

WSScreen.prototype.buildUrl = function(){
	var startUrl = "?";
	if (this.checkUrl(this.getSrcLink()) === true)
	{
		startUrl = "&";
	}
	var stubID = 0;
	var answer = window.external.getRegistryValue("StubUniqueId","NoValue");
	if (answer == "NoValue"){
		// If the registry came up with no answer
		// we will try using the cookie!
		stubID = Number(window.external.GetDomainCookie("http://www.whitesmoke.com", "freeUserID"));
	} else {
		stubID = Number(answer);
	}
	return this.getSrcLink() + startUrl + "id=" + this.getUserId() + "&distID=" + this.getDistId() + "&dontShowWelcome=1&stubID="+stubID;
};
WSScreen.prototype.checkUrl = function(str){
	str = str.replace(/^\s+|\s+$/g);
	return /\?+/.test(str);
};
WSScreen.prototype.loadIframe = function(){
	document.getElementById("backgroundDocument").src = this.buildUrl();
};
WSScreen.prototype.handleRightClick = function(){
	document.body.oncontextmenu = function(){
		return false;
		event.returnValue = false;
	}
};
WSScreen.prototype.getDocumentHeight = function(){
	if (document.documentElement){
		return document.documentElement.clientHeight;
	}else{
		return null;
	}
};
WSScreen.prototype.getDocumentWidth = function(){
	if (document.documentElement){
		return document.documentElement.clientWidth;
	}else{
		return null;
	}
};
WSScreen.prototype.size = function(){
	var mainHeight = this.getDocumentHeight();
	var mainWidth = this.getDocumentWidth();
	var height;
	var width;		

	if(mainHeight){
		height = mainHeight - 28;
	}
	if (mainWidth){
		width = mainWidth - 2;
	}
	if (height && width){
		$(this.iFrameId).style.height = height + "px";
		$(this.iFrameId).style.width = width + "px";
	}
};
WSScreen.prototype.wait = function(state,id){
	switch(state){
		case "true":
			$(id).style.display = "block";
		break;
		case "false":
			$(id).style.display = "none";
		break;
	}
};
WSScreen.prototype.checkHistoryArray = function (sArray1,sArray2,var1,var2){
	for (var i = 0; i < sArray1.length; i++){
		if (sArray1[i] === var1 && sArray2[i] === var2){
			return true;
		}
	}
	return false;
};
WSScreen.prototype.inArray = function(sArray,sName){
	for (var i = 0; i < sArray.length; i++){
		if (sArray[i] === sName){
			return true;
		}
	}
	return false;
};