define("weiyun/noteapp/1.0.0/veditor-debug", [ "jquery/jquery/1.10.1/jquery-debug", "./tips-expand-debug", "./html-to-text-debug", "./buttons-debug" ], function(require, exports, module) {
    exports.name = "hello";
    var MAX_TEXT_LIMIT = 100 * 1e3;
    var is_editor_ready = false;
    var current_session_id = null;
    // 保存当前编辑的id
    var current_click_id = 0;
    // 保存当前点击的id
    var $ = exports.jquery = require("jquery/jquery/1.10.1/jquery-debug");
    var tips_expander = exports.tips_expander = require("./tips-expand-debug");
    var editor = VEditor.create({
        container: "ed1",
        height: 1,
        plugins: "tab,save,font,color,textjustify,history,toolbarswitcher,xpaste,weiyun_image,weiyun_hotkey,weiyun_font,list,weiyun_checkbox,weiyun_changedetector",
        buttons: "bold,italic,underline|color|weiyun_fontsize_bigger,weiyun_fontsize_smaller|listul,listol|weiyun_checkbox|weiyun_image|save",
        editorCss: "body{margin:8px}",
        textLimit: MAX_TEXT_LIMIT
    });
    var $this = this;
    var MAX_STEP_ARGUMENT_LENGTH = 10 * 1024;
    // 最大支持的JS调用C++参数字符串长度
    //var save_tips = null;
    var STATE_NORMAL = 0;
    var STATE_IS_SAVING = 1;
    var STATE_SAVE_COMPLETE = 2;
    var STATE_SAVE_FAILD = 3;
    var save_state = STATE_NORMAL;
    var savestate_timer = null;
    var NOTE_TYPE_ARTICLE = 1;
    var NOTE_TYPE_HTMLTEXT = 2;
    function resizeImageByWidth(width) {
        $(g_editor.getBody()).find("img").each(function(index, obj) {
            var $img = $(obj);
            if ($img.width() == width || width == 0 || $img.attr("width") == 0) {
                return;
            }
            if ($img.attr("width") <= width) {
                $img.css({
                    "max-width": "",
                    "max-height": ""
                });
                return;
            }
            var height = width * $img.attr("height") / $img.attr("width");
            $img.css({
                "max-width": width,
                "max-height": height
            });
        });
    }
    function resizeEditor() {
        var divEditor = document.getElementById("ed1");
        var toolbar = document.getElementsByClassName("veToolbarContainer")[0];
        var clientHeight = divEditor.clientHeight - toolbar.offsetHeight - 1;
        editor.setHeight(clientHeight);
        var maxWidth = $(editor.getBody()).width();
        resizeImageByWidth(maxWidth);
    }
    function resizeArticleViewer() {
        var height = $("#article_viewer_wrap").height() - $("#tips").outerHeight(true);
        $("#article_frame").height(height);
    }
    function GetEditorContent() {
        var htmlHelper = require("./html-to-text-debug");
        var htmlContent = editor.getContent();
        var textContent = htmlHelper.HtmlToText(htmlContent);
        var texts = textContent.split("\n");
        var title;
        var i = 0;
        for (i = 0; i < texts.length; ++i) {
            title = texts[i].trim();
            if (title.length > 0) break;
        }
        var summary = "";
        for (i = i + 1; i < texts.length; ++i) {
            summary += texts[i].trim();
            if (summary.length > 50) {
                summary = summary.substr(0, 50);
                break;
            }
        }
        var pics = [];
        $(htmlContent).find("img").each(function(index, obj) {
            var src = $(obj).attr("src");
            if (pics.indexOf(src) < 0) {
                pics.push(src);
            }
        });
        return {
            content: htmlContent,
            text: textContent,
            title: title,
            summary: summary,
            pics: pics,
            session_id: current_session_id
        };
    }
    function SetSaveButtonState(state) {
        var btn = editor.toolbarManager.getButton("save");
        if (state == STATE_NORMAL) {
            $(".veSave").children("p").text("保存");
            btn.setEnabled();
        } else if (state == STATE_IS_SAVING) {
            $button = $(".veSave").children("p");
            $(".veSave").children("p").html("<img src='./img/loading_btn.gif'>");
            $button.children("img").css("margin", "5px");
            btn.setDisable();
        } else if (state == STATE_SAVE_COMPLETE) {
            $(".veSave").children("p").text("已保存");
            btn.setDisable();
        } else if (state == STATE_SAVE_FAILD) {
            $(".veSave").children("p").text("未保存");
            btn.setDisable();
        }
        save_state = state;
    }
    function ChangeSaveButtonStyle() {
        $(".veButton_veSave").parent(".veToolbar").css("float", "right");
        $(".veButton_veSave").children("span").append($("<p>").text("保存"));
        SetSaveButtonState(STATE_NORMAL);
    }
    function UpdateWeiyunClientContent(session_id, cache_id) {
        // 调用微云客户端接口, 通知微云客户端更新笔记数据. 使用推的模式+拆分参数.
        var strContent = JSON.stringify(GetEditorContent());
        if (window.external.CallWeiyunClient_UpdateContent_Begin) {
            var strUpdateCache = "false";
            if (cache_id != undefined) {
                session_id = cache_id;
                strUpdateCache = "true";
            }
            window.external.CallWeiyunClient_UpdateContent_Begin(session_id, strUpdateCache);
            var index = 0;
            var length = strContent.length;
            var step = MAX_STEP_ARGUMENT_LENGTH;
            while (index < length) {
                window.external.CallWeiyunClient_UpdateContent_Step(session_id, strContent.substr(index, step));
                index += step;
            }
            window.external.CallWeiyunClient_UpdateContent_End(session_id);
        }
    }
    // function CreateSaveTips() {
    //     tips_html = '<div id="save_tips"><div class="ui-popover left" id="tips_bubble" style="display: hidden">'+
    //                 '<div class="arrow"></div>'+
    //                 '<div class="ui-popover-content">'+
    //                 '<div class="icon-succeed"></div><div id="save_tips_text">test</div>'+
    //                 '</div>'+
    //                 '</div></div>';
    //     $(tips_html).insertAfter($(".veButton_veSave").parent(".veToolbar"));
    //     return {
    //         SetSaveTips: function(str, number) {
    //             $('#tips_bubble').show();
    //             $('#save_tips').width('100px');
    //             $('#save_tips_text').text(str);
    //             $('#save_tips').width($('#tips_bubble').outerWidth()+'px');
    //             if (number != undefined) {
    //                 $('#tips_bubble').delay(number).fadeOut(1000);
    //             }
    //         }
    //     }
    // }
    editor.onInitComplete.addLast(function() {
        var NeedMonitorChange = false;
        editor.tryIO("onSaveContent", function(ev) {
            ev.addLast(function(text) {
                window.external.CallWeiyunClient_SaveNote(current_session_id, JSON.stringify(GetEditorContent()), "false");
            });
        });
        editor.tryIO("onWeiYunImageEvent", function(ev) {
            ev.addLast(function(event) {
                if (event == "insert") {
                    window.external.CallWeiyunClient_InsertImage(JSON.stringify(GetEditorContent()));
                }
            });
        });
        editor.tryIO("onHistoryChange", function(ev) {
            ev.addLast(function(hasUndo, hasRedo) {
                if (hasUndo == false && hasRedo == false) {
                    return;
                }
                var btn = editor.toolbarManager.getButton("save");
                if (save_state == STATE_NORMAL && btn.disabled || save_state == STATE_SAVE_COMPLETE) {
                    SetSaveButtonState(STATE_NORMAL);
                }
                // Resize Image
                var maxWidth = $(editor.getBody()).width();
                resizeImageByWidth(maxWidth);
                if (NeedMonitorChange == false) {
                    return;
                }
                console.log("Change!");
                // Call Win
                if (window.external.CallWeiyunClient_OnDocumentChange) {
                    window.external.CallWeiyunClient_OnDocumentChange(current_session_id, "NO_IME");
                }
            });
        });
        editor.tryIO("onDetectContentChange", function(ev) {
            ev.addLast(function(ime) {
                var btn = editor.toolbarManager.getButton("save");
                if (save_state == STATE_NORMAL && btn.disabled || save_state == STATE_SAVE_COMPLETE) {
                    SetSaveButtonState(STATE_NORMAL);
                }
                if (NeedMonitorChange == false) {
                    return;
                }
                console.log("Detect Change!");
                IME_FLAG = ime ? "IME" : "NO_IME";
                // Call Win
                if (window.external.CallWeiyunClient_OnDocumentChange) {
                    window.external.CallWeiyunClient_OnDocumentChange(current_session_id, IME_FLAG);
                }
            });
        });
        editor.onBeforeSetContent.addLast(function(params) {
            NeedMonitorChange = false;
        });
        editor.onAfterSetContent.add(function(params) {
            var maxWidth = $(editor.getBody()).width();
            resizeImageByWidth(maxWidth);
            NeedMonitorChange = true;
        });
        //绑定粘贴，粘贴时不处理行高
        editor.onPaste.add(function(evt) {
            var imgs = [];
            var $div = $("<div>");
            var html = evt.clipboardData.getData("text/html");
            var text = evt.clipboardData.getData("text/plain");
            if (html != undefined && html != "") {
                if (html.length > MAX_TEXT_LIMIT) {
                    // 超过后先截断剪贴板
                    html = html.substring(0, MAX_TEXT_LIMIT);
                    evt.clipboardData.setData("text/html", html);
                }
                // 处理html格式文件
                var re = /^(https?|file):\//gm;
                var reHttp = /^https?:\//gm;
                var reFile = /^file:\/\//gm;
                $html = $(html);
                $div.append($html);
                $div.find("img").each(function(index, obj) {
                    if (reHttp.test(obj.src) || reFile.test(obj.src) && obj.className == "wyimage") {
                        // 本地的绝对路径和http路径, 加入进去
                        imgs.push(obj.src);
                    } else {
                        // 从Dom移除
                        if (obj.parentNode) {
                            obj.parentNode.removeChild(obj);
                        }
                    }
                });
                evt.clipboardData.setData("text/html", $div.html());
                if (window.external.CallWeiyunClient_OnPasteFromClipboard) {
                    window.external.CallWeiyunClient_OnPasteFromClipboard(current_session_id, JSON.stringify(imgs), JSON.stringify(GetEditorContent()));
                } else {
                    alert("onAfterPaste!");
                }
            } else if (text != undefined && text != "") {
                if (text.length > MAX_TEXT_LIMIT) {
                    // 超过后先截断剪贴板
                    evt.clipboardData.setData("text/html", text.substring(0, MAX_TEXT_LIMIT));
                    return;
                }
            } else {
                // 处理截图文件
                var items = evt.clipboardData.items;
                for (var i = 0; i < items.length; ++i) {
                    if (items[i].kind == "file" && items[i].type.indexOf("image/") !== -1) {
                        var reader = new FileReader();
                        reader.onloadend = function() {
                            UpdateWeiyunClientContent(current_session_id, undefined);
                            if (window.external.CallWeiyunClient_OnPasteImageBuffer_Begin) {
                                var base64 = window.btoa(reader.result);
                                var index = 0;
                                var length = base64.length;
                                var step = MAX_STEP_ARGUMENT_LENGTH;
                                window.external.CallWeiyunClient_OnPasteImageBuffer_Begin(current_session_id);
                                while (index < length) {
                                    window.external.CallWeiyunClient_OnPasteImageBuffer_Step(current_session_id, base64.substr(index, step));
                                    index += step;
                                }
                                window.external.CallWeiyunClient_OnPasteImageBuffer_End(current_session_id);
                            } else {
                                alert("onAfterPaste!");
                            }
                        };
                        var blob = items[i].getAsFile();
                        reader.readAsBinaryString(blob);
                        break;
                    }
                }
            }
        });
        editor.onAfterPaste.add(function() {
            var str = editor.getBody().innerHTML;
            if (str.length > MAX_TEXT_LIMIT) {
                this.editor.getBody().innerHTML = str.substring(0, MAX_TEXT_LIMIT);
            }
            if (window.external.CallWeiyunClient_OnDocumentChange) {
                window.external.CallWeiyunClient_OnDocumentChange(current_session_id, "NO_IME");
            }
        });
        var buttons = require("./buttons-debug");
        buttons.BindFunctions();
        $(editor.getBody()).off("contextmenu").bind("contextmenu", function(e) {
            window.external.CallWeiyunClient_EditContextMenu(current_session_id);
            return false;
        });
        $("#hyperlink_tips").off("click").bind("click", function(e) {
            if (window.external.CallWeiyunClient_OnChangeTextTipsClick) {
                window.external.CallWeiyunClient_OnChangeTextTipsClick(current_session_id);
            } else {
                alert("hyperlink_tips!");
            }
        });
        ChangeSaveButtonStyle();
        // save_tips = CreateSaveTips();
        // save_tips.SetSaveTips('aaa'); 设置保存提示
        setTimeout(function() {
            resizeEditor();
            is_editor_ready = true;
        }, 1e3);
    });
    window.onresize = function(event) {
        if ($("#note_viewer").is(":visible")) {
            resizeEditor();
        }
        if ($("#article_viewer").is(":visible")) {
            tips_expander.ResizeTips("#tips", function() {
                resizeArticleViewer();
            });
            resizeArticleViewer();
        }
    };
    console.log("test! end");
    exports.editor = editor;
    exports.CallJS_ShowNote = function() {
        var time_out = null;
        function ShowNote(session_note_id, note_type, html_context, url) {
            // 如果编辑器没有准备好, 那么延迟显示内容
            var $arguments = arguments;
            if (time_out != null) {
                clearTimeout(time_out);
                time_out = null;
            }
            if (is_editor_ready == false) {
                time_out = setTimeout(function() {
                    ShowNote.apply($this, $arguments);
                }, 1e3);
                return "delay";
            }
            current_session_id = session_note_id;
            if (note_type == NOTE_TYPE_ARTICLE) {
                $("#note_viewer").hide();
                $("#article_viewer").show();
                $("#tips_text").text(html_context);
                $("#real_article").html("<iframe id='article_frame' src='" + url + "' frameborder='0' style='width:100%;'></iframe>");
                tips_expander.UpdateTips("#tips", 60, function() {
                    resizeArticleViewer();
                });
                resizeArticleViewer();
            } else {
                var focus = false;
                $("#note_viewer").show();
                $("#article_viewer").hide();
                if (html_context.length == 0) {
                    SetSaveButtonState(STATE_NORMAL);
                    var btn = editor.toolbarManager.getButton("save");
                    btn.setDisable();
                    focus = true;
                } else {
                    SetSaveButtonState(STATE_NORMAL);
                }
                if (focus) {
                    editor.getDoc().body.focus();
                } else {
                    var btn = editor.toolbarManager.getButton("save");
                    btn.dom.focus();
                }
                editor.setContent({
                    content: html_context,
                    useParser: true,
                    forcusFirst: focus
                });
                resizeEditor();
            }
            return "done!";
        }
        return ShowNote;
    }();
    exports.CallJS_WeiYunHotkey = function(cmd) {
        if (cmd == "cut") {
            editor.execCommand("cut");
        } else if (cmd == "copy") {
            editor.execCommand("copy");
        } else if (cmd == "paste") {
            editor.execCommand("cut");
        }
    };
    exports.CallJS_WeiYunInsertImage = function(src) {
        editor.execCommand("insert_weiyun_image", src);
    };
    exports.CallJS_ChangeSaveState = function(session_note_id, state) {
        if (current_session_id != session_note_id) {
            return;
        }
        SetSaveButtonState(state);
        var ResumeSaveState = function(session_id, old_state, new_state, timer, timeout) {
            if (timer != null) {
                clearTimeout(timer);
            }
            return setTimeout(function() {
                if (current_session_id != session_id) return;
                if (old_state != save_state) return;
                SetSaveButtonState(new_state);
            }, timeout);
        };
        if (state == STATE_SAVE_COMPLETE || state == STATE_SAVE_FAILD) {
            savestate_timer = ResumeSaveState(session_note_id, state, STATE_NORMAL, savestate_timer, 2e3);
        }
    };
    exports.CallJS_SaveFromWeiyun = function(session_id, autosave) {
        if (session_id != current_session_id) return;
        window.external.CallWeiyunClient_SaveNote(current_session_id, JSON.stringify(GetEditorContent()), autosave);
    };
    exports.CallJS_SaveCacheFromWeiyun = function(session_id, cache_id) {
        if (session_id != current_session_id) {
            window.external.CallWeiyunClient_SaveCacheFail(cache_id);
            return;
        }
        UpdateWeiyunClientContent(session_id, cache_id);
    };
    exports.CallJS_UpdateImageUrl = function(src_url, replace_url) {
        $(editor.getBody()).find("img").each(function(index, obj) {
            if (obj.src == src_url) {
                if (replace_url == null) {
                    obj.remove();
                } else {
                    obj.src = replace_url;
                }
            }
        });
    };
    exports.CallJS_NoteEcho = function(seq) {
        if (window.external.CallWeiyunClient_EchoFromJS) {
            window.external.CallWeiyunClient_EchoFromJS(seq);
        }
    };
});

define("weiyun/noteapp/1.0.0/tips-expand-debug", [ "jquery/jquery/1.10.1/jquery-debug" ], function(require, exports, module) {
    var $ = require("jquery/jquery/1.10.1/jquery-debug");
    function getMore(obj) {
        if (obj.attr("data-mlOverflow_more") != undefined) {
            return obj.attr("data-mlOverflow_more");
        } else return "More";
    }
    function getLess(obj) {
        if (obj.attr("data-mlOverflow_less") != undefined) return obj.attr("data-mlOverflow_less"); else return "Less";
    }
    function makeItLess(obj, resize_event_handler) {
        // 实现缩进功能
        obj.children(".mlOverflow_button").remove();
        var offset = 0;
        if (obj.children(".mlOverflow_text").outerHeight(true) > obj.outerHeight(true)) {
            obj.append('<a href="#" class="mlOverflow_button">' + getMore(obj) + "</a>");
            offset = $(".mlOverflow_button").outerHeight(true);
        }
        while (obj.children(".mlOverflow_text").outerHeight(true) + offset > obj.outerHeight(true)) {
            obj.children(".mlOverflow_text").text(obj.children(".mlOverflow_text").text().replace(/\W*\s(\S)*$/, "..."));
        }
        // 按钮展开与收起的绑定处理
        obj.children(".mlOverflow_button").click(function() {
            var holder = $(this).siblings(".mlOverflow_text").text();
            $(this).siblings(".mlOverflow_text").text($(this).siblings(".mlOverflow_text").data("mlOverflow_text"));
            $(this).siblings(".mlOverflow_text").data("mlOverflow_text", holder);
            if ($(this).text() == getMore(obj)) {
                $(this).text(getLess(obj));
                obj.css("max-height", "none");
                obj.css("height", "auto");
            } else {
                $(this).text(getMore(obj));
                obj.css("max-height", "" + obj.data("mlOverflow_height") + "px");
            }
            if (resize_event_handler) {
                resize_event_handler();
            }
            _console.log("button click");
        });
    }
    exports.UpdateTips = function(selector, height, resize_event_handler) {
        // Save the original text and height of each exOverflow div, in case they're expanded
        $(selector).each(function() {
            if ($(this).children(".mlOverflow_text").text().length < 0) {
                $(this).hide();
            }
        });
        $(selector).each(function() {
            $(this).data("mlOverflow_height", height);
            $(this).css("max-height", "" + height + "px");
            $(this).children(".mlOverflow_text").data("mlOverflow_text", $(this).children(".mlOverflow_text").text());
        });
        $(selector).each(function() {
            makeItLess($(this), resize_event_handler);
        });
    };
    exports.ResizeTips = function(selector, resize_event_handler) {
        _console.log("enter ResizeTips");
        var holder = $(selector).children(".mlOverflow_text").data("mlOverflow_text");
        _console.log(holder);
        if ($(selector).children(".mlOverflow_button").text() == getMore($(selector))) {
            $(selector).children(".mlOverflow_text").text(holder);
            _console.log("ResizeTips makeItLess");
            makeItLess($(selector), resize_event_handler);
        }
    };
});

define("weiyun/noteapp/1.0.0/html-to-text-debug", [], function(require, exports, module) {
    exports.HtmlToText = function htmlToText(html, extensions) {
        var text = html;
        if (extensions && extensions["preprocessing"]) text = extensions["preprocessing"](text);
        text = text.replace(/(?:\n|\r\n|\r)/gi, " ").replace(/<\s*script[^>]*>[\s\S]*?<\/script>/gim, "").replace(/<\s*style[^>]*>[\s\S]*?<\/style>/gim, "").replace(/<!--.*?-->/gim, "").replace(/<!DOCTYPE.*?>/gi, "");
        /* I scanned http://en.wikipedia.org/wiki/HTML_element for all html tags.
      I put those tags that should affect plain text formatting in two categories:
      those that should be replaced with two newlines and those that should be
      replaced with one newline. */
        if (extensions && extensions["tagreplacement"]) text = extensions["tagreplacement"](text);
        var doubleNewlineTags = [ "p", "h[1-6]", "dl", "dt", "dd", "ol", "ul", "dir", "address", "blockquote", "center", "div", "hr", "pre", "form", "textarea", "table" ];
        var singleNewlineTags = [ "li", "del", "ins", "fieldset", "legend", "tr", "th", "caption", "thead", "tbody", "tfoot" ];
        for (i = 0; i < doubleNewlineTags.length; i++) {
            var r = RegExp("</?\\s*" + doubleNewlineTags[i] + "[^>]*>", "ig");
            text = text.replace(r, "\n\n");
        }
        for (i = 0; i < singleNewlineTags.length; i++) {
            var r = RegExp("<\\s*" + singleNewlineTags[i] + "[^>]*>", "ig");
            text = text.replace(r, "\n");
        }
        // Replace <br> and <br/> with a single newline
        text = text.replace(/<\s*br[^>]*\/?\s*>/gi, "\n");
        text = text.replace(/(<([^>]+)>)/gi, "").replace(/([^\n\S]+)\n/g, "\n").replace(/([^\n\S]+)$/, "").replace(/\n{2,}/g, "\n\n").replace(/^\n+/, "").replace(/\n+$/, "").replace(/&([^;]+);/g, decodeHtmlEntity);
        if (extensions && extensions["postprocessing"]) text = extensions["postprocessing"](text);
        return text;
    };
    function decodeHtmlEntity(m, n) {
        // Determine the character code of the entity. Range is 0 to 65535
        // (characters in JavaScript are Unicode, and entities can represent
        // Unicode characters).
        var code;
        // Try to parse as numeric entity. This is done before named entities for
        // speed because associative array lookup in many JavaScript implementations
        // is a linear search.
        if (n.substr(0, 1) == "#") {
            // Try to parse as numeric entity
            if (n.substr(1, 1) == "x") {
                // Try to parse as hexadecimal
                code = parseInt(n.substr(2), 16);
            } else {
                // Try to parse as decimal
                code = parseInt(n.substr(1), 10);
            }
        } else {
            // Try to parse as named entity
            code = ENTITIES_MAP[n];
        }
        // If still nothing, pass entity through
        return code === undefined || code === NaN ? "&" + n + ";" : String.fromCharCode(code);
    }
    var ENTITIES_MAP = {
        nbsp: 160,
        iexcl: 161,
        cent: 162,
        pound: 163,
        curren: 164,
        yen: 165,
        brvbar: 166,
        sect: 167,
        uml: 168,
        copy: 169,
        ordf: 170,
        laquo: 171,
        not: 172,
        shy: 173,
        reg: 174,
        macr: 175,
        deg: 176,
        plusmn: 177,
        sup2: 178,
        sup3: 179,
        acute: 180,
        micro: 181,
        para: 182,
        middot: 183,
        cedil: 184,
        sup1: 185,
        ordm: 186,
        raquo: 187,
        frac14: 188,
        frac12: 189,
        frac34: 190,
        iquest: 191,
        Agrave: 192,
        Aacute: 193,
        Acirc: 194,
        Atilde: 195,
        Auml: 196,
        Aring: 197,
        AElig: 198,
        Ccedil: 199,
        Egrave: 200,
        Eacute: 201,
        Ecirc: 202,
        Euml: 203,
        Igrave: 204,
        Iacute: 205,
        Icirc: 206,
        Iuml: 207,
        ETH: 208,
        Ntilde: 209,
        Ograve: 210,
        Oacute: 211,
        Ocirc: 212,
        Otilde: 213,
        Ouml: 214,
        times: 215,
        Oslash: 216,
        Ugrave: 217,
        Uacute: 218,
        Ucirc: 219,
        Uuml: 220,
        Yacute: 221,
        THORN: 222,
        szlig: 223,
        agrave: 224,
        aacute: 225,
        acirc: 226,
        atilde: 227,
        auml: 228,
        aring: 229,
        aelig: 230,
        ccedil: 231,
        egrave: 232,
        eacute: 233,
        ecirc: 234,
        euml: 235,
        igrave: 236,
        iacute: 237,
        icirc: 238,
        iuml: 239,
        eth: 240,
        ntilde: 241,
        ograve: 242,
        oacute: 243,
        ocirc: 244,
        otilde: 245,
        ouml: 246,
        divide: 247,
        oslash: 248,
        ugrave: 249,
        uacute: 250,
        ucirc: 251,
        uuml: 252,
        yacute: 253,
        thorn: 254,
        yuml: 255,
        quot: 34,
        amp: 38,
        lt: 60,
        gt: 62,
        OElig: 338,
        oelig: 339,
        Scaron: 352,
        scaron: 353,
        Yuml: 376,
        circ: 710,
        tilde: 732,
        ensp: 8194,
        emsp: 8195,
        thinsp: 8201,
        zwnj: 8204,
        zwj: 8205,
        lrm: 8206,
        rlm: 8207,
        ndash: 8211,
        mdash: 8212,
        lsquo: 8216,
        rsquo: 8217,
        sbquo: 8218,
        ldquo: 8220,
        rdquo: 8221,
        bdquo: 8222,
        dagger: 8224,
        Dagger: 8225,
        permil: 8240,
        lsaquo: 8249,
        rsaquo: 8250,
        euro: 8364
    };
});

define("weiyun/noteapp/1.0.0/buttons-debug", [ "jquery/jquery/1.10.1/jquery-debug" ], function(require, exports, module) {
    var $ = require("jquery/jquery/1.10.1/jquery-debug");
    exports.BindFunctions = function() {
        $("#refresh").click(function() {
            window.external.CallWeiyunClient_RefreshNote();
        });
        $("#remove").click(function() {
            window.external.CallWeiyunClient_RemoveNote();
        });
        $("#create").click(function() {
            window.external.CallWeiyunClient_CreateNote();
        });
    };
});
