/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoaderException;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class Fluid {
    protected final String fluidName;
    protected String unlocalizedName;
    protected ps stillIcon;
    protected ps flowingIcon;
    protected int luminosity = 0;
    protected int density = 1000;
    protected int temperature = 295;
    protected int viscosity = 1000;
    protected boolean isGaseous;
    protected acc rarity = acc.a;
    protected ahu block = null;
    private static Map<String, String> legacyNames = Maps.newHashMap();

    public Fluid(String fluidName) {
        this.fluidName = fluidName.toLowerCase(Locale.ENGLISH);
        this.unlocalizedName = fluidName;
    }

    public Fluid setUnlocalizedName(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
        return this;
    }

    public Fluid setBlock(ahu block) {
        if (this.block == null || this.block == block) {
            this.block = block;
        } else if (!ForgeModContainer.forceDuplicateFluidBlockCrash) {
            FMLLog.warning("A mod has attempted to assign Block " + block + " to the Fluid '" + this.fluidName + "' but this Fluid has already been linked to BlockID " + this.block + ". Configure your mods to prevent this from happening.", new Object[0]);
        } else {
            FMLLog.severe("A mod has attempted to assign BlockID " + block + " to the Fluid '" + this.fluidName + "' but this Fluid has already been linked to BlockID " + this.block + ". Configure your mods to prevent this from happening.", new Object[0]);
            throw new LoaderException(new RuntimeException("A mod has attempted to assign BlockID " + block + " to the Fluid '" + this.fluidName + "' but this Fluid has already been linked to BlockID " + this.block + ". Configure your mods to prevent this from happening."));
        }
        return this;
    }

    public Fluid setLuminosity(int luminosity) {
        this.luminosity = luminosity;
        return this;
    }

    public Fluid setDensity(int density) {
        this.density = density;
        return this;
    }

    public Fluid setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public Fluid setViscosity(int viscosity) {
        this.viscosity = viscosity;
        return this;
    }

    public Fluid setGaseous(boolean isGaseous) {
        this.isGaseous = isGaseous;
        return this;
    }

    public Fluid setRarity(acc rarity) {
        this.rarity = rarity;
        return this;
    }

    public final String getName() {
        return this.fluidName;
    }

    public final int getID() {
        return FluidRegistry.getFluidID(this.fluidName);
    }

    public final ahu getBlock() {
        return this.block;
    }

    public final boolean canBePlacedInWorld() {
        return this.block != null;
    }

    public String getLocalizedName() {
        String s = this.getUnlocalizedName();
        return s == null ? "" : dc.a((String)s);
    }

    public String getUnlocalizedName() {
        return "fluid." + this.unlocalizedName;
    }

    public final int getSpriteNumber() {
        return 0;
    }

    public final int getLuminosity() {
        return this.luminosity;
    }

    public final int getDensity() {
        return this.density;
    }

    public final int getTemperature() {
        return this.temperature;
    }

    public final int getViscosity() {
        return this.viscosity;
    }

    public final boolean isGaseous() {
        return this.isGaseous;
    }

    public acc getRarity() {
        return this.rarity;
    }

    public int getColor() {
        return 0xFFFFFF;
    }

    public final Fluid setStillIcon(ps stillIcon) {
        this.stillIcon = stillIcon;
        return this;
    }

    public final Fluid setFlowingIcon(ps flowingIcon) {
        this.flowingIcon = flowingIcon;
        return this;
    }

    public final Fluid setIcons(ps stillIcon, ps flowingIcon) {
        return this.setStillIcon(stillIcon).setFlowingIcon(flowingIcon);
    }

    public final Fluid setIcons(ps commonIcon) {
        return this.setStillIcon(commonIcon).setFlowingIcon(commonIcon);
    }

    public ps getIcon() {
        return this.getStillIcon();
    }

    public ps getStillIcon() {
        return this.stillIcon;
    }

    public ps getFlowingIcon() {
        return this.flowingIcon;
    }

    public int getLuminosity(FluidStack stack) {
        return this.getLuminosity();
    }

    public int getDensity(FluidStack stack) {
        return this.getDensity();
    }

    public int getTemperature(FluidStack stack) {
        return this.getTemperature();
    }

    public int getViscosity(FluidStack stack) {
        return this.getViscosity();
    }

    public boolean isGaseous(FluidStack stack) {
        return this.isGaseous();
    }

    public acc getRarity(FluidStack stack) {
        return this.getRarity();
    }

    public int getColor(FluidStack stack) {
        return this.getColor();
    }

    public ps getIcon(FluidStack stack) {
        return this.getIcon();
    }

    public int getLuminosity(afn world, int x, int y2, int z2) {
        return this.getLuminosity();
    }

    public int getDensity(afn world, int x, int y2, int z2) {
        return this.getDensity();
    }

    public int getTemperature(afn world, int x, int y2, int z2) {
        return this.getTemperature();
    }

    public int getViscosity(afn world, int x, int y2, int z2) {
        return this.getViscosity();
    }

    public boolean isGaseous(afn world, int x, int y2, int z2) {
        return this.isGaseous();
    }

    public acc getRarity(afn world, int x, int y2, int z2) {
        return this.getRarity();
    }

    public int getColor(afn world, int x, int y2, int z2) {
        return this.getColor();
    }

    public ps getIcon(afn world, int x, int y2, int z2) {
        return this.getIcon();
    }

    static String convertLegacyName(String fluidName) {
        return fluidName != null && legacyNames.containsKey(fluidName) ? legacyNames.get(fluidName) : fluidName;
    }

    public static void registerLegacyName(String legacyName, String canonicalName) {
        legacyNames.put(legacyName.toLowerCase(Locale.ENGLISH), canonicalName);
    }
}

