/*
 * Decompiled with CFR 0.152.
 */
package vazkii.tinkerer.common.research;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.config.ConfigResearch;
import vazkii.tinkerer.common.block.ModBlocks;
import vazkii.tinkerer.common.core.handler.ConfigHandler;
import vazkii.tinkerer.common.core.helper.NumericAspectHelper;
import vazkii.tinkerer.common.item.ModItems;
import vazkii.tinkerer.common.research.EnderStorageRecepie;

public final class ModRecipes {
    public static void initRecipes() {
        ModRecipes.initCraftingRecipes();
        ModRecipes.initArcaneRecipes();
        ModRecipes.initInfusionRecipes();
        ModRecipes.initCrucibleRecipes();
    }

    private static void initCraftingRecipes() {
        ModRecipes.registerResearchItem("DARK_QUARTZ0", new ItemStack(ModItems.darkQuartz, 8), "QQQ", "QCQ", "QQQ", Character.valueOf('Q'), Items.field_151128_bU, Character.valueOf('C'), Items.field_151044_h);
        ModRecipes.registerResearchItem("DARK_QUARTZ0", new ItemStack(ModItems.darkQuartz, 8), "QQQ", "QCQ", "QQQ", Character.valueOf('Q'), Items.field_151128_bU, Character.valueOf('C'), new ItemStack(Items.field_151044_h, 1, 1));
        ModRecipes.registerResearchItem("DARK_QUARTZ1", new ItemStack(ModBlocks.darkQuartz), "QQ", "QQ", Character.valueOf('Q'), ModItems.darkQuartz);
        ModRecipes.registerResearchItem("DARK_QUARTZ2", new ItemStack(ModBlocks.darkQuartzSlab, 6), "QQQ", Character.valueOf('Q'), ModBlocks.darkQuartz);
        ModRecipes.registerResearchItem("DARK_QUARTZ3", new ItemStack(ModBlocks.darkQuartz, 2, 2), "Q", "Q", Character.valueOf('Q'), ModBlocks.darkQuartz);
        ModRecipes.registerResearchItem("DARK_QUARTZ4", new ItemStack(ModBlocks.darkQuartz, 1, 1), "Q", "Q", Character.valueOf('Q'), ModBlocks.darkQuartzSlab);
        ModRecipes.registerResearchItem("DARK_QUARTZ5", new ItemStack(ModBlocks.darkQuartzStairs, 4), "  Q", " QQ", "QQQ", Character.valueOf('Q'), ModBlocks.darkQuartz);
        ModRecipes.registerResearchItem("", new ItemStack(ModBlocks.darkQuartzStairs, 4), "Q  ", "QQ ", "QQQ", Character.valueOf('Q'), ModBlocks.darkQuartz);
        ModRecipes.registerResearchItem("INFUSED_INKWELL0", new ItemStack(ModItems.infusedInkwell), "QQQ", "QCQ", "QQQ", Character.valueOf('Q'), new ItemStack(Items.field_151100_aR, 1, 0), Character.valueOf('C'), new ItemStack(ModItems.infusedInkwell, 1, Short.MAX_VALUE));
        if (ConfigHandler.enableSurvivalShareTome) {
            ModRecipes.registerResearchItem("SHARE_TOME", new ItemStack(ModItems.shareBook), " S ", "PTP", " P ", Character.valueOf('S'), new ItemStack(ConfigItems.itemInkwell), Character.valueOf('T'), new ItemStack(ConfigItems.itemThaumonomicon), Character.valueOf('P'), new ItemStack(Items.field_151121_aF));
        }
        for (int i = 0; i < NumericAspectHelper.values.size(); ++i) {
            ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)ModItems.mobAspect, 1, i), (int[])new int[]{i}, (AspectList)new AspectList().add(NumericAspectHelper.getAspect(i), 8));
            ModRecipes.registerResearchItem("SUMMON1", new ItemStack((Item)ModItems.mobAspect, 1, i + 20), "XXX", "XXX", "XXX", Character.valueOf('X'), new ItemStack((Item)ModItems.mobAspect, 1, i));
        }
        if (ConfigHandler.enableKami) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(ModItems.kamiResource, 9, 3), (Object[])new Object[]{new ItemStack(ModItems.kamiResource, 1, 2)});
        }
    }

    private static void initArcaneRecipes() {
        ModRecipes.registerResearchItem("SUMMON0", "SUMMON", new ItemStack(ModBlocks.spawner), new AspectList().add(Aspect.ORDER, 50).add(Aspect.ENTROPY, 50), "WWW", "SSS", Character.valueOf('S'), new ItemStack(Blocks.field_150348_b), Character.valueOf('W'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 1));
        ModRecipes.registerResearchItem("INTERFACE", "INTERFACE", new ItemStack(ModBlocks.interfase), new AspectList().add(Aspect.ORDER, 12).add(Aspect.ENTROPY, 16), "BRB", "LEL", "BRB", Character.valueOf('B'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 6), Character.valueOf('E'), new ItemStack(Items.field_151079_bi), Character.valueOf('L'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('R'), new ItemStack(Items.field_151137_ax));
        ModRecipes.registerResearchItem("INTERFACE1", "INTERFACE", new ItemStack(ModItems.connector), new AspectList().add(Aspect.ORDER, 2), " I ", " WI", "S  ", Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('W'), new ItemStack(Items.field_151055_y), Character.valueOf('S'), new ItemStack(ConfigItems.itemShard, 1, 4));
        ModRecipes.registerResearchItem("GAS_REMOVER", "GAS_REMOVER", new ItemStack(ModItems.gasRemover), new AspectList().add(Aspect.AIR, 2).add(Aspect.ORDER, 2), "DDD", "T G", "QQQ", Character.valueOf('D'), new ItemStack(ModItems.darkQuartz), Character.valueOf('T'), new ItemStack(ModItems.gaseousShadow), Character.valueOf('G'), new ItemStack(ModItems.gaseousLight), Character.valueOf('Q'), new ItemStack(Items.field_151128_bU));
        ModRecipes.registerResearchItem("ANIMATION_TABLET", "ANIMATION_TABLET", new ItemStack(ModBlocks.animationTablet), new AspectList().add(Aspect.AIR, 25).add(Aspect.ORDER, 15).add(Aspect.FIRE, 10), "GIG", "ICI", Character.valueOf('G'), new ItemStack(Items.field_151043_k), Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('C'), new ItemStack(ConfigItems.itemGolemCore, 1, 100));
        ModRecipes.registerResearchItem("MAGNET", "MAGNETS", new ItemStack(ModBlocks.magnet), new AspectList().add(Aspect.AIR, 20).add(Aspect.ORDER, 5).add(Aspect.EARTH, 15).add(Aspect.ENTROPY, 5), " I ", "SIs", "WFW", Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('s'), new ItemStack(ConfigItems.itemShard, 1, 3), Character.valueOf('S'), new ItemStack(ConfigItems.itemShard), Character.valueOf('W'), new ItemStack(ConfigBlocks.blockMagicalLog), Character.valueOf('F'), new ItemStack(ModItems.focusTelekinesis));
        ModRecipes.registerResearchItem("MOB_MAGNET", "MAGNETS", new ItemStack(ModBlocks.magnet, 1, 1), new AspectList().add(Aspect.AIR, 20).add(Aspect.ORDER, 5).add(Aspect.EARTH, 15).add(Aspect.ENTROPY, 5), " G ", "SGs", "WFW", Character.valueOf('G'), ModRecipes.oreDictOrStack(new ItemStack(Items.field_151043_k), "ingotCopper"), Character.valueOf('s'), new ItemStack(ConfigItems.itemShard, 1, 3), Character.valueOf('S'), new ItemStack(ConfigItems.itemShard), Character.valueOf('W'), new ItemStack(ConfigBlocks.blockMagicalLog), Character.valueOf('F'), new ItemStack(ModItems.focusTelekinesis));
        ModRecipes.registerResearchItem("FUNNEL", "FUNNEL", new ItemStack(ModBlocks.funnel), new AspectList().add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1), "STS", Character.valueOf('S'), new ItemStack(Blocks.field_150348_b), Character.valueOf('T'), new ItemStack(ConfigItems.itemResource, 1, 2));
        ModRecipes.registerResearchItem("FOCUS_SMELT", "FOCUS_SMELT", new ItemStack(ModItems.focusSmelt), new AspectList().add(Aspect.FIRE, 10).add(Aspect.ORDER, 5).add(Aspect.ENTROPY, 6), "FNE", Character.valueOf('F'), new ItemStack(ConfigItems.itemFocusFire), Character.valueOf('E'), new ItemStack(ConfigItems.itemFocusExcavation), Character.valueOf('N'), new ItemStack(ConfigItems.itemResource, 1, 1));
        if (Config.allowMirrors) {
            ModRecipes.registerResearchItem("DISLOCATOR", "DISLOCATOR", new ItemStack(ModBlocks.dislocator), new AspectList().add(Aspect.EARTH, 5).add(Aspect.ENTROPY, 5), " M ", " I ", " C ", Character.valueOf('M'), new ItemStack(ConfigItems.itemResource, 1, 10), Character.valueOf('I'), new ItemStack(ModBlocks.interfase), Character.valueOf('C'), new ItemStack(Items.field_151132_bS));
            ModRecipes.registerResearchItem("FOCUS_ENDER_CHEST", "FOCUS_ENDER_CHEST", new ItemStack(ModItems.focusEnderChest), new AspectList().add(Aspect.ORDER, 10).add(Aspect.ENTROPY, 10), "M", "E", "P", Character.valueOf('M'), new ItemStack(ConfigBlocks.blockMirror), Character.valueOf('E'), new ItemStack(Items.field_151061_bv), Character.valueOf('P'), new ItemStack(ConfigItems.itemFocusPortableHole));
        }
        ModRecipes.registerResearchItem("REVEALING_HELM", "REVEALING_HELM", new ItemStack(ModItems.revealingHelm), new AspectList().add(Aspect.EARTH, 5).add(Aspect.FIRE, 5).add(Aspect.WATER, 5).add(Aspect.AIR, 5).add(Aspect.ORDER, 5).add(Aspect.ENTROPY, 5), "GH", Character.valueOf('G'), new ItemStack(ConfigItems.itemGoggles), Character.valueOf('H'), new ItemStack(ConfigItems.itemHelmetThaumium));
        ModRecipes.registerResearchItem("ASPECT_ANALYZER", "ASPECT_ANALYZER", new ItemStack(ModBlocks.aspectAnalyzer), new AspectList().add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1), "TWT", "WMW", "TWT", Character.valueOf('W'), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6), Character.valueOf('M'), new ItemStack(ConfigItems.itemThaumometer), Character.valueOf('T'), new ItemStack(ConfigItems.itemResource, 1, 2));
        ModRecipes.registerResearchItem("PLATFORM", "PLATFORM", new ItemStack(ModBlocks.platform, 2), new AspectList().add(Aspect.AIR, 2).add(Aspect.ENTROPY, 4), " S ", "G G", Character.valueOf('G'), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6), Character.valueOf('S'), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 7));
        ModRecipes.registerResearchItem("LEVITATOR_RELAY", "LEVITATOR", new ItemStack(ModBlocks.mobilizerRelay), new AspectList().add(Aspect.AIR, 20).add(Aspect.ORDER, 5).add(Aspect.EARTH, 15), "WFW", "SIs", "WFW", Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('s'), new ItemStack(ConfigItems.itemShard, 1, 3), Character.valueOf('S'), new ItemStack(ConfigItems.itemShard), Character.valueOf('W'), new ItemStack(ConfigBlocks.blockMagicalLog), Character.valueOf('F'), new ItemStack(Blocks.field_150359_w));
        if (Loader.isModLoaded((String)"ComputerCraft")) {
            ModRecipes.registerResearchItem("GOLEM_CONNECTOR", "GOLEM_CONNECTOR", new ItemStack(ModBlocks.golemConnector), new AspectList().add(Aspect.AIR, 20).add(Aspect.ORDER, 5).add(Aspect.ENTROPY, 15), "WFW", "sIs", "WFW", Character.valueOf('I'), new ItemStack(ConfigItems.itemGolemBell), Character.valueOf('s'), new ItemStack(Items.field_151079_bi), Character.valueOf('W'), new ItemStack(ConfigBlocks.blockMagicalLog), Character.valueOf('F'), new ItemStack(Blocks.field_150451_bX));
        }
        if (ConfigHandler.enableKami) {
            ModRecipes.registerResearchItem("ICHOR_CLOTH", "ICHOR_CLOTH", new ItemStack(ModItems.kamiResource, 3, 1), new AspectList().add(Aspect.FIRE, 125).add(Aspect.EARTH, 125).add(Aspect.WATER, 125).add(Aspect.AIR, 125).add(Aspect.ORDER, 125).add(Aspect.ENTROPY, 125), "CCC", "III", "DDD", Character.valueOf('C'), new ItemStack(ConfigItems.itemResource, 1, 7), Character.valueOf('I'), new ItemStack(ModItems.kamiResource, 1, 0), Character.valueOf('D'), new ItemStack(Items.field_151045_i));
            ModRecipes.registerResearchItem("ICHORIUM", "ICHORIUM", new ItemStack(ModItems.kamiResource, 1, 2), new AspectList().add(Aspect.FIRE, 100).add(Aspect.EARTH, 100).add(Aspect.WATER, 100).add(Aspect.AIR, 100).add(Aspect.ORDER, 100).add(Aspect.ENTROPY, 100), " T ", "IDI", " I ", Character.valueOf('T'), new ItemStack(ConfigItems.itemResource, 1, 2), Character.valueOf('I'), new ItemStack(ModItems.kamiResource, 1, 0), Character.valueOf('D'), new ItemStack(Items.field_151045_i));
            ModRecipes.registerResearchItem("CAP_ICHOR", "CAP_ICHOR", new ItemStack(ModItems.kamiResource, 2, 4), new AspectList().add(Aspect.FIRE, 100).add(Aspect.EARTH, 100).add(Aspect.WATER, 100).add(Aspect.AIR, 100).add(Aspect.ORDER, 100).add(Aspect.ENTROPY, 100), "ICI", " M ", "ICI", Character.valueOf('M'), new ItemStack(ModItems.kamiResource, 1, 2), Character.valueOf('I'), new ItemStack(ModItems.kamiResource, 1, 0), Character.valueOf('C'), new ItemStack(ConfigItems.itemWandCap, 1, 2));
            ModRecipes.registerResearchItem("ICHORCLOTH_HELM", "ICHORCLOTH_ARMOR", new ItemStack(ModItems.ichorHelm), new AspectList().add(Aspect.WATER, 75), "CCC", "C C", Character.valueOf('C'), new ItemStack(ModItems.kamiResource, 1, 1));
            ModRecipes.registerResearchItem("ICHORCLOTH_CHEST", "ICHORCLOTH_ARMOR", new ItemStack(ModItems.ichorChest), new AspectList().add(Aspect.AIR, 75), "C C", "CCC", "CCC", Character.valueOf('C'), new ItemStack(ModItems.kamiResource, 1, 1));
            ModRecipes.registerResearchItem("ICHORCLOTH_LEGS", "ICHORCLOTH_ARMOR", new ItemStack(ModItems.ichorLegs), new AspectList().add(Aspect.FIRE, 75), "CCC", "C C", "C C", Character.valueOf('C'), new ItemStack(ModItems.kamiResource, 1, 1));
            ModRecipes.registerResearchItem("ICHORCLOTH_BOOTS", "ICHORCLOTH_ARMOR", new ItemStack(ModItems.ichorBoots), new AspectList().add(Aspect.EARTH, 75), "C C", "C C", Character.valueOf('C'), new ItemStack(ModItems.kamiResource, 1, 1));
            ModRecipes.registerResearchItem("ICHOR_PICK", "ICHOR_TOOLS", new ItemStack(ModItems.ichorPick), new AspectList().add(Aspect.FIRE, 75), "III", " R ", " R ", Character.valueOf('R'), new ItemStack(ConfigItems.itemWandRod, 1, 2), Character.valueOf('I'), new ItemStack(ModItems.kamiResource, 1, 2));
            ModRecipes.registerResearchItem("ICHOR_SHOVEL", "ICHOR_TOOLS", new ItemStack(ModItems.ichorShovel), new AspectList().add(Aspect.EARTH, 75), " I ", " R ", " R ", Character.valueOf('R'), new ItemStack(ConfigItems.itemWandRod, 1, 2), Character.valueOf('I'), new ItemStack(ModItems.kamiResource, 1, 2));
            ModRecipes.registerResearchItem("ICHOR_AXE", "ICHOR_TOOLS", new ItemStack(ModItems.ichorAxe), new AspectList().add(Aspect.WATER, 75), "II ", "IR ", " R ", Character.valueOf('R'), new ItemStack(ConfigItems.itemWandRod, 1, 2), Character.valueOf('I'), new ItemStack(ModItems.kamiResource, 1, 2));
            ModRecipes.registerResearchItem("", "ICHOR_TOOLS", new ItemStack(ModItems.ichorAxe), new AspectList().add(Aspect.WATER, 75), " II", " RI", " R ", Character.valueOf('R'), new ItemStack(ConfigItems.itemWandRod, 1, 2), Character.valueOf('I'), new ItemStack(ModItems.kamiResource, 1, 2));
            ModRecipes.registerResearchItem("ICHOR_SWORD", "ICHOR_TOOLS", new ItemStack(ModItems.ichorSword), new AspectList().add(Aspect.AIR, 75), " I ", " I ", " R ", Character.valueOf('R'), new ItemStack(ConfigItems.itemWandRod, 1, 2), Character.valueOf('I'), new ItemStack(ModItems.kamiResource, 1, 2));
        }
    }

    private static void initInfusionRecipes() {
        ModRecipes.registerResearchItemI("FOCUS_FLIGHT", new ItemStack(ModItems.focusFlight), 3, new AspectList().add(Aspect.AIR, 15).add(Aspect.MOTION, 20).add(Aspect.TRAVEL, 10), new ItemStack(Items.field_151079_bi), new ItemStack(Items.field_151128_bU), new ItemStack(Items.field_151128_bU), new ItemStack(Items.field_151128_bU), new ItemStack(Items.field_151128_bU), new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151008_G), new ItemStack(ConfigItems.itemShard, 1, 0));
        ModRecipes.registerResearchItemI("FOCUS_DISLOCATION", new ItemStack(ModItems.focusDislocation), 8, new AspectList().add(Aspect.ELDRITCH, 20).add(Aspect.DARKNESS, 10).add(Aspect.VOID, 25).add(Aspect.MAGIC, 20).add(Aspect.TAINT, 5), new ItemStack(Items.field_151079_bi), new ItemStack(Items.field_151128_bU), new ItemStack(Items.field_151128_bU), new ItemStack(Items.field_151128_bU), new ItemStack(Items.field_151128_bU), new ItemStack(ConfigItems.itemResource, 1, 6), new ItemStack(ConfigItems.itemResource, 1, 6), new ItemStack(ConfigItems.itemResource, 1, 6), new ItemStack(Items.field_151045_i));
        ModRecipes.registerResearchItemI("FOCUS_TELEKINESIS", new ItemStack(ModItems.focusTelekinesis), 5, new AspectList().add(Aspect.MOTION, 10).add(Aspect.AIR, 20).add(Aspect.ENTROPY, 20).add(Aspect.MIND, 10), new ItemStack(Items.field_151079_bi), new ItemStack(Items.field_151128_bU), new ItemStack(Items.field_151128_bU), new ItemStack(Items.field_151128_bU), new ItemStack(Items.field_151128_bU), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151043_k), new ItemStack(ConfigItems.itemShard, 1, 0));
        ModRecipes.registerResearchItemI("CLEANSING_TALISMAN", new ItemStack(ModItems.cleansingTalisman), 5, new AspectList().add(Aspect.HEAL, 10).add(Aspect.TOOL, 10).add(Aspect.MAN, 20).add(Aspect.LIFE, 10), new ItemStack(Items.field_151079_bi), new ItemStack(ModItems.darkQuartz), new ItemStack(ModItems.darkQuartz), new ItemStack(ModItems.darkQuartz), new ItemStack(ModItems.darkQuartz), new ItemStack(Items.field_151073_bk), new ItemStack(ConfigItems.itemResource, 1, 1));
        ModRecipes.registerResearchItemI("ENCHANTER", new ItemStack(ModBlocks.enchanter), 15, new AspectList().add(Aspect.MAGIC, 50).add(Aspect.ENERGY, 20).add(Aspect.ELDRITCH, 20).add(Aspect.VOID, 20).add(Aspect.MIND, 10), new ItemStack(Blocks.field_150381_bn), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 1), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 1), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 1), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 1), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 1), new ItemStack(ConfigItems.itemResource, 1, 2), new ItemStack(ConfigItems.itemResource, 1, 2), new ItemStack(ModItems.spellCloth));
        ModRecipes.registerResearchItemI("XP_TALISMAN", new ItemStack(ModItems.xpTalisman), 6, new AspectList().add(Aspect.GREED, 20).add(Aspect.EXCHANGE, 10).add(Aspect.BEAST, 10).add(Aspect.MECHANISM, 5), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151128_bU), new ItemStack(ModItems.darkQuartz), new ItemStack(ConfigItems.itemResource, 1, 5), new ItemStack(Items.field_151045_i));
        ModRecipes.registerResearchItemI("FOCUS_HEAL", new ItemStack(ModItems.focusHeal), 4, new AspectList().add(Aspect.HEAL, 10).add(Aspect.SOUL, 10).add(Aspect.LIFE, 15), new ItemStack(ConfigItems.itemFocusPech), new ItemStack(Items.field_151150_bK), new ItemStack(Items.field_151074_bl), new ItemStack(Items.field_151074_bl), new ItemStack(Items.field_151074_bl));
        ModRecipes.registerResearchItemI("BLOOD_SWORD", new ItemStack(ModItems.bloodSword), 6, new AspectList().add(Aspect.HUNGER, 20).add(Aspect.DARKNESS, 5).add(Aspect.SOUL, 10).add(Aspect.MAN, 6), new ItemStack(ConfigItems.itemSwordThaumium), new ItemStack(Items.field_151078_bh), new ItemStack(Items.field_151147_al), new ItemStack(Items.field_151082_bd), new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151045_i), new ItemStack(Items.field_151073_bk));
        ModRecipes.registerResearchItemI("INFUSED_INKWELL", new ItemStack(ModItems.infusedInkwell), 2, new AspectList().add(Aspect.VOID, 8).add(Aspect.DARKNESS, 8), new ItemStack(ConfigItems.itemInkwell), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(ConfigBlocks.blockJar), new ItemStack(ConfigItems.itemResource, 1, 3));
        ModRecipes.registerResearchItemI("REPAIRER", new ItemStack(ModBlocks.repairer), 8, new AspectList().add(Aspect.TOOL, 15).add(Aspect.CRAFT, 20).add(Aspect.ORDER, 10).add(Aspect.MAGIC, 15), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 4), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151045_i), new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150344_f), new ItemStack(Items.field_151116_aA), new ItemStack(ConfigItems.itemResource, 1, 7), new ItemStack(ConfigItems.itemResource, 1, 2));
        ModRecipes.registerResearchItemI("LEVITATOR", new ItemStack(ModBlocks.mobilizer), 4, new AspectList().add(Aspect.MOTION, 15).add(Aspect.ORDER, 20).add(Aspect.MAGIC, 15), new ItemStack(ConfigBlocks.blockLifter), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151042_j), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 1));
        for (int i = 0; i < NumericAspectHelper.values.size(); ++i) {
            ItemStack input = new ItemStack((Item)ModItems.mobAspect, 1, i + 20);
            ModRecipes.registerResearchItemI("SUMMON", new ItemStack((Item)ModItems.mobAspect, 1, i + 40), 4, new AspectList().add(ModItems.mobAspect.getAspect(new ItemStack((Item)ModItems.mobAspect, 1, i)), 10), input, input, input, input, input, input, input, input, input);
        }
        if (Config.allowMirrors) {
            ModRecipes.registerResearchItemI("FOCUS_DEFLECT", new ItemStack(ModItems.focusDeflect), 5, new AspectList().add(Aspect.AIR, 15).add(Aspect.ARMOR, 5).add(Aspect.ORDER, 20), new ItemStack(ModItems.focusFlight), new ItemStack(ConfigItems.itemResource, 1, 10), new ItemStack(ConfigItems.itemResource, 1, 10), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 3), new ItemStack(ConfigItems.itemShard, 1, 4));
        }
        if (ConfigHandler.enableKami) {
            ModRecipes.registerResearchItemI("ICHOR", new ItemStack(ModItems.kamiResource, 8, 0), 7, new AspectList().add(Aspect.MAN, 32).add(Aspect.LIGHT, 32).add(Aspect.SOUL, 64), new ItemStack(Items.field_151156_bN), new ItemStack(Items.field_151045_i), new ItemStack(ModItems.kamiResource, 8, 7), new ItemStack(Items.field_151061_bv), new ItemStack(ModItems.kamiResource, 8, 6));
            ModRecipes.registerResearchItemI("ROD_ICHORCLOTH", new ItemStack(ModItems.kamiResource, 1, 5), 9, new AspectList().add(Aspect.MAGIC, 100).add(Aspect.LIGHT, 32).add(Aspect.TOOL, 32), new ItemStack(ConfigItems.itemWandRod, 1, 2), new ItemStack(ModItems.kamiResource), new ItemStack(ModItems.kamiResource, 1, 1), new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(Items.field_151073_bk), new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ModItems.kamiResource, 1, 1));
            ModRecipes.registerResearchItemI("ICHORCLOTH_HELM_GEM", new ItemStack(ModItems.ichorHelmGem), 13, new AspectList().add(Aspect.WATER, 50).add(Aspect.ARMOR, 32).add(Aspect.HUNGER, 32).add(Aspect.AURA, 32).add(Aspect.LIGHT, 64).add(Aspect.FLESH, 16).add(Aspect.MIND, 16), new ItemStack(ModItems.ichorHelm), new ItemStack(Items.field_151045_i, 1), new ItemStack(ModItems.kamiResource), new ItemStack(ModItems.kamiResource), new ItemStack(ConfigItems.itemManaBean), new ItemStack(ConfigItems.itemWispEssence), new ItemStack((Item)Items.field_151169_ag), new ItemStack((Item)Items.field_151068_bn, 1, 8198), new ItemStack(ConfigItems.itemGoggles), new ItemStack(ModItems.cleansingTalisman), new ItemStack(Items.field_151115_aP), new ItemStack(Items.field_151105_aU), new ItemStack(Items.field_151061_bv));
            ModRecipes.registerResearchItemI("ICHORCLOTH_CHEST_GEM", new ItemStack(ModItems.ichorChestGem), 13, new AspectList().add(Aspect.AIR, 50).add(Aspect.ARMOR, 32).add(Aspect.FLIGHT, 32).add(Aspect.ORDER, 32).add(Aspect.LIGHT, 64).add(Aspect.ELDRITCH, 16).add(Aspect.SENSES, 16), new ItemStack(ModItems.ichorChest), new ItemStack(Items.field_151045_i, 1), new ItemStack(ModItems.kamiResource), new ItemStack(ModItems.kamiResource), new ItemStack(ConfigItems.itemManaBean), new ItemStack(ConfigItems.itemWispEssence), new ItemStack((Item)Items.field_151171_ah), new ItemStack(ModItems.focusFlight), new ItemStack(ConfigItems.itemHoverHarness), new ItemStack(ModItems.focusDeflect), new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151152_bP), new ItemStack(Items.field_151032_g));
            ModRecipes.registerResearchItemI("ICHORCLOTH_LEGS_GEM", new ItemStack(ModItems.ichorLegsGem), 13, new AspectList().add(Aspect.FIRE, 50).add(Aspect.ARMOR, 32).add(Aspect.HEAL, 32).add(Aspect.ENERGY, 32).add(Aspect.LIGHT, 64).add(Aspect.GREED, 16).add(Aspect.ELDRITCH, 16), new ItemStack(ModItems.ichorLegs), new ItemStack(Items.field_151045_i, 1), new ItemStack(ModItems.kamiResource), new ItemStack(ModItems.kamiResource), new ItemStack(ConfigItems.itemManaBean), new ItemStack(ConfigItems.itemWispEssence), new ItemStack((Item)Items.field_151171_ah), new ItemStack((Item)Items.field_151068_bn, 1, 8195), new ItemStack(ModItems.focusSmelt), new ItemStack(ModItems.brightNitor), new ItemStack(Items.field_151129_at), new ItemStack(Items.field_151059_bz), new ItemStack(Items.field_151072_bj));
            ModRecipes.registerResearchItemI("ICHORCLOTH_BOOTS_GEM", new ItemStack(ModItems.ichorBootsGem), 13, new AspectList().add(Aspect.EARTH, 50).add(Aspect.ARMOR, 32).add(Aspect.MINE, 32).add(Aspect.MOTION, 32).add(Aspect.LIGHT, 64).add(Aspect.PLANT, 16).add(Aspect.TRAVEL, 16), new ItemStack(ModItems.ichorBoots), new ItemStack(Items.field_151045_i, 1), new ItemStack(ModItems.kamiResource), new ItemStack(ModItems.kamiResource), new ItemStack(ConfigItems.itemManaBean), new ItemStack(ConfigItems.itemWispEssence), new ItemStack((Item)Items.field_151151_aj), new ItemStack((Block)Blocks.field_150349_c), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 5), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 8), new ItemStack(Items.field_151014_N), new ItemStack(Blocks.field_150325_L), new ItemStack(Items.field_151058_ca));
            ModRecipes.registerResearchItemI("CAT_AMULET", new ItemStack(ModItems.catAmulet), 8, new AspectList().add(Aspect.DARKNESS, 16).add(Aspect.ORDER, 32).add(Aspect.MIND, 16), new ItemStack(Blocks.field_150371_ca), new ItemStack(ModItems.kamiResource), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151100_aR, 1, 3), new ItemStack((Block)Blocks.field_150362_t, 1, 3), new ItemStack(Items.field_151115_aP));
            ModRecipes.registerResearchItemI("ICHOR_PICK_GEM", new ItemStack(ModItems.ichorPickGem), 15, new AspectList().add(Aspect.FIRE, 50).add(Aspect.MINE, 64).add(Aspect.METAL, 32).add(Aspect.EARTH, 32).add(Aspect.HARVEST, 32).add(Aspect.GREED, 16).add(Aspect.SENSES, 16), new ItemStack(ModItems.ichorPick), new ItemStack(ModItems.kamiResource, 1, 2), new ItemStack(ModItems.kamiResource), new ItemStack(ConfigItems.itemPickElemental), new ItemStack(ConfigItems.itemFocusExcavation), new ItemStack(Blocks.field_150335_W), new ItemStack(ConfigItems.itemNugget, 1, 21), new ItemStack(ConfigItems.itemNugget, 1, 16), new ItemStack(ConfigItems.itemNugget, 1, 31), new ItemStack(Items.field_151045_i), new ItemStack(ConfigItems.itemFocusExcavation), new ItemStack(ConfigItems.itemPickElemental), new ItemStack(ModItems.kamiResource, 1, 1));
            ModRecipes.registerResearchItemI("ICHOR_SHOVEL_GEM", new ItemStack(ModItems.ichorShovelGem), 15, new AspectList().add(Aspect.EARTH, 50).add(Aspect.MINE, 64).add(Aspect.TOOL, 32).add(Aspect.EARTH, 32).add(Aspect.HARVEST, 32).add(Aspect.TRAP, 16).add(Aspect.SENSES, 16), new ItemStack(ModItems.ichorShovel), new ItemStack(ModItems.kamiResource, 1, 2), new ItemStack(ModItems.kamiResource), new ItemStack(ConfigItems.itemShovelElemental), new ItemStack(ConfigItems.itemFocusExcavation), new ItemStack(Blocks.field_150335_W), new ItemStack(ConfigItems.itemNugget, 1, 21), new ItemStack(ConfigItems.itemNugget, 1, 16), new ItemStack(ConfigItems.itemNugget, 1, 31), new ItemStack(Items.field_151045_i), new ItemStack(ConfigItems.itemFocusExcavation), new ItemStack(ConfigItems.itemShovelElemental), new ItemStack(ModItems.kamiResource, 1, 1));
            ModRecipes.registerResearchItemI("ICHOR_AXE_GEM", new ItemStack(ModItems.ichorAxeGem), 15, new AspectList().add(Aspect.WATER, 50).add(Aspect.MINE, 64).add(Aspect.TOOL, 32).add(Aspect.TREE, 32).add(Aspect.HARVEST, 32).add(Aspect.CROP, 16).add(Aspect.SENSES, 16), new ItemStack(ModItems.ichorAxe), new ItemStack(ModItems.kamiResource, 1, 2), new ItemStack(ModItems.kamiResource), new ItemStack(ConfigItems.itemAxeElemental), new ItemStack(ConfigItems.itemFocusExcavation), new ItemStack(Blocks.field_150335_W), new ItemStack(ConfigItems.itemNugget, 1, 21), new ItemStack(ConfigItems.itemNugget, 1, 16), new ItemStack(ConfigItems.itemNugget, 1, 31), new ItemStack(Items.field_151045_i), new ItemStack(ConfigItems.itemFocusExcavation), new ItemStack(ConfigItems.itemAxeElemental), new ItemStack(ModItems.kamiResource, 1, 1));
            ModRecipes.registerResearchItemI("ICHOR_SWORD_GEM", new ItemStack(ModItems.ichorSwordGem), 15, new AspectList().add(Aspect.AIR, 50).add(Aspect.HUNGER, 64).add(Aspect.SOUL, 32).add(Aspect.WEAPON, 32).add(Aspect.ENERGY, 32).add(Aspect.ORDER, 16).add(Aspect.CRYSTAL, 16), new ItemStack(ModItems.ichorSword), new ItemStack(ModItems.kamiResource, 1, 2), new ItemStack(ModItems.kamiResource), new ItemStack(ConfigItems.itemSwordElemental), new ItemStack(ConfigItems.itemFocusFrost), new ItemStack(Blocks.field_150434_aF), new ItemStack(ConfigItems.itemNugget, 1, 21), new ItemStack(ConfigItems.itemNugget, 1, 16), new ItemStack(ConfigItems.itemNugget, 1, 31), new ItemStack(Items.field_151045_i), new ItemStack(ConfigItems.itemFocusFrost), new ItemStack(ConfigItems.itemSwordElemental), new ItemStack(ModItems.kamiResource, 1, 1));
            ModRecipes.registerResearchItemI("ICHOR_POUCH", new ItemStack(ModItems.ichorPouch), 9, new AspectList().add(Aspect.VOID, 64).add(Aspect.MAN, 32).add(Aspect.CLOTH, 32).add(Aspect.ELDRITCH, 32).add(Aspect.AIR, 64), new ItemStack(ConfigItems.itemFocusPouch), new ItemStack(ModItems.kamiResource, 1, 1), new ItemStack(ConfigItems.itemFocusPortableHole), new ItemStack(Items.field_151045_i), new ItemStack(ModItems.kamiResource, 1, 1), new ItemStack(ConfigBlocks.blockChestHungry), new ItemStack(ConfigBlocks.blockJar, 1, 3));
            if (Loader.isModLoaded((String)"EnderStorage")) {
                EnderStorageRecepie.loadRecipes();
            }
            ModRecipes.registerResearchItemI("BLOCK_TALISMAN", new ItemStack(ModItems.blockTalisman), 9, new AspectList().add(Aspect.VOID, 65).add(Aspect.DARKNESS, 32).add(Aspect.MAGIC, 50).add(Aspect.ELDRITCH, 32), new ItemStack(ConfigItems.itemFocusPortableHole), new ItemStack(ModItems.kamiResource), new ItemStack(Blocks.field_150477_bB), new ItemStack(Items.field_151045_i), new ItemStack(ModItems.kamiResource), new ItemStack(ConfigItems.itemResource, 1, 11), new ItemStack(ConfigBlocks.blockJar, 1, 3));
            ModRecipes.registerResearchItemI("PLACEMENT_MIRROR", new ItemStack(ModItems.placementMirror), 12, new AspectList().add(Aspect.CRAFT, 65).add(Aspect.CRYSTAL, 32).add(Aspect.MAGIC, 50).add(Aspect.MIND, 32), new ItemStack(ModItems.blockTalisman), new ItemStack(ModItems.kamiResource), new ItemStack(Blocks.field_150409_cd), new ItemStack(Items.field_151045_i), new ItemStack(Blocks.field_150359_w), new ItemStack(Items.field_151065_br), new ItemStack(ModItems.kamiResource));
            ModRecipes.registerResearchItemI("FOCUS_SHADOWBEAM", new ItemStack(ModItems.focusShadowbeam), 12, new AspectList().add(Aspect.DARKNESS, 65).add(Aspect.ELDRITCH, 32).add(Aspect.MAGIC, 50).add(Aspect.WEAPON, 32), new ItemStack(ConfigItems.itemFocusShock), new ItemStack(ModItems.kamiResource), new ItemStack(Items.field_151032_g), new ItemStack(Items.field_151045_i), new ItemStack(ConfigItems.itemFocusExcavation), new ItemStack(ModItems.focusDeflect), new ItemStack(ModItems.kamiResource));
            ModRecipes.registerResearchItemI("FOCUS_XP_DRAIN", new ItemStack(ModItems.focusXPDrain), 12, new AspectList().add(Aspect.MIND, 65).add(Aspect.TAINT, 16).add(Aspect.MAGIC, 50).add(Aspect.AURA, 32), new ItemStack(Items.field_151079_bi), new ItemStack(ModItems.kamiResource), new ItemStack(Items.field_151062_by), new ItemStack(Items.field_151045_i), new ItemStack(ModItems.xpTalisman), new ItemStack(Blocks.field_150381_bn), new ItemStack(ModItems.kamiResource));
            ModRecipes.registerResearchItemI("PROTOCLAY", new ItemStack(ModItems.protoclay), 4, new AspectList().add(Aspect.MINE, 16).add(Aspect.TOOL, 16), new ItemStack(Items.field_151119_aD), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150348_b), new ItemStack(Blocks.field_150364_r), new ItemStack(ModItems.kamiResource, 1, 7));
            if (Config.allowMirrors) {
                ModRecipes.registerResearchItemI("WARP_GATE", new ItemStack(ModBlocks.warpGate), 8, new AspectList().add(Aspect.TRAVEL, 64).add(Aspect.ELDRITCH, 50).add(Aspect.FLIGHT, 50), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 2), new ItemStack(ModItems.kamiResource), new ItemStack(ModItems.kamiResource, 1, 7), new ItemStack(ModBlocks.dislocator), new ItemStack(ModItems.kamiResource, 1, 6), new ItemStack(Items.field_151045_i), new ItemStack(Items.field_151008_G));
                ModRecipes.registerResearchItemI("SKY_PEARL", "WARP_GATE", new ItemStack(ModItems.skyPearl, 2), 6, new AspectList().add(Aspect.TRAVEL, 32).add(Aspect.ELDRITCH, 32).add(Aspect.FLIGHT, 32).add(Aspect.AIR, 16), new ItemStack(Items.field_151079_bi), new ItemStack(ModItems.kamiResource), new ItemStack(ModItems.kamiResource, 1, 7), new ItemStack(Blocks.field_150368_y), new ItemStack(Items.field_151045_i));
                ModRecipes.registerResearchItemI("FOCUS_RECALL", new ItemStack(ModItems.focusRecall), 10, new AspectList().add(Aspect.TRAVEL, 100).add(Aspect.ELDRITCH, 64).add(Aspect.MAGIC, 50), new ItemStack(ModItems.skyPearl), new ItemStack(ModItems.kamiResource), new ItemStack(ModItems.kamiResource), new ItemStack(Items.field_151079_bi), new ItemStack(Items.field_151045_i), new ItemStack(ConfigBlocks.blockMirror), new ItemStack(ConfigItems.itemFocusPortableHole));
            }
        }
    }

    private static void initCrucibleRecipes() {
        ModRecipes.registerResearchItem("GASEOUS_LIGHT", new ItemStack(ModItems.gaseousLight), new ItemStack(ConfigItems.itemEssence, 1, 0), new AspectList().add(Aspect.LIGHT, 16).add(Aspect.AIR, 10).add(Aspect.MOTION, 8));
        ModRecipes.registerResearchItem("GASEOUS_SHADOW", new ItemStack(ModItems.gaseousShadow), new ItemStack(ConfigItems.itemEssence, 1, 0), new AspectList().add(Aspect.DARKNESS, 16).add(Aspect.AIR, 10).add(Aspect.MOTION, 8));
        ModRecipes.registerResearchItem("SPELL_CLOTH", new ItemStack(ModItems.spellCloth), new ItemStack(ConfigItems.itemResource, 0, 7), new AspectList().add(Aspect.MAGIC, 10).add(Aspect.ENTROPY, 6).add(Aspect.EXCHANGE, 4));
        ModRecipes.registerResearchItem("BRIGHT_NITOR", new ItemStack(ModItems.brightNitor), new ItemStack(ConfigItems.itemResource, 1, 1), new AspectList().add(Aspect.ENERGY, 25).add(Aspect.LIGHT, 25).add(Aspect.AIR, 10).add(Aspect.FIRE, 10));
        ModRecipes.registerResearchItem("MAGNETS", new ItemStack(ModItems.soulMould), new ItemStack(Items.field_151079_bi), new AspectList().add(Aspect.BEAST, 4).add(Aspect.MIND, 8).add(Aspect.SENSES, 8));
    }

    private static void registerResearchItem(String name, String research, ItemStack output, AspectList aspects, Object ... stuff) {
        ShapedArcaneRecipe recipe = ThaumcraftApi.addArcaneCraftingRecipe((String)research, (ItemStack)output, (AspectList)aspects, (Object[])stuff);
        ConfigResearch.recipes.put(name, recipe);
    }

    private static void registerResearchItem(String name, ItemStack output, Object ... stuff) {
        GameRegistry.addRecipe((ItemStack)output, (Object[])stuff);
        List recipeList = CraftingManager.func_77594_a().func_77592_b();
        if (name != null && name.length() != 0) {
            ConfigResearch.recipes.put(name, recipeList.get(recipeList.size() - 1));
        }
    }

    private static void registerResearchItem(String name, ItemStack output, ItemStack input, AspectList aspects) {
        CrucibleRecipe recipe = ThaumcraftApi.addCrucibleRecipe((String)name, (ItemStack)output, (Object)input, (AspectList)aspects);
        ConfigResearch.recipes.put(name, recipe);
    }

    static void registerResearchItemI(String name, Object output, int instability, AspectList aspects, ItemStack input, ItemStack ... stuff) {
        ModRecipes.registerResearchItemI(name, name, output, instability, aspects, input, stuff);
    }

    private static void registerResearchItemI(String name, String research, Object output, int instability, AspectList aspects, ItemStack input, ItemStack ... stuff) {
        InfusionRecipe recipe = ThaumcraftApi.addInfusionCraftingRecipe((String)research, (Object)output, (int)instability, (AspectList)aspects, (ItemStack)input, (ItemStack[])stuff);
        ConfigResearch.recipes.put(name, recipe);
    }

    private static Object oreDictOrStack(ItemStack stack, String oreDict) {
        return OreDictionary.getOres((String)oreDict).isEmpty() && ConfigHandler.useOreDictMetal ? stack : oreDict;
    }
}

