/*
 * Decompiled with CFR 0.152.
 */
package vazkii.tinkerer.common.item.foci;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.IWandFocus;
import thaumcraft.common.config.Config;
import vazkii.tinkerer.client.core.helper.IconHelper;
import vazkii.tinkerer.common.item.ItemMod;

public abstract class ItemModFocus
extends ItemMod
implements IWandFocus {
    private IIcon ornament;
    private IIcon depth;

    public ItemModFocus() {
        this.func_77656_e(1);
        this.setNoRepair();
        this.func_77625_d(1);
    }

    protected boolean hasOrnament() {
        return false;
    }

    protected boolean hasDepth() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        super.func_94581_a(par1IconRegister);
        if (this.hasOrnament()) {
            this.ornament = IconHelper.forItem(par1IconRegister, (Item)this, "Orn");
        }
        if (this.hasDepth()) {
            this.depth = IconHelper.forItem(par1IconRegister, (Item)this, "Depth");
        }
    }

    public boolean func_77616_k(ItemStack par1ItemStack) {
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        AspectList cost = this.getVisCost();
        if (cost != null) {
            list.add(StatCollector.func_74838_a((String)(this.isVisCostPerTick() ? "item.Focus.cost2" : "item.Focus.cost1")));
            this.addVisCostTooltip(cost, stack, player, list, par4);
        }
    }

    protected void addVisCostTooltip(AspectList cost, ItemStack stack, EntityPlayer player, List list, boolean par4) {
        for (Aspect aspect : cost.getAspectsSorted()) {
            float amount = (float)cost.getAmount(aspect) / 100.0f;
            list.add(" \u00a7" + aspect.getChatcolor() + aspect.getName() + '\u00a7' + "r x " + amount);
        }
    }

    public int func_77619_b() {
        return 5;
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.rare;
    }

    public IIcon getOrnament() {
        return this.ornament;
    }

    public IIcon getFocusDepthLayerIcon() {
        return this.depth;
    }

    public IWandFocus.WandFocusAnimation getAnimation() {
        return IWandFocus.WandFocusAnimation.WAVE;
    }

    public boolean isVisCostPerTick() {
        return false;
    }

    public boolean isUseItem() {
        return this.isVisCostPerTick();
    }

    public ItemStack onFocusRightClick(ItemStack paramItemStack, World paramWorld, EntityPlayer paramEntityPlayer, MovingObjectPosition paramMovingObjectPosition) {
        if (this.isUseItem()) {
            paramEntityPlayer.func_71008_a(paramItemStack, Integer.MAX_VALUE);
        }
        return paramItemStack;
    }

    public void onUsingFocusTick(ItemStack paramItemStack, EntityPlayer paramEntityPlayer, int paramInt) {
    }

    public void onPlayerStoppedUsingFocus(ItemStack paramItemStack, World paramWorld, EntityPlayer paramEntityPlayer, int paramInt) {
    }

    public abstract String getSortingHelper(ItemStack var1);

    public boolean onFocusBlockStartBreak(ItemStack paramItemStack, int paramInt1, int paramInt2, int paramInt3, EntityPlayer paramEntityPlayer) {
        return false;
    }

    public boolean acceptsEnchant(int paramInt) {
        return paramInt != Config.enchWandFortune.field_77352_x;
    }
}

