/*
 * Decompiled with CFR 0.152.
 */
package vazkii.tinkerer.common.item.foci;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.config.Config;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.Utils;
import vazkii.tinkerer.common.ThaumicTinkerer;
import vazkii.tinkerer.common.item.foci.ItemModFocus;

public class ItemFocusSmelt
extends ItemModFocus {
    public static Map<String, SmeltData> playerData = new HashMap<String, SmeltData>();
    private static final AspectList visUsage = new AspectList().add(Aspect.FIRE, 45).add(Aspect.ENTROPY, 12);

    @Override
    public boolean isUseItem() {
        return true;
    }

    @Override
    public void onUsingFocusTick(ItemStack stack, EntityPlayer p, int time) {
        ItemWandCasting wand = (ItemWandCasting)stack.func_77973_b();
        if (!wand.consumeAllVis(stack, p, visUsage, false, false)) {
            return;
        }
        MovingObjectPosition pos = Utils.getTargetBlock((World)p.field_70170_p, (Entity)p, (boolean)false);
        if (pos != null) {
            Block block = p.field_70170_p.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
            int meta = p.field_70170_p.func_72805_g(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
            ItemStack blockStack = new ItemStack(block, 1, meta);
            ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(blockStack);
            if (result != null && result.func_77973_b() instanceof ItemBlock) {
                SmeltData data;
                boolean decremented = false;
                if (playerData.containsKey(p.func_146103_bH().getName()) && (data = playerData.get(p.func_146103_bH().getName())).equalPos(pos)) {
                    --data.progress;
                    decremented = true;
                    if (data.progress <= 0) {
                        if (!p.field_70170_p.field_72995_K) {
                            p.field_70170_p.func_147465_d(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, Block.func_149634_a((Item)result.func_77973_b()), result.func_77960_j(), 3);
                            p.field_70170_p.func_72956_a((Entity)p, "fire.ignite", 0.6f, 1.0f);
                            p.field_70170_p.func_72956_a((Entity)p, "fire.fire", 1.0f, 1.0f);
                            wand.consumeAllVis(stack, p, visUsage, true, false);
                            playerData.remove(p.func_146103_bH().getName());
                            decremented = false;
                        }
                        for (int i = 0; i < 25; ++i) {
                            double x = (double)pos.field_72311_b + Math.random();
                            double y = (double)pos.field_72312_c + Math.random();
                            double z = (double)pos.field_72309_d + Math.random();
                            ThaumicTinkerer.tcProxy.wispFX2(p.field_70170_p, x, y, z, (float)Math.random() / 2.0f, 4, true, (float)(-Math.random()) / 10.0f);
                        }
                    }
                }
                if (!decremented) {
                    int potency = EnchantmentHelper.func_77506_a((int)Config.enchPotency.field_77352_x, (ItemStack)wand.getFocusItem(stack));
                    playerData.put(p.func_146103_bH().getName(), new SmeltData(pos, 20 - Math.min(3, potency) * 5));
                } else {
                    for (int i = 0; i < 2; ++i) {
                        double x = (double)pos.field_72311_b + Math.random();
                        double y = (double)pos.field_72312_c + Math.random();
                        double z = (double)pos.field_72309_d + Math.random();
                        p.field_70170_p.func_72956_a((Entity)p, "fire.fire", (float)Math.random() / 2.0f + 0.5f, 1.0f);
                        ThaumicTinkerer.tcProxy.wispFX2(p.field_70170_p, x, y, z, (float)Math.random() / 2.0f, 4, true, (float)(-Math.random()) / 10.0f);
                    }
                }
                if (p.field_70170_p.field_72995_K) {
                    ThaumicTinkerer.tcProxy.beamCont(p.field_70170_p, p, (double)pos.field_72311_b + 0.5, (double)pos.field_72312_c + 0.5, (double)pos.field_72309_d + 0.5, 2, 0xFF0000, true, 0.0f, null, 1);
                }
            }
        }
    }

    @Override
    public String getSortingHelper(ItemStack itemstack) {
        return "SMELT";
    }

    @Override
    protected boolean hasOrnament() {
        return true;
    }

    public int getFocusColor() {
        return 0xFF0000;
    }

    public AspectList getVisCost() {
        return visUsage;
    }

    static class SmeltData {
        public MovingObjectPosition pos;
        public int progress;

        public SmeltData(MovingObjectPosition pos, int progress) {
            this.pos = pos;
            this.progress = progress;
        }

        public boolean equalPos(MovingObjectPosition pos) {
            return pos.field_72311_b == this.pos.field_72311_b && pos.field_72312_c == this.pos.field_72312_c && pos.field_72309_d == this.pos.field_72309_d;
        }
    }
}

