/*
 * Decompiled with CFR 0.152.
 */
package vazkii.tinkerer.common.core.proxy;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import li.cil.oc.api.Driver;
import li.cil.oc.api.driver.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import vazkii.tinkerer.common.ThaumicTinkerer;
import vazkii.tinkerer.common.block.ModBlocks;
import vazkii.tinkerer.common.block.tile.peripheral.OpenComputers.DriverArcaneBore;
import vazkii.tinkerer.common.block.tile.peripheral.OpenComputers.DriverArcaneEar;
import vazkii.tinkerer.common.block.tile.peripheral.OpenComputers.DriverBrainInAJar;
import vazkii.tinkerer.common.block.tile.peripheral.OpenComputers.DriverDeconstructor;
import vazkii.tinkerer.common.block.tile.peripheral.OpenComputers.DriverEssentiaTransport;
import vazkii.tinkerer.common.block.tile.peripheral.OpenComputers.DriverIAspectContainer;
import vazkii.tinkerer.common.core.handler.ConfigHandler;
import vazkii.tinkerer.common.core.handler.kami.DimensionalShardDropHandler;
import vazkii.tinkerer.common.core.handler.kami.KamiArmorHandler;
import vazkii.tinkerer.common.core.handler.kami.KamiDimensionHandler;
import vazkii.tinkerer.common.core.handler.kami.SoulHeartHandler;
import vazkii.tinkerer.common.core.helper.NumericAspectHelper;
import vazkii.tinkerer.common.enchantment.ModEnchantments;
import vazkii.tinkerer.common.enchantment.core.EnchantmentManager;
import vazkii.tinkerer.common.item.ModItems;
import vazkii.tinkerer.common.network.GuiHandler;
import vazkii.tinkerer.common.network.PlayerTracker;
import vazkii.tinkerer.common.network.packet.PacketEnchanterAddEnchant;
import vazkii.tinkerer.common.network.packet.PacketEnchanterStartWorking;
import vazkii.tinkerer.common.network.packet.PacketMobMagnetButton;
import vazkii.tinkerer.common.network.packet.PacketTabletButton;
import vazkii.tinkerer.common.network.packet.kami.PacketSoulHearts;
import vazkii.tinkerer.common.network.packet.kami.PacketToggleArmor;
import vazkii.tinkerer.common.network.packet.kami.PacketWarpGateButton;
import vazkii.tinkerer.common.network.packet.kami.PacketWarpGateTeleport;
import vazkii.tinkerer.common.potion.ModPotions;
import vazkii.tinkerer.common.research.ModRecipes;
import vazkii.tinkerer.common.research.ModResearch;

public class TTCommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.loadConfig(event.getSuggestedConfigurationFile());
        ModBlocks.initBlocks();
        ModItems.initItems();
        NumericAspectHelper.init();
        this.initCCPeripherals();
    }

    public void init(FMLInitializationEvent event) {
        ModEnchantments.initEnchantments();
        EnchantmentManager.initEnchantmentData();
        ModPotions.initPotions();
        ModBlocks.initTileEntities();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)ThaumicTinkerer.instance, (IGuiHandler)new GuiHandler());
        this.registerPackets();
        FMLCommonHandler.instance().bus().register((Object)new PlayerTracker());
        if (ConfigHandler.enableKami) {
            MinecraftForge.EVENT_BUS.register((Object)new DimensionalShardDropHandler());
            MinecraftForge.EVENT_BUS.register((Object)new KamiDimensionHandler());
            MinecraftForge.EVENT_BUS.register((Object)new SoulHeartHandler());
        }
        if (Loader.isModLoaded((String)"OpenComputers")) {
            this.initOpenCDrivers();
        }
    }

    protected void registerPackets() {
        ThaumicTinkerer.netHandler.registerMessage(PacketSoulHearts.class, PacketSoulHearts.class, 142, Side.CLIENT);
        ThaumicTinkerer.netHandler.registerMessage(PacketToggleArmor.class, PacketToggleArmor.class, 143, Side.CLIENT);
        ThaumicTinkerer.netHandler.registerMessage(PacketToggleArmor.class, PacketToggleArmor.class, 144, Side.SERVER);
        ThaumicTinkerer.netHandler.registerMessage(PacketWarpGateButton.class, PacketWarpGateButton.class, 145, Side.SERVER);
        ThaumicTinkerer.netHandler.registerMessage(PacketWarpGateTeleport.class, PacketWarpGateTeleport.class, 146, Side.SERVER);
        ThaumicTinkerer.netHandler.registerMessage(PacketEnchanterAddEnchant.class, PacketEnchanterAddEnchant.class, 147, Side.SERVER);
        ThaumicTinkerer.netHandler.registerMessage(PacketEnchanterStartWorking.class, PacketEnchanterStartWorking.class, 148, Side.SERVER);
        ThaumicTinkerer.netHandler.registerMessage(PacketMobMagnetButton.class, PacketMobMagnetButton.class, 149, Side.SERVER);
        ThaumicTinkerer.netHandler.registerMessage(PacketTabletButton.class, PacketTabletButton.class, 150, Side.SERVER);
    }

    public void postInit(FMLPostInitializationEvent event) {
        ModRecipes.initRecipes();
        ModResearch.initResearch();
    }

    protected void initCCPeripherals() {
    }

    @Optional.Method(modid="OpenComputers")
    public void initOpenCDrivers() {
        Driver.add((Block)new DriverIAspectContainer());
        Driver.add((Block)new DriverArcaneEar());
        Driver.add((Block)new DriverBrainInAJar());
        Driver.add((Block)new DriverDeconstructor());
        Driver.add((Block)new DriverEssentiaTransport());
        Driver.add((Block)new DriverArcaneBore());
    }

    public boolean isClient() {
        return false;
    }

    public boolean armorStatus(EntityPlayer player) {
        return KamiArmorHandler.getArmorStatus(player);
    }

    public void setArmor(EntityPlayer player, boolean status) {
        KamiArmorHandler.setArmorStatus(player, status);
    }

    public EntityPlayer getClientPlayer() {
        return null;
    }

    public void shadowSparkle(World world, float x, float y, float z, int size) {
    }
}

