/*
 * Decompiled with CFR 0.152.
 */
package vazkii.tinkerer.client.core.proxy;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.EnumHelperClient;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import vazkii.tinkerer.client.core.handler.ClientTickHandler;
import vazkii.tinkerer.client.core.handler.GemArmorKeyHandler;
import vazkii.tinkerer.client.core.handler.HUDHandler;
import vazkii.tinkerer.client.core.handler.LocalizationHandler;
import vazkii.tinkerer.client.core.handler.kami.KamiArmorClientHandler;
import vazkii.tinkerer.client.core.handler.kami.PlacementMirrorPredictionRenderer;
import vazkii.tinkerer.client.core.handler.kami.SoulHeartClientHandler;
import vazkii.tinkerer.client.core.handler.kami.ToolModeHUDHandler;
import vazkii.tinkerer.client.core.helper.ClientHelper;
import vazkii.tinkerer.client.lib.LibRenderIDs;
import vazkii.tinkerer.client.render.block.RenderMagnet;
import vazkii.tinkerer.client.render.block.RenderRepairer;
import vazkii.tinkerer.client.render.block.kami.RenderWarpGate;
import vazkii.tinkerer.client.render.item.RenderMobAspect;
import vazkii.tinkerer.client.render.item.RenderMobDisplay;
import vazkii.tinkerer.client.render.item.kami.RenderPlacementMirror;
import vazkii.tinkerer.client.render.tile.RenderTileAnimationTablet;
import vazkii.tinkerer.client.render.tile.RenderTileEnchanter;
import vazkii.tinkerer.client.render.tile.RenderTileFunnel;
import vazkii.tinkerer.client.render.tile.RenderTileMagnet;
import vazkii.tinkerer.client.render.tile.RenderTileRepairer;
import vazkii.tinkerer.client.render.tile.kami.RenderTileWarpGate;
import vazkii.tinkerer.common.block.tile.TileEnchanter;
import vazkii.tinkerer.common.block.tile.TileFunnel;
import vazkii.tinkerer.common.block.tile.TileMagnet;
import vazkii.tinkerer.common.block.tile.TileRepairer;
import vazkii.tinkerer.common.block.tile.kami.TileWarpGate;
import vazkii.tinkerer.common.block.tile.tablet.TileAnimationTablet;
import vazkii.tinkerer.common.core.handler.ConfigHandler;
import vazkii.tinkerer.common.core.proxy.TTCommonProxy;
import vazkii.tinkerer.common.item.ModItems;
import vazkii.tinkerer.common.item.kami.foci.ItemFocusShadowbeam;

public class TTClientProxy
extends TTCommonProxy {
    public static EnumRarity kamiRarity;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        if (ConfigHandler.enableKami) {
            kamiRarity = (EnumRarity)EnumHelperClient.addEnum((Class[][])new Class[][]{{EnumRarity.class, EnumChatFormatting.class, String.class}}, EnumRarity.class, (String)"KAMI", (Object[])new Object[]{EnumChatFormatting.LIGHT_PURPLE, "Kami"});
        }
    }

    public static EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        LocalizationHandler.loadLocalizations();
        MinecraftForge.EVENT_BUS.register((Object)new HUDHandler());
        ClientTickHandler cthandler = new ClientTickHandler();
        FMLCommonHandler.instance().bus().register((Object)cthandler);
        MinecraftForge.EVENT_BUS.register((Object)cthandler);
        MinecraftForge.EVENT_BUS.register((Object)new GemArmorKeyHandler());
        this.registerTiles();
        this.registerRenderIDs();
        if (ConfigHandler.enableKami) {
            MinecraftForge.EVENT_BUS.register((Object)new SoulHeartClientHandler());
            MinecraftForge.EVENT_BUS.register((Object)new ToolModeHUDHandler());
            if (ConfigHandler.showPlacementMirrorBlocks) {
                MinecraftForge.EVENT_BUS.register((Object)new PlacementMirrorPredictionRenderer());
            }
        }
    }

    private void registerTiles() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileAnimationTablet.class, (TileEntitySpecialRenderer)new RenderTileAnimationTablet());
        ClientRegistry.bindTileEntitySpecialRenderer(TileMagnet.class, (TileEntitySpecialRenderer)new RenderTileMagnet());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEnchanter.class, (TileEntitySpecialRenderer)new RenderTileEnchanter());
        ClientRegistry.bindTileEntitySpecialRenderer(TileFunnel.class, (TileEntitySpecialRenderer)new RenderTileFunnel());
        ClientRegistry.bindTileEntitySpecialRenderer(TileRepairer.class, (TileEntitySpecialRenderer)new RenderTileRepairer());
        if (ConfigHandler.enableKami) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileWarpGate.class, (TileEntitySpecialRenderer)new RenderTileWarpGate());
        }
    }

    private void registerRenderIDs() {
        LibRenderIDs.idMagnet = RenderingRegistry.getNextAvailableRenderId();
        LibRenderIDs.idRepairer = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderMagnet());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderRepairer());
        MinecraftForgeClient.registerItemRenderer((Item)ModItems.mobAspect, (IItemRenderer)new RenderMobAspect());
        MinecraftForgeClient.registerItemRenderer((Item)ModItems.mobDisplay, (IItemRenderer)new RenderMobDisplay());
        if (ConfigHandler.enableKami) {
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.placementMirror, (IItemRenderer)new RenderPlacementMirror());
            LibRenderIDs.idWarpGate = RenderingRegistry.getNextAvailableRenderId();
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderWarpGate());
        }
    }

    @Override
    public void shadowSparkle(World world, float x, float y, float z, int size) {
        ItemFocusShadowbeam.Particle particle = new ItemFocusShadowbeam.Particle(world, x, y, z, 1.5f, 0, size);
        ClientHelper.minecraft().field_71452_i.func_78873_a((EntityFX)particle);
    }

    @Override
    protected void initCCPeripherals() {
        try {
            super.initCCPeripherals();
        }
        catch (Throwable e) {
            System.out.println("Thaumic Tinkerer: ComputerCraft not found.");
        }
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public boolean armorStatus(EntityPlayer player) {
        return KamiArmorClientHandler.ArmorEnabled;
    }

    @Override
    public void setArmor(EntityPlayer player, boolean status) {
        super.setArmor(player, status);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            KamiArmorClientHandler.ArmorEnabled = status;
        }
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return ClientHelper.clientPlayer();
    }
}

