/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.parts.layers;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.LayerBase;
import appeng.api.parts.LayerFlags;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class LayerIEnergySink
extends LayerBase
implements IEnergySink {
    private boolean isInIC2() {
        return this.getLayerFlags().contains((Object)LayerFlags.IC2_ENET);
    }

    private TileEntity getEnergySinkTile() {
        IPartHost host = (IPartHost)((Object)this);
        return host.getTile();
    }

    private World getEnergySinkWorld() {
        return this.getEnergySinkTile().func_145831_w();
    }

    private final void addToENet() {
        if (this.getEnergySinkWorld() == null) {
            return;
        }
        this.removeFromENet();
        if (!this.isInIC2()) {
            this.getLayerFlags().add(LayerFlags.IC2_ENET);
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergySink)this.getEnergySinkTile()));
        }
    }

    private final void removeFromENet() {
        if (this.getEnergySinkWorld() == null) {
            return;
        }
        if (this.isInIC2()) {
            this.getLayerFlags().remove((Object)LayerFlags.IC2_ENET);
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergySink)this.getEnergySinkTile()));
        }
    }

    private final boolean interestedInIC2() {
        int interested = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IPart part = this.getPart(dir);
            if (!(part instanceof IEnergyTile)) continue;
            ++interested;
        }
        return interested == 1;
    }

    @Override
    public void partChanged() {
        super.partChanged();
        if (this.interestedInIC2()) {
            this.addToENet();
        } else {
            this.removeFromENet();
        }
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        if (!this.isInIC2()) {
            return false;
        }
        IPart part = this.getPart(ForgeDirection.getOrientation((int)direction.toSideValue()));
        if (part instanceof IEnergySink) {
            return ((IEnergySink)((Object)part)).acceptsEnergyFrom(emitter, direction);
        }
        return false;
    }

    @Override
    public int demandsEnergy() {
        if (!this.isInIC2()) {
            return 0;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IPart part = this.getPart(dir);
            if (!(part instanceof IEnergySink)) continue;
            return ((IEnergySink)((Object)part)).demandsEnergy();
        }
        return 0;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (!this.isInIC2()) {
            return amount;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IPart part = this.getPart(dir);
            if (!(part instanceof IEnergySink)) continue;
            return ((IEnergySink)((Object)part)).injectEnergy(directionFrom, amount);
        }
        return amount;
    }

    @Override
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.isInIC2();
    }
}

