/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.config;

public enum AccessRestriction {
    NO_ACCESS(0),
    READ(1),
    WRITE(2),
    READ_WRITE(3);

    private final int permisionBit;

    private AccessRestriction(int v) {
        this.permisionBit = v;
    }

    public boolean hasPermission(AccessRestriction ar) {
        return (this.permisionBit & ar.permisionBit) == ar.permisionBit;
    }

    public AccessRestriction restrictPermissions(AccessRestriction ar) {
        return this.getPermByBit(this.permisionBit & ar.permisionBit);
    }

    public AccessRestriction addPermissions(AccessRestriction ar) {
        return this.getPermByBit(this.permisionBit | ar.permisionBit);
    }

    public AccessRestriction removePermissions(AccessRestriction ar) {
        return this.getPermByBit(this.permisionBit & ~ar.permisionBit);
    }

    private AccessRestriction getPermByBit(int bit) {
        switch (bit) {
            default: {
                return NO_ACCESS;
            }
            case 1: {
                return READ;
            }
            case 2: {
                return WRITE;
            }
            case 3: 
        }
        return READ_WRITE;
    }
}

