/*
 * Decompiled with CFR 0.152.
 */
package jinngine.physics.constraint.contact;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import jinngine.geometry.contact.ContactGenerator;
import jinngine.math.Matrix3;
import jinngine.math.Vector3;
import jinngine.physics.Body;
import jinngine.physics.constraint.contact.ContactConstraint;
import jinngine.physics.solver.Solver;
import jinngine.util.GramSchmidt;
import jinngine.util.Pair;

public final class FrictionalContactConstraint
implements ContactConstraint {
    private final Body b1;
    private final Body b2;
    private final List<ContactGenerator> generators = new ArrayList<ContactGenerator>();
    private final List<Solver.NCPConstraint> ncpconstraints = new ArrayList<Solver.NCPConstraint>();
    private double frictionBoundMagnitude = Double.POSITIVE_INFINITY;
    private boolean enableCoupling = true;
    private Vector3 xvel = new Vector3();
    private Vector3 yvel = new Vector3();
    private double multiplier = 1.0;

    public FrictionalContactConstraint(Body b1, Body b2, ContactGenerator generator) {
        this.b1 = b1;
        this.b2 = b2;
        this.generators.add(generator);
    }

    public void setTangentialVelocityX(Vector3 x) {
        this.xvel.assign(x);
    }

    public void setTangentialVelocityY(Vector3 y) {
        this.yvel.assign(y);
    }

    public final void setTangentialVelocityMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    @Override
    public void addGenerator(ContactGenerator g) {
        this.generators.add(g);
    }

    @Override
    public void removeGenerator(ContactGenerator g) {
        this.generators.remove(g);
    }

    @Override
    public double getNumberOfGenerators() {
        return this.generators.size();
    }

    @Override
    public final void applyConstraints(ListIterator<Solver.NCPConstraint> constraintIterator, double dt) {
        this.ncpconstraints.clear();
        for (ContactGenerator cg : this.generators) {
            cg.run();
            Iterator<ContactGenerator.ContactPoint> i = cg.getContacts();
            while (i.hasNext()) {
                ContactGenerator.ContactPoint cp = i.next();
                this.createFrictionalContactConstraint(cp, this.b1, this.b2, cp.point, cp.normal, cp.depth, dt, constraintIterator);
            }
        }
    }

    public static final double relativeVelocity(Body b1, Body b2, Vector3 p, Vector3 n) {
        Vector3 rb1 = new Vector3();
        Vector3 rb2 = new Vector3();
        Vector3 pdotb1 = new Vector3();
        Vector3 pdotb2 = new Vector3();
        Vector3 u = new Vector3();
        Vector3.sub(p, b1.state.position, rb1);
        Vector3.sub(p, b2.state.position, rb2);
        Vector3.crossProduct(b1.state.omega, rb1, pdotb1);
        Vector3.add(pdotb1, b1.state.velocity);
        Vector3.crossProduct(b2.state.omega, rb2, pdotb2);
        Vector3.add(pdotb2, b2.state.velocity);
        Vector3.sub(pdotb1, pdotb2, u);
        return Vector3.dot(n, u);
    }

    public final void createFrictionalContactConstraint(ContactGenerator.ContactPoint cp, Body b1, Body b2, Vector3 p, Vector3 n, double depth, double dt, ListIterator<Solver.NCPConstraint> outConstraints) {
        Vector3 t1 = new Vector3();
        Vector3 t2 = new Vector3();
        Vector3 t3 = new Vector3();
        Matrix3 B = GramSchmidt.run(n);
        B.getColumnVectors(t1, t2, t3);
        Vector3 r1 = p.minus(b1.state.position);
        Vector3 r2 = p.minus(b2.state.position);
        Vector3 J1 = n.multiply(1.0);
        Vector3 J2 = r1.cross(n).multiply(1.0);
        Vector3 J3 = n.multiply(-1.0);
        Vector3 J4 = r2.cross(n).multiply(-1.0);
        double e = cp.restitution;
        double uni = J1.dot(b1.state.velocity) + J2.dot(b1.state.omega) + J3.dot(b2.state.velocity) + J4.dot(b2.state.omega);
        double unf = uni < 0.0 ? -e * uni : 0.0;
        Matrix3 I1 = b1.state.inverseinertia;
        double m1 = b1.state.mass;
        Matrix3 I2 = b2.state.inverseinertia;
        double m2 = b2.state.mass;
        Vector3 B1 = n.multiply(1.0 / m1);
        Vector3 B2 = I1.multiply(r1.cross(n));
        Vector3 B3 = n.multiply(-1.0 / m2);
        Vector3 B4 = I2.multiply(r2.cross(n)).multiply(-1.0);
        if (b1.isFixed()) {
            B1.assign(B2.assign(Vector3.zero));
        }
        if (b2.isFixed()) {
            B3.assign(B4.assign(Vector3.zero));
        }
        double correction = depth * (1.0 / dt);
        double escape = (cp.envelope - cp.distance) * (1.0 / dt);
        double lowerNormalLimit = 0.0;
        double limit = 2.0;
        if (unf > escape) {
            correction = 0.0;
        } else if (correction > 0.0) {
            correction = unf > correction ? 0.0 : (correction -= unf);
        }
        correction = correction < -limit ? -limit : correction;
        correction = correction > limit ? limit : correction;
        Solver.NCPConstraint c = new Solver.NCPConstraint();
        c.assign(b1, b2, B1, B2, B3, B4, J1, J2, J3, J4, lowerNormalLimit, Double.POSITIVE_INFINITY, null, -(unf - uni) - (correction *= 0.9), -correction);
        c.distance = cp.distance;
        Solver.NCPConstraint coupling = this.enableCoupling ? c : null;
        c.mu = cp.friction;
        double ut1i = FrictionalContactConstraint.relativeVelocity(b1, b2, p, t2);
        double ut2i = FrictionalContactConstraint.relativeVelocity(b1, b2, p, t3);
        double ut1f = t2.dot(this.xvel.add(this.yvel)) * this.multiplier;
        double ut2f = t3.dot(this.xvel.add(this.yvel)) * this.multiplier;
        Vector3 t2B1 = b1.isFixed() ? Vector3.zero : t2.multiply(1.0 / m1);
        Vector3 t2B2 = b1.isFixed() ? Vector3.zero : I1.multiply(r1.cross(t2));
        Vector3 t2B3 = b2.isFixed() ? Vector3.zero : t2.multiply(-1.0 / m2);
        Vector3 t2B4 = b2.isFixed() ? Vector3.zero : I2.multiply(r2.cross(t2).multiply(-1.0));
        Solver.NCPConstraint c2 = new Solver.NCPConstraint();
        c2.assign(b1, b2, t2B1, t2B2, t2B3, t2B4, t2, r1.cross(t2), t2.multiply(-1.0), r2.cross(t2).multiply(-1.0), -this.frictionBoundMagnitude, this.frictionBoundMagnitude, coupling, -(ut1f - ut1i), 0.0);
        Vector3 t3B1 = b1.isFixed() ? Vector3.zero : t3.multiply(1.0 / m1);
        Vector3 t3B2 = b1.isFixed() ? Vector3.zero : I1.multiply(r1.cross(t3));
        Vector3 t3B3 = b2.isFixed() ? Vector3.zero : t3.multiply(-1.0 / m2);
        Vector3 t3B4 = b2.isFixed() ? Vector3.zero : I2.multiply(r2.cross(t3).multiply(-1.0));
        Solver.NCPConstraint c3 = new Solver.NCPConstraint();
        c3.assign(b1, b2, t3B1, t3B2, t3B3, t3B4, t3, r1.cross(t3), t3.multiply(-1.0), r2.cross(t3).multiply(-1.0), -this.frictionBoundMagnitude, this.frictionBoundMagnitude, coupling, -(ut2f - ut2i), 0.0);
        outConstraints.add(c);
        outConstraints.add(c2);
        outConstraints.add(c3);
        this.ncpconstraints.add(c);
        this.ncpconstraints.add(c2);
        this.ncpconstraints.add(c3);
    }

    @Override
    public final Pair<Body> getBodies() {
        return new Pair<Body>(this.b1, this.b2);
    }

    public final void setCouplingEnabled(boolean coupling) {
        this.enableCoupling = coupling;
    }

    public final void setFixedFrictionBoundsMagnitude(double magnitude) {
        this.frictionBoundMagnitude = magnitude;
    }

    @Override
    public final Iterator<Solver.NCPConstraint> getNcpConstraints() {
        return this.ncpconstraints.iterator();
    }

    @Override
    public final Iterator<ContactGenerator> getGenerators() {
        return this.generators.iterator();
    }
}

