/*
 * Decompiled with CFR 0.152.
 */
package jinngine.math;

import java.io.Serializable;
import jinngine.math.Matrix3;

public final class Vector3
implements Serializable {
    private static final long serialVersionUID = 1L;
    public double x;
    public double y;
    public double z;
    private static final transient double e = (double)1.0E-9f;
    private static final transient double[] epsilonVector = new double[]{1.0E-9f, 1.0E-9f, 1.0E-9f};
    public static final transient Vector3 epsilon = new Vector3(epsilonVector);
    public static final transient Vector3 zero = new Vector3(0.0, 0.0, 0.0);
    public static final transient Vector3 i = new Vector3(1.0, 0.0, 0.0);
    public static final transient Vector3 j = new Vector3(0.0, 1.0, 0.0);
    public static final transient Vector3 k = new Vector3(0.0, 0.0, 1.0);

    public Vector3() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Vector3(double a, double b, double c) {
        this.x = a;
        this.y = b;
        this.z = c;
    }

    public Vector3(Vector3 v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public Vector3(double[] m) {
        this.x = m[0];
        this.y = m[1];
        this.z = m[2];
    }

    public final Vector3 copy() {
        return new Vector3(this);
    }

    public final Vector3 add(Vector3 v) {
        return new Vector3(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public final Vector3 add(double s) {
        return new Vector3(this.x + s, this.y + s, this.z + s);
    }

    public final Vector3 negate() {
        return new Vector3(-this.x, -this.y, -this.z);
    }

    public final boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.z);
    }

    public double get(int i) {
        return i > 0 ? (i > 1 ? this.z : this.y) : this.x;
    }

    public void set(int i, double v) {
        if (i == 0) {
            this.x = v;
        } else if (i == 1) {
            this.y = v;
        } else {
            this.z = v;
        }
    }

    public static final void assign(Vector3 v1, Vector3 v2) {
        v1.x = v2.x;
        v1.y = v2.y;
        v1.z = v2.z;
    }

    public static final void add(Vector3 v1, Vector3 v2) {
        v1.x += v2.x;
        v1.y += v2.y;
        v1.z += v2.z;
    }

    public static final void sub(Vector3 v1, Vector3 v2) {
        v1.x -= v2.x;
        v1.y -= v2.y;
        v1.z -= v2.z;
    }

    public static final void sub(Vector3 v1, Vector3 v2, Vector3 result) {
        result.x = v1.x - v2.x;
        result.y = v1.y - v2.y;
        result.z = v1.z - v2.z;
    }

    public final Vector3 minus(Vector3 v) {
        return new Vector3(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public static final void minus(Vector3 a, Vector3 b) {
        a.x -= b.x;
        a.y -= b.y;
        a.z -= b.z;
    }

    public final Vector3 multiply(double s) {
        return new Vector3(this.x * s, this.y * s, this.z * s);
    }

    public final Vector3 scale(Vector3 s) {
        return new Vector3(this.x * s.x, this.y * s.y, this.z * s.z);
    }

    public static final void multiply(Vector3 v, double s) {
        v.x *= s;
        v.y *= s;
        v.z *= s;
    }

    public static final void multiply(Vector3 v, double s, Vector3 result) {
        result.x = v.x * s;
        result.y = v.y * s;
        result.z = v.z * s;
    }

    public static final void multiplyAndAdd(Vector3 v, double s, Vector3 result) {
        result.x += v.x * s;
        result.y += v.y * s;
        result.z += v.z * s;
    }

    public static final void multiplyStoreAndAdd(Vector3 v, double s, Vector3 result) {
        v.x *= s;
        v.y *= s;
        v.z *= s;
        result.x += v.x;
        result.y += v.y;
        result.z += v.z;
    }

    public final double dot(Vector3 v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public final double xydot(Vector3 v) {
        return this.x * v.x + this.y * v.y;
    }

    public static final double dot(Vector3 v1, Vector3 v2) {
        return v1.x * v2.x + v1.y * v2.y + v1.z * v2.z;
    }

    public final Vector3 cross(Vector3 v) {
        return new Vector3(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
    }

    public static final void crossProduct(Vector3 v1, Vector3 v2, Vector3 result) {
        double tempa1 = v1.y * v2.z - v1.z * v2.y;
        double tempa2 = v1.z * v2.x - v1.x * v2.z;
        double tempa3 = v1.x * v2.y - v1.y * v2.x;
        result.x = tempa1;
        result.y = tempa2;
        result.z = tempa3;
    }

    public final Vector3 normalize() {
        double l = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (l == 0.0) {
            return new Vector3(1.0, 0.0, 0.0);
        }
        return new Vector3(this.x / l, this.y / l, this.z / l);
    }

    public final Vector3 assign(double t1, double t2, double t3) {
        this.x = t1;
        this.y = t2;
        this.z = t3;
        return this;
    }

    public final Vector3 add(double t1, double t2, double t3) {
        return new Vector3(this.x + t1, this.y + t2, this.z + t3);
    }

    public final Vector3 assign(Vector3 v) {
        double t1 = v.x;
        double t2 = v.y;
        double t3 = v.z;
        this.x = t1;
        this.y = t2;
        this.z = t3;
        return this;
    }

    public final Vector3 assignZero() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        return this;
    }

    public final boolean equals(Vector3 v) {
        return this.x == v.x && this.y == v.y && this.z == v.z;
    }

    public final double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public final double xynorm() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public final double infnorm() {
        return Math.abs(this.x > this.y ? (this.x > this.z ? this.x : this.z) : (this.y > this.z ? this.y : this.z));
    }

    public final double squaredNorm() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final double[][] crossProductMatrix() {
        double[][] m = new double[3][3];
        m[0][0] = 0.0;
        m[0][1] = -this.z;
        m[0][2] = this.y;
        m[1][0] = this.z;
        m[1][1] = 0.0;
        m[1][2] = -this.x;
        m[2][0] = -this.y;
        m[2][1] = this.x;
        m[2][2] = 0.0;
        return m;
    }

    public final Matrix3 crossProductMatrix(Matrix3 A) {
        Matrix3.set(A, 0.0, -this.z, this.y, this.z, 0.0, -this.x, -this.y, this.x, 0.0);
        return A;
    }

    public final Matrix3 crossProductMatrix3() {
        Matrix3 A = new Matrix3();
        Matrix3.set(A, 0.0, -this.z, this.y, this.z, 0.0, -this.x, -this.y, this.x, 0.0);
        return A;
    }

    public final double[][] transposeMatrix() {
        double[][] m = new double[3][1];
        m[0][0] = this.x;
        m[1][0] = this.y;
        m[2][0] = this.z;
        return m;
    }

    public final double[][] Matrix() {
        double[][] m = new double[1][3];
        m[0][0] = this.x;
        m[0][1] = this.y;
        m[0][2] = this.z;
        return m;
    }

    public final boolean lessThan(Vector3 v) {
        return this.x < v.x && this.y < v.y && this.z < v.z;
    }

    public final boolean weaklyLessThan(Vector3 v) {
        return this.x <= v.x && this.y <= v.y && this.z <= v.z;
    }

    public final boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public final boolean isWeaklyGreaterThanZero() {
        return this.x >= 0.0 && this.y >= 0.0 && this.z >= 0.0;
    }

    public final Vector3 abs() {
        return new Vector3(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    public final void print() {
        System.out.println("[" + this.x + "," + this.y + "," + this.z + "]");
    }

    public final Vector3 cutOff(double epsilon) {
        double b1 = Math.abs(this.x) < epsilon ? 0.0 : this.x;
        double b2 = Math.abs(this.y) < epsilon ? 0.0 : this.y;
        double b3 = Math.abs(this.z) < epsilon ? 0.0 : this.z;
        return new Vector3(b1, b2, b3);
    }

    public final double[] pack() {
        return new double[]{this.x, this.y, this.z};
    }

    public static final double[] pack(Vector3 v) {
        return new double[]{v.x, v.y, v.z};
    }

    public final String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + "]" + super.toString();
    }
}

