/*
 * Decompiled with CFR 0.152.
 */
package jinngine.math;

import jinngine.math.Vector3;

public class Matrix4 {
    public double a11 = 0.0;
    public double a12 = 0.0;
    public double a13 = 0.0;
    public double a14 = 0.0;
    public double a21 = 0.0;
    public double a22 = 0.0;
    public double a23 = 0.0;
    public double a24 = 0.0;
    public double a31 = 0.0;
    public double a32 = 0.0;
    public double a33 = 0.0;
    public double a34 = 0.0;
    public double a41 = 0.0;
    public double a42 = 0.0;
    public double a43 = 0.0;
    public double a44 = 0.0;

    public static final Matrix4 identity(Matrix4 M) {
        M.a11 = 1.0;
        M.a12 = 0.0;
        M.a13 = 0.0;
        M.a14 = 0.0;
        M.a21 = 0.0;
        M.a22 = 1.0;
        M.a23 = 0.0;
        M.a24 = 0.0;
        M.a31 = 0.0;
        M.a32 = 0.0;
        M.a33 = 1.0;
        M.a34 = 0.0;
        M.a41 = 0.0;
        M.a42 = 0.0;
        M.a43 = 0.0;
        M.a44 = 1.0;
        return M;
    }

    public Matrix4() {
    }

    public Matrix4(double a11, double a12, double a13, double a14, double a21, double a22, double a23, double a24, double a31, double a32, double a33, double a34, double a41, double a42, double a43, double a44) {
        Matrix4 M = this;
        M.a11 = a11;
        M.a12 = a12;
        M.a13 = a13;
        M.a14 = a14;
        M.a21 = a21;
        M.a22 = a22;
        M.a23 = a23;
        M.a24 = a24;
        M.a31 = a31;
        M.a32 = a32;
        M.a33 = a33;
        M.a34 = a34;
        M.a41 = a41;
        M.a42 = a42;
        M.a43 = a43;
        M.a44 = a44;
    }

    public Matrix4(Matrix4 M) {
        Matrix4.set(M, this);
    }

    public static final Matrix4 multiply(Matrix4 A, Matrix4 B, Matrix4 C) {
        double t11 = A.a11 * B.a11 + A.a12 * B.a21 + A.a13 * B.a31 + A.a14 * B.a41;
        double t12 = A.a11 * B.a12 + A.a12 * B.a22 + A.a13 * B.a32 + A.a14 * B.a42;
        double t13 = A.a11 * B.a13 + A.a12 * B.a23 + A.a13 * B.a33 + A.a14 * B.a43;
        double t14 = A.a11 * B.a14 + A.a12 * B.a24 + A.a13 * B.a34 + A.a14 * B.a44;
        double t21 = A.a21 * B.a11 + A.a22 * B.a21 + A.a23 * B.a31 + A.a24 * B.a41;
        double t22 = A.a21 * B.a12 + A.a22 * B.a22 + A.a23 * B.a32 + A.a24 * B.a42;
        double t23 = A.a21 * B.a13 + A.a22 * B.a23 + A.a23 * B.a33 + A.a24 * B.a43;
        double t24 = A.a21 * B.a14 + A.a22 * B.a24 + A.a23 * B.a34 + A.a24 * B.a44;
        double t31 = A.a31 * B.a11 + A.a32 * B.a21 + A.a33 * B.a31 + A.a34 * B.a41;
        double t32 = A.a31 * B.a12 + A.a32 * B.a22 + A.a33 * B.a32 + A.a34 * B.a42;
        double t33 = A.a31 * B.a13 + A.a32 * B.a23 + A.a33 * B.a33 + A.a34 * B.a43;
        double t34 = A.a31 * B.a14 + A.a32 * B.a24 + A.a33 * B.a34 + A.a34 * B.a44;
        double t41 = A.a41 * B.a11 + A.a42 * B.a21 + A.a43 * B.a31 + A.a44 * B.a41;
        double t42 = A.a41 * B.a12 + A.a42 * B.a22 + A.a43 * B.a32 + A.a44 * B.a42;
        double t43 = A.a41 * B.a13 + A.a42 * B.a23 + A.a43 * B.a33 + A.a44 * B.a43;
        double t44 = A.a41 * B.a14 + A.a42 * B.a24 + A.a43 * B.a34 + A.a44 * B.a44;
        C.a11 = t11;
        C.a12 = t12;
        C.a13 = t13;
        C.a14 = t14;
        C.a21 = t21;
        C.a22 = t22;
        C.a23 = t23;
        C.a24 = t24;
        C.a31 = t31;
        C.a32 = t32;
        C.a33 = t33;
        C.a34 = t34;
        C.a41 = t41;
        C.a42 = t42;
        C.a43 = t43;
        C.a44 = t44;
        return C;
    }

    public Matrix4 multiply(Matrix4 A) {
        Matrix4 M = new Matrix4();
        Matrix4.multiply(this, A, M);
        return M;
    }

    public Vector3 multiply(Vector3 v) {
        Vector3 x = new Vector3();
        return Matrix4.multiply(this, v, x);
    }

    public static final Vector3 multiply(Matrix4 A, Vector3 v, Vector3 r) {
        double t1 = v.x * A.a11 + v.y * A.a12 + v.z * A.a13 + 1.0 * A.a14;
        double t2 = v.x * A.a21 + v.y * A.a22 + v.z * A.a23 + 1.0 * A.a24;
        double t3 = v.x * A.a31 + v.y * A.a32 + v.z * A.a33 + 1.0 * A.a34;
        double t4 = v.x * A.a41 + v.y * A.a42 + v.z * A.a43 + 1.0 * A.a44;
        r.x = t1 / t4;
        r.y = t2 / t4;
        r.z = t3 / t4;
        return r;
    }

    public static final double[] pack(Matrix4 M) {
        double[] array = new double[]{M.a11, M.a21, M.a31, M.a41, M.a12, M.a22, M.a32, M.a42, M.a13, M.a23, M.a33, M.a43, M.a14, M.a24, M.a34, M.a44};
        return array;
    }

    public static final double[][] pack2(Matrix4 M) {
        double[][] array = new double[4][4];
        array[0][0] = M.a11;
        array[1][0] = M.a21;
        array[2][0] = M.a31;
        array[3][0] = M.a41;
        array[0][1] = M.a12;
        array[1][1] = M.a22;
        array[2][1] = M.a32;
        array[3][1] = M.a42;
        array[0][2] = M.a13;
        array[1][2] = M.a23;
        array[2][2] = M.a33;
        array[3][2] = M.a43;
        array[0][3] = M.a14;
        array[1][3] = M.a24;
        array[2][3] = M.a34;
        array[3][3] = M.a44;
        return array;
    }

    public static final void set(Matrix4 M, double[][] array) {
        M.a11 = array[0][0];
        M.a21 = array[1][0];
        M.a31 = array[2][0];
        M.a41 = array[3][0];
        M.a12 = array[0][1];
        M.a22 = array[1][1];
        M.a32 = array[2][1];
        M.a42 = array[3][1];
        M.a13 = array[0][2];
        M.a23 = array[1][2];
        M.a33 = array[2][2];
        M.a43 = array[3][2];
        M.a14 = array[0][3];
        M.a24 = array[1][3];
        M.a34 = array[2][3];
        M.a44 = array[3][3];
    }

    public static final void set(Matrix4 M, double[] array) {
        M.a11 = array[0];
        M.a21 = array[1];
        M.a31 = array[2];
        M.a41 = array[3];
        M.a12 = array[4];
        M.a22 = array[5];
        M.a32 = array[6];
        M.a42 = array[7];
        M.a13 = array[8];
        M.a23 = array[9];
        M.a33 = array[10];
        M.a43 = array[11];
        M.a14 = array[12];
        M.a24 = array[13];
        M.a34 = array[14];
        M.a44 = array[15];
    }

    public static final void set(Matrix4 A, Matrix4 B) {
        B.a11 = A.a11;
        B.a12 = A.a12;
        B.a13 = A.a13;
        B.a14 = A.a14;
        B.a21 = A.a21;
        B.a22 = A.a22;
        B.a23 = A.a23;
        B.a24 = A.a24;
        B.a31 = A.a31;
        B.a32 = A.a32;
        B.a33 = A.a33;
        B.a34 = A.a34;
        B.a41 = A.a41;
        B.a42 = A.a42;
        B.a43 = A.a43;
        B.a44 = A.a44;
    }

    public static final Matrix4 invert(Matrix4 S) {
        double[][] M = new double[4][4];
        M = Matrix4.pack2(S);
        double a00 = M[0][0];
        double a01 = M[0][1];
        double a02 = M[0][2];
        double a03 = M[0][3];
        double a10 = M[1][0];
        double a11 = M[1][1];
        double a12 = M[1][2];
        double a13 = M[1][3];
        double a20 = M[2][0];
        double a21 = M[2][1];
        double a22 = M[2][2];
        double a23 = M[2][3];
        double a30 = M[3][0];
        double a31 = M[3][1];
        double a32 = M[3][2];
        double a33 = M[3][3];
        M[0][0] = a11 * a22 * a33 - a11 * a23 * a32 - a21 * a12 * a33 + a21 * a13 * a32 + a31 * a12 * a23 - a31 * a13 * a22;
        M[0][1] = -a01 * a22 * a33 + a01 * a23 * a32 + a21 * a02 * a33 - a21 * a03 * a32 - a31 * a02 * a23 + a31 * a03 * a22;
        M[0][2] = a01 * a12 * a33 - a01 * a13 * a32 - a11 * a02 * a33 + a11 * a03 * a32 + a31 * a02 * a13 - a31 * a03 * a12;
        M[0][3] = -a01 * a12 * a23 + a01 * a13 * a22 + a11 * a02 * a23 - a11 * a03 * a22 - a21 * a02 * a13 + a21 * a03 * a12;
        M[1][0] = -a10 * a22 * a33 + a10 * a23 * a32 + a20 * a12 * a33 - a20 * a13 * a32 - a30 * a12 * a23 + a30 * a13 * a22;
        M[1][1] = a00 * a22 * a33 - a00 * a23 * a32 - a20 * a02 * a33 + a20 * a03 * a32 + a30 * a02 * a23 - a30 * a03 * a22;
        M[1][2] = -a00 * a12 * a33 + a00 * a13 * a32 + a10 * a02 * a33 - a10 * a03 * a32 - a30 * a02 * a13 + a30 * a03 * a12;
        M[1][3] = a00 * a12 * a23 - a00 * a13 * a22 - a10 * a02 * a23 + a10 * a03 * a22 + a20 * a02 * a13 - a20 * a03 * a12;
        M[2][0] = a10 * a21 * a33 - a10 * a23 * a31 - a20 * a11 * a33 + a20 * a13 * a31 + a30 * a11 * a23 - a30 * a13 * a21;
        M[2][1] = -a00 * a21 * a33 + a00 * a23 * a31 + a20 * a01 * a33 - a20 * a03 * a31 - a30 * a01 * a23 + a30 * a03 * a21;
        M[2][2] = a00 * a11 * a33 - a00 * a13 * a31 - a10 * a01 * a33 + a10 * a03 * a31 + a30 * a01 * a13 - a30 * a03 * a11;
        M[2][3] = -a00 * a11 * a23 + a00 * a13 * a21 + a10 * a01 * a23 - a10 * a03 * a21 - a20 * a01 * a13 + a20 * a03 * a11;
        M[3][0] = -a10 * a21 * a32 + a10 * a22 * a31 + a20 * a11 * a32 - a20 * a12 * a31 - a30 * a11 * a22 + a30 * a12 * a21;
        M[3][1] = a00 * a21 * a32 - a00 * a22 * a31 - a20 * a01 * a32 + a20 * a02 * a31 + a30 * a01 * a22 - a30 * a02 * a21;
        M[3][2] = -a00 * a11 * a32 + a00 * a12 * a31 + a10 * a01 * a32 - a10 * a02 * a31 - a30 * a01 * a12 + a30 * a02 * a11;
        M[3][3] = a00 * a11 * a22 - a00 * a12 * a21 - a10 * a01 * a22 + a10 * a02 * a21 + a20 * a01 * a12 - a20 * a02 * a11;
        double D = a00 * M[0][0] + a10 * M[0][1] + a20 * M[0][2] + a30 * M[0][3];
        if (D != 0.0) {
            double[] dArray = M[0];
            dArray[0] = dArray[0] / D;
            double[] dArray2 = M[0];
            dArray2[1] = dArray2[1] / D;
            double[] dArray3 = M[0];
            dArray3[2] = dArray3[2] / D;
            double[] dArray4 = M[0];
            dArray4[3] = dArray4[3] / D;
            double[] dArray5 = M[1];
            dArray5[0] = dArray5[0] / D;
            double[] dArray6 = M[1];
            dArray6[1] = dArray6[1] / D;
            double[] dArray7 = M[1];
            dArray7[2] = dArray7[2] / D;
            double[] dArray8 = M[1];
            dArray8[3] = dArray8[3] / D;
            double[] dArray9 = M[2];
            dArray9[0] = dArray9[0] / D;
            double[] dArray10 = M[2];
            dArray10[1] = dArray10[1] / D;
            double[] dArray11 = M[2];
            dArray11[2] = dArray11[2] / D;
            double[] dArray12 = M[2];
            dArray12[3] = dArray12[3] / D;
            double[] dArray13 = M[3];
            dArray13[0] = dArray13[0] / D;
            double[] dArray14 = M[3];
            dArray14[1] = dArray14[1] / D;
            double[] dArray15 = M[3];
            dArray15[2] = dArray15[2] / D;
            double[] dArray16 = M[3];
            dArray16[3] = dArray16[3] / D;
        }
        Matrix4.set(S, M);
        return S;
    }
}

