/*
 * Decompiled with CFR 0.152.
 */
package jinngine.geometry.util;

import java.util.Iterator;
import java.util.List;
import jinngine.math.Vector3;

public class ORourke {
    private static final double epsilon = 1.0E-8;

    public static void run(List<Vector3> poly1, List<Vector3> poly2, final List<Vector3> result) {
        ORourke.run(poly1, poly2, new ResultHandler(){

            @Override
            public void intersection(Vector3 arg0, Vector3 arg1) {
                if (arg1 == null) {
                    result.add(new Vector3(arg0.x, arg0.y, 0.0));
                } else {
                    result.add(new Vector3(arg1.x, arg1.y, 0.0));
                }
            }
        });
    }

    public static void run(List<Vector3> poly1, List<Vector3> poly2, final ResultHandler result) {
        int iter = 0;
        int intersections = 0;
        int addedpoints = 0;
        int firstIntersectionIter = 0;
        State inside = State.none;
        Vector3 p = new Vector3();
        Vector3 pm = new Vector3();
        Vector3 pd = new Vector3();
        Vector3 q = new Vector3();
        Vector3 qm = new Vector3();
        Vector3 qd = new Vector3();
        Vector3 parameter = new Vector3();
        Vector3 firstIntersection = new Vector3();
        Vector3 firstAddedPoint = new Vector3();
        Vector3 previouslyAddedPoint = new Vector3();
        Vector3 ipp = new Vector3();
        Vector3 ipq = new Vector3();
        int N = poly1.size();
        int M = poly2.size();
        Iterator<Vector3> poly1points = poly1.iterator();
        Iterator<Vector3> poly2points = poly2.iterator();
        if (N == 0 || M == 0) {
            return;
        }
        if (N == 1 && M == 1) {
            p.assign(poly1points.next());
            q.assign(poly2points.next());
            if (p.minus(q).xynorm() < 1.0E-8) {
                result.intersection(p, q);
            }
            return;
        }
        if (N == 1 && M == 2) {
            Vector3 lp;
            Vector3 p2;
            Vector3 p1;
            Vector3 x = poly1points.next();
            if (ORourke.pointLineIntersection(x, p1 = poly2points.next(), p2 = poly2points.next(), lp = new Vector3())) {
                result.intersection(x, lp);
            }
            return;
        }
        if (N == 2 && M == 1) {
            Vector3 lp;
            Vector3 p2;
            Vector3 p1;
            Vector3 x = poly2points.next();
            if (ORourke.pointLineIntersection(x, p1 = poly1points.next(), p2 = poly1points.next(), lp = new Vector3())) {
                result.intersection(lp, x);
            }
            return;
        }
        if (N == 1 && M > 2) {
            Vector3 x = poly1points.next();
            if (ORourke.isContained(x, poly2points)) {
                Vector3 polypoint = poly2.get(0);
                Vector3 poly2normal = new Vector3();
                ORourke.polyNormal(poly2, poly2normal);
                result.intersection(x, ORourke.projectToPlane(x, poly2normal, polypoint));
            }
            return;
        }
        if (N > 2 && M == 1) {
            Vector3 x = poly2points.next();
            if (ORourke.isContained(x, poly1points)) {
                Vector3 polypoint = poly1.get(0);
                Vector3 poly1normal = new Vector3();
                ORourke.polyNormal(poly1, poly1normal);
                result.intersection(ORourke.projectToPlane(x, poly1normal, polypoint), x);
            }
            return;
        }
        if (N == 2 && M == 2) {
            Vector3 par;
            Vector3 p4;
            Vector3 p3;
            Vector3 p2;
            Vector3 p1 = poly1points.next();
            if (ORourke.lineLineIntersection(p1, p2 = poly1points.next(), p3 = poly2points.next(), p4 = poly2points.next(), par = new Vector3(), 1.0E-8)) {
                if (par.x >= 0.0 && par.x <= 1.0 && par.y >= 0.0 && par.y <= 1.0) {
                    result.intersection(p1.add(p2.minus(p1).multiply(par.x)), p3.add(p4.minus(p3).multiply(par.y)));
                    return;
                }
                return;
            }
            if (Math.abs(p2.minus((Vector3)p1).cross((Vector3)p4.minus((Vector3)p1)).z) > 1.0E-8) {
                return;
            }
            Vector3 p3p4 = p3.minus(p4);
            Vector3 p2p1 = p2.minus(p1);
            Vector3 p3p1 = p3.minus(p1);
            double k1 = p3p4.xydot(p2p1) / p2p1.squaredNorm();
            double k2 = p3p1.xydot(p2p1) / p2p1.squaredNorm();
            int counter = 0;
            double s = (k2 - 0.0) / k1;
            if (0.0 <= s && s <= 1.0) {
                result.intersection(p1, p3.add(p4.minus(p3).multiply(s)));
                ++counter;
            }
            if (0.0 <= (s = (k2 - 1.0) / k1) && s <= 1.0) {
                result.intersection(p2, p3.add(p4.minus(p3).multiply(s)));
                ++counter;
            }
            if (counter > 1) {
                return;
            }
            double t = k2;
            if (0.0 <= t && t <= 1.0) {
                result.intersection(p2.add(p2p1.multiply(t)), p3);
                ++counter;
            }
            if (counter > 1) {
                return;
            }
            t = k2 - k1;
            if (0.0 <= t && t <= 1.0) {
                result.intersection(p2.add(p2p1.multiply(t)), p4);
                ++counter;
            }
            return;
        }
        if (N == 2 && M > 2) {
            Vector3 p1 = poly1points.next();
            Vector3 p2 = poly1points.next();
            Vector3 p3 = poly2points.next();
            Vector3 p4 = poly2points.next();
            Vector3 p5 = poly2points.next();
            Vector3 poly2normal = p5.minus(p3).cross(p3.minus(p4));
            ORourke.linePolyIntersection(p1, p2, poly2, poly2normal, result);
            return;
        }
        if (N > 2 && M == 2) {
            Vector3 p1 = poly2points.next();
            Vector3 p2 = poly2points.next();
            Vector3 p3 = poly1points.next();
            Vector3 p4 = poly1points.next();
            Vector3 p5 = poly1points.next();
            Vector3 poly1normal = p5.minus(p3).cross(p3.minus(p4));
            ORourke.linePolyIntersection(p1, p2, poly1, poly1normal, new ResultHandler(){

                @Override
                public final void intersection(Vector3 arg0, Vector3 arg1) {
                    result.intersection(arg1, arg0);
                }
            });
            return;
        }
        Vector3 poly1normal = new Vector3();
        ORourke.polyNormal(poly1, poly1normal);
        Vector3 poly2normal = new Vector3();
        ORourke.polyNormal(poly2, poly2normal);
        p.assign(poly1.get(poly1.size() - 1));
        q.assign(poly2.get(poly2.size() - 1));
        pm.assign(p);
        qm.assign(q);
        p.assign(poly1points.next());
        q.assign(poly2points.next());
        pd.assign(p.minus(pm));
        qd.assign(q.minus(qm));
        do {
            ++iter;
            if (ORourke.lineLineIntersection(pm, p, qm, q, parameter, 1.0E-8) && parameter.x >= 0.0 && parameter.x <= 1.0 && parameter.y >= 0.0 && parameter.y <= 1.0) {
                ipp.assign(pm.add(pd.multiply(parameter.x)));
                ipq.assign(qm.add(qd.multiply(parameter.y)));
                if (++intersections > 1) {
                    if (firstIntersection.minus(ipp).xynorm() < 1.0E-8 && firstIntersectionIter != iter - 1) {
                        return;
                    }
                } else {
                    firstIntersection.assign(ipp);
                    firstIntersectionIter = iter;
                }
                if (ORourke.testPoint(firstAddedPoint, previouslyAddedPoint, ipp, addedpoints)) {
                    result.intersection(ipp, ipq);
                    ++addedpoints;
                }
                inside = ORourke.isInHalfplane(p, qm, q) ? State.P : State.Q;
            }
            if (qd.cross((Vector3)pd).z >= 0.0) {
                if (ORourke.isInHalfplane(p, qm, q)) {
                    if (inside == State.Q && ORourke.testPoint(firstAddedPoint, previouslyAddedPoint, q, addedpoints)) {
                        result.intersection(ORourke.projectToPlane(q, poly1normal, p), q);
                        ++addedpoints;
                    }
                    qm.assign(q);
                    if (!poly2points.hasNext()) {
                        poly2points = poly2.iterator();
                    }
                    q.assign(poly2points.next());
                    qd.assign(q.minus(qm));
                    continue;
                }
                if (inside == State.P && ORourke.testPoint(firstAddedPoint, previouslyAddedPoint, p, addedpoints)) {
                    result.intersection(p, ORourke.projectToPlane(p, poly2normal, q));
                    ++addedpoints;
                }
                pm.assign(p);
                if (!poly1points.hasNext()) {
                    poly1points = poly1.iterator();
                }
                p.assign(poly1points.next());
                pd.assign(p.minus(pm));
                continue;
            }
            if (ORourke.isInHalfplane(q, pm, p)) {
                if (inside == State.P && ORourke.testPoint(firstAddedPoint, previouslyAddedPoint, p, addedpoints)) {
                    result.intersection(p, ORourke.projectToPlane(p, poly2normal, q));
                    ++addedpoints;
                }
                pm.assign(p);
                if (!poly1points.hasNext()) {
                    poly1points = poly1.iterator();
                }
                p.assign(poly1points.next());
                pd.assign(p.minus(pm));
                continue;
            }
            if (inside == State.Q && ORourke.testPoint(firstAddedPoint, previouslyAddedPoint, q, addedpoints)) {
                result.intersection(ORourke.projectToPlane(q, poly1normal, p), q);
                ++addedpoints;
            }
            qm.assign(q);
            if (!poly2points.hasNext()) {
                poly2points = poly2.iterator();
            }
            q.assign(poly2points.next());
            qd.assign(q.minus(qm));
        } while (iter <= 2 * (N + M));
        if (ORourke.isContained(p, poly2.iterator()) && M > 2) {
            for (Vector3 pi : poly1) {
                result.intersection(pi, ORourke.projectToPlane(pi, poly2normal, q));
            }
            return;
        }
        if (ORourke.isContained(q, poly1.iterator()) && N > 2) {
            for (Vector3 qi : poly2) {
                result.intersection(ORourke.projectToPlane(qi, poly1normal, p), qi);
            }
            return;
        }
    }

    private static final boolean testPoint(Vector3 first, Vector3 prev, Vector3 point, int addedPoints) {
        if (addedPoints < 1) {
            first.assign(point);
            prev.assign(point);
            return true;
        }
        if (addedPoints < 2) {
            if (first.minus(point).xynorm() > 1.0E-8) {
                prev.assign(point);
                return true;
            }
            return false;
        }
        if (first.minus(point).xynorm() > 1.0E-8 && prev.minus(point).xynorm() > 1.0E-8) {
            prev.assign(point);
            return true;
        }
        return false;
    }

    private static final boolean pointLineIntersection(Vector3 x, Vector3 p1, Vector3 p2, Vector3 intPoint) {
        Vector3 lp;
        Vector3 p2p1 = p2.minus(p1);
        p2p1.z = 0.0;
        double t = x.minus(p1).dot(p2p1) / p2p1.squaredNorm();
        if (t >= 0.0 && t <= 1.0 && (lp = p1.add(p2.minus(p1).multiply(t))).minus(x).xynorm() < 1.0E-8) {
            intPoint.assign(lp);
            return true;
        }
        return false;
    }

    private static final void linePolyIntersection(Vector3 p1, Vector3 p2, List<Vector3> poly, Vector3 polynormal, ResultHandler result) {
        Vector3 out1 = new Vector3();
        Vector3 out2 = new Vector3();
        boolean keepp1 = true;
        boolean keepp2 = true;
        int intersections = 0;
        int N = poly.size();
        Vector3 qm = new Vector3();
        Vector3 q = new Vector3(poly.get(N - 1));
        Vector3 polypoint = new Vector3(q);
        Vector3 param = new Vector3();
        for (int iter = 0; iter < N; ++iter) {
            qm.assign(q);
            q.assign(poly.get(iter));
            if (keepp1 && !ORourke.isInHalfplane(p1, qm, q)) {
                keepp1 = false;
            }
            if (keepp2 && !ORourke.isInHalfplane(p2, qm, q)) {
                keepp2 = false;
            }
            if (!ORourke.lineLineIntersection(p1, p2, qm, q, param, 1.0E-8) || !(0.0 <= param.x) || !(param.x <= 1.0) || !(0.0 <= param.y) || !(param.y <= 1.0)) continue;
            Vector3 ipp = p1.add(p2.minus(p1).multiply(param.x));
            Vector3 ipq = qm.add(q.minus(qm).multiply(param.y));
            switch (intersections) {
                case 0: {
                    if (!(out1.minus(ipp).norm() > 1.0E-8)) break;
                    out1.assign(ipp);
                    result.intersection(ipp, ipq);
                    ++intersections;
                    break;
                }
                case 1: {
                    if (!(out2.minus(ipp).norm() > 1.0E-8)) break;
                    out2.assign(ipp);
                    result.intersection(ipp, ipq);
                    ++intersections;
                }
            }
            if (intersections <= 1) continue;
            return;
        }
        if (intersections < 1) {
            if (keepp1 && keepp2) {
                result.intersection(p1, ORourke.projectToPlane(p1, polynormal, polypoint));
                result.intersection(p2, ORourke.projectToPlane(p2, polynormal, polypoint));
                return;
            }
            if (!keepp1 && !keepp2) {
                return;
            }
            return;
        }
        if (intersections < 2) {
            if (keepp1) {
                result.intersection(p1, ORourke.projectToPlane(p1, polynormal, polypoint));
                return;
            }
            if (keepp2) {
                result.intersection(p2, ORourke.projectToPlane(p2, polynormal, polypoint));
                return;
            }
            return;
        }
    }

    private static final Vector3 projectToPlane(Vector3 point, Vector3 normal, Vector3 ref) {
        return point.add(0.0, 0.0, ref.minus(point).dot(normal) / normal.z);
    }

    public static final boolean isInHalfplane(Vector3 a, Vector3 bs, Vector3 bt) {
        return bt.minus((Vector3)bs).cross((Vector3)a.minus((Vector3)bs)).z >= 0.0;
    }

    private static final void polyNormal(List<Vector3> poly, Vector3 normal) {
        Vector3 p3 = poly.get(0);
        Vector3 p4 = poly.get(1);
        Vector3 p5 = poly.get(2);
        Vector3 poly1normal = p5.minus(p3).cross(p3.minus(p4));
        normal.assign(poly1normal.normalize());
    }

    public static final boolean isContained(Vector3 p, Iterator<Vector3> poly) {
        Vector3 p0;
        Vector3 pm = p0 = poly.next();
        while (poly.hasNext()) {
            Vector3 pi = poly.next();
            if (!ORourke.isInHalfplane(p, pm, pi)) {
                return false;
            }
            pm = pi;
        }
        return ORourke.isInHalfplane(p, pm, p0);
    }

    public static final boolean lineLineIntersection(Vector3 ps, Vector3 pt, Vector3 qs, Vector3 qt, Vector3 st, double epsilon) {
        Vector3 pd = pt.minus(ps);
        Vector3 qd = qs.minus(qt);
        Vector3 b = qs.minus(ps);
        double det = pd.x * qd.y - pd.y * qd.x;
        if (Math.abs(det) < epsilon) {
            return false;
        }
        double alpha = 1.0 / det * (qd.y * b.x + -qd.x * b.y);
        double beta = 1.0 / det * (-pd.y * b.x + pd.x * b.y);
        st.x = alpha;
        st.y = beta;
        return true;
    }

    private static enum State {
        none,
        P,
        Q;

    }

    public static interface ResultHandler {
        public void intersection(Vector3 var1, Vector3 var2);
    }
}

