/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.teams.EntityConnectingLine;
import com.flansmod.common.teams.ITeamBase;
import com.flansmod.common.teams.ITeamObject;
import com.flansmod.common.teams.Team;
import com.flansmod.common.teams.TeamsManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemOpStick
extends Item {
    public static final String[] stickNames = new String[]{"opStick_ownership", "opStick_connecting", "opStick_mapping", "opStick_destruction"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemOpStick() {
        this.func_77655_b("opStick");
        this.func_77627_a(true);
    }

    public boolean func_77629_n_() {
        return true;
    }

    public boolean func_77662_d() {
        return true;
    }

    public void clickedEntity(World world, EntityPlayer player, Entity clicked) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        if (clicked instanceof ITeamBase) {
            this.clickedBase(world, (EntityPlayerMP)player, (ITeamBase)clicked);
        }
        if (clicked instanceof ITeamObject) {
            this.clickedObject(world, (EntityPlayerMP)player, (ITeamObject)clicked);
        }
    }

    public void clickedBase(World world, EntityPlayerMP player, ITeamBase base) {
        int damage = player.field_71071_by.func_70448_g().func_77960_j();
        TeamsManager teamsManager = TeamsManager.getInstance();
        switch (damage) {
            case 0: {
                if (teamsManager.teams == null) {
                    TeamsManager.messagePlayer(player, "Please set up teams before editing this base");
                    return;
                }
                Team currentOwner = base.getOwner();
                Team newOwner = null;
                if (currentOwner == null) {
                    newOwner = teamsManager.teams != null ? teamsManager.teams[0] : Team.spectators;
                } else if (currentOwner == Team.spectators) {
                    newOwner = null;
                } else {
                    for (int i = 0; i < teamsManager.teams.length; ++i) {
                        if (currentOwner != teamsManager.teams[i]) continue;
                        newOwner = i == teamsManager.teams.length - 1 ? Team.spectators : teamsManager.teams[i + 1];
                    }
                }
                TeamsManager.messagePlayer(player, "Base owner changed to " + (newOwner == null ? "none" : newOwner.shortName));
                if (currentOwner != null) {
                    currentOwner.bases.remove(base);
                }
                base.setBase(newOwner);
                if (newOwner != null) {
                    newOwner.bases.add(base);
                }
                for (ITeamObject object : base.getObjects()) {
                    object.onBaseSet(newOwner);
                }
                break;
            }
            case 1: {
                if (player.field_71104_cf == null) {
                    EntityConnectingLine hook = new EntityConnectingLine(world, (EntityPlayer)player, base);
                    world.func_72838_d((Entity)hook);
                    break;
                }
                if (!(player.field_71104_cf instanceof EntityConnectingLine)) break;
                EntityConnectingLine line = (EntityConnectingLine)player.field_71104_cf;
                if (line.connectedTo instanceof ITeamObject) {
                    ITeamObject object = (ITeamObject)line.connectedTo;
                    object.setBase(base);
                    base.addObject(object);
                    line.func_70106_y();
                    player.field_71104_cf = null;
                    TeamsManager.messagePlayer(player, "Successfully connected.");
                    break;
                }
                TeamsManager.messagePlayer(player, "Cannot connect bases to bases.");
                break;
            }
            case 2: {
                TeamsManager.TeamsMap currentMap = base.getMap();
                int mapID = teamsManager.maps.indexOf(currentMap);
                TeamsManager.TeamsMap newMap = teamsManager.maps.get((mapID + 1) % teamsManager.maps.size());
                base.setMap(newMap);
                TeamsManager.messagePlayer(player, "Set map for this base to " + newMap.name + ".");
                break;
            }
            case 3: {
                base.destroy();
            }
        }
    }

    public void clickedObject(World world, EntityPlayerMP player, ITeamObject object) {
        int damage = player.field_71071_by.func_70448_g().func_77960_j();
        TeamsManager teamsManager = TeamsManager.getInstance();
        switch (damage) {
            case 0: {
                break;
            }
            case 1: {
                if (player.field_71104_cf == null) {
                    EntityConnectingLine hook = new EntityConnectingLine(world, (EntityPlayer)player, object);
                    world.func_72838_d((Entity)hook);
                    break;
                }
                if (!(player.field_71104_cf instanceof EntityConnectingLine)) break;
                EntityConnectingLine line = (EntityConnectingLine)player.field_71104_cf;
                if (line.connectedTo instanceof ITeamBase) {
                    ITeamBase base = (ITeamBase)line.connectedTo;
                    object.setBase(base);
                    base.addObject(object);
                    TeamsManager.messagePlayer(player, "Successfully connected.");
                    break;
                }
                TeamsManager.messagePlayer(player, "Cannot connect objects to objects.");
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                object.destroy();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.icons = new IIcon[stickNames.length];
        for (int i = 0; i < stickNames.length; ++i) {
            this.icons[i] = register.func_94245_a("FlansMod:" + stickNames[i]);
            this.field_77791_bV = this.icons[i];
        }
    }

    public IIcon func_77617_a(int damage) {
        int j = MathHelper.func_76125_a((int)damage, (int)0, (int)15);
        return this.icons[j];
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + stack.func_77960_j();
    }
}

