/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.client.model.ModelDriveable;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.CollisionBox;
import com.flansmod.common.driveables.CollisionPoint;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.PilotGun;
import com.flansmod.common.driveables.Seat;
import com.flansmod.common.parts.PartType;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import com.flansmod.common.vector.Vector3f;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;

public class DriveableType
extends InfoType {
    @SideOnly(value=Side.CLIENT)
    public ModelDriveable model;
    public ArrayList<CollisionPoint> points = new ArrayList();
    public HashMap<EnumDriveablePart, CollisionBox> health = new HashMap();
    public HashMap<EnumDriveablePart, ItemStack[]> partwiseRecipe = new HashMap();
    public ArrayList<ItemStack> recipe = new ArrayList();
    public int numPassengers = 0;
    public Seat[] seats;
    public int numPassengerGunners = 0;
    public int nextGunID = 0;
    public int numCargoSlots;
    public int numBombSlots;
    public int fuelTankSize = 100;
    public ArrayList<PilotGun> guns = new ArrayList();
    public Vector3f rotatedDriverOffset = new Vector3f();
    public float yOffset = 0.625f;
    public float cameraDistance = 5.0f;
    public float maxThrottle = 1.0f;
    public float maxNegativeThrottle = 0.0f;
    public float mass = 1.0f;
    public float drag = 1.0f;
    public float momentOfInertia = 1.0f;
    public float bounciness = 0.4f;
    public float bulletDetectionRadius = 5.0f;
    public boolean onRadar = false;
    public String startSound;
    public int startSoundLength;
    public String engineSound;
    public int engineSoundLength;
    public String shootMainSound;
    public String shootSecondarySound;
    public static ArrayList<DriveableType> types = new ArrayList();

    public DriveableType(TypeFile file) {
        super(file);
        for (String line : file.lines) {
            String[] split;
            if (line == null) break;
            if (line.startsWith("//") || (split = line.split(" ")).length < 2 || !split[0].equals("Passengers")) continue;
            this.numPassengers = Integer.parseInt(split[1]);
            this.seats = new Seat[this.numPassengers + 1];
        }
        types.add(this);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        try {
            int i;
            EnumDriveablePart part;
            if (FMLCommonHandler.instance().getSide().isClient() && split[0].equals("Model")) {
                this.model = FlansMod.proxy.loadModel(split[1], this.shortName, ModelDriveable.class);
            }
            if (split[0].equals("Texture")) {
                this.texture = split[1];
            }
            if (split[0].equals("MaxThrottle")) {
                this.maxThrottle = Float.parseFloat(split[1]);
            }
            if (split[0].equals("MaxNegativeThrottle")) {
                this.maxNegativeThrottle = Float.parseFloat(split[1]);
            }
            if (split[0].equals("Mass")) {
                this.mass = Float.parseFloat(split[1]);
            }
            if (split[0].equals("MomentOfInertia")) {
                this.momentOfInertia = Float.parseFloat(split[1]);
            }
            if (split[0].equals("Drag")) {
                this.drag = Float.parseFloat(split[1]);
            }
            if (split[0].equals("Bounciness")) {
                this.bounciness = Float.parseFloat(split[1]);
            }
            if (split[0].equals("CargoSlots")) {
                this.numCargoSlots = Integer.parseInt(split[1]);
            }
            if (split[0].equals("BombSlots") || split[0].equals("ShellSlots")) {
                this.numBombSlots = Integer.parseInt(split[1]);
            }
            if (split[0].equals("FuelTankSize")) {
                this.fuelTankSize = Integer.parseInt(split[1]);
            }
            if (split[0].equals("BulletDetection")) {
                this.bulletDetectionRadius = Integer.parseInt(split[1]);
            }
            if (split[0].equals("AddRecipeParts")) {
                part = EnumDriveablePart.getPart(split[1]);
                ItemStack[] stacks = new ItemStack[(split.length - 2) / 2];
                for (i = 0; i < (split.length - 2) / 2; ++i) {
                    int amount = Integer.parseInt(split[2 * i + 2]);
                    boolean damaged = split[2 * i + 3].contains(".");
                    String itemName = damaged ? split[2 * i + 3].split("\\.")[0] : split[2 * i + 3];
                    int damage = damaged ? Integer.parseInt(split[2 * i + 3].split("\\.")[1]) : 0;
                    stacks[i] = DriveableType.getRecipeElement(itemName, amount, damage);
                    this.recipe.add(stacks[i]);
                }
                this.partwiseRecipe.put(part, stacks);
            }
            if (split[0].equals("AddDye")) {
                int amount = Integer.parseInt(split[1]);
                int damage = -1;
                for (i = 0; i < ItemDye.field_150923_a.length; ++i) {
                    if (!ItemDye.field_150923_a[i].equals(split[2])) continue;
                    damage = i;
                }
                if (damage == -1) {
                    FlansMod.log("Failed to find dye colour : " + split[2] + " while adding " + file.name);
                    return;
                }
                this.recipe.add(new ItemStack(Items.field_151100_aR, amount, damage));
            }
            if (split[0].equals("SetupPart")) {
                part = EnumDriveablePart.getPart(split[1]);
                CollisionBox box = new CollisionBox(Integer.parseInt(split[2]), Integer.parseInt(split[3]), Integer.parseInt(split[4]), Integer.parseInt(split[5]), Integer.parseInt(split[6]), Integer.parseInt(split[7]), Integer.parseInt(split[8]));
                this.health.put(part, box);
                for (i = 0; i < 2; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        for (int k = 0; k < 2; ++k) {
                            this.points.add(new CollisionPoint(box.x + i * box.w, box.y + j * box.h, box.z + k * box.d, part.getShortName(), 1.0f));
                        }
                    }
                }
            }
            if (split[0].equals("Driver") || split[0].equals("Pilot")) {
                this.seats[0] = split.length > 4 ? new Seat(Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Float.parseFloat(split[4]), Float.parseFloat(split[5]), Float.parseFloat(split[6]), Float.parseFloat(split[7])) : new Seat(Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]));
            }
            if (split[0].equals("RotatedDriverOffset")) {
                this.rotatedDriverOffset = new Vector3f((float)Integer.parseInt(split[1]) / 16.0f, (float)Integer.parseInt(split[2]) / 16.0f, (float)Integer.parseInt(split[3]) / 16.0f);
            }
            if (split[0].equals("Passenger")) {
                Seat seat;
                this.seats[seat.id] = seat = new Seat(split);
                if (seat.gunType != null) {
                    seat.gunnerID = this.numPassengerGunners++;
                    this.recipe.add(new ItemStack(seat.gunType.item));
                }
            }
            if (split[0].equals("AddGun")) {
                PilotGun gun = new PilotGun(split);
                this.guns.add(gun);
                gun.gunID = this.nextGunID++;
                this.recipe.add(new ItemStack(gun.type.item));
            }
            if (split[0].equals("YOffset")) {
                this.yOffset = Float.parseFloat(split[1]);
            }
            if (split[0].equals("CameraDistance")) {
                this.cameraDistance = Float.parseFloat(split[1]);
            }
            if (split[0].equals("StartSoundLength")) {
                this.startSoundLength = Integer.parseInt(split[1]);
            }
            if (split[0].equals("EngineSoundLength")) {
                this.engineSoundLength = Integer.parseInt(split[1]);
            }
            if (split[0].equals("StartSound")) {
                this.startSound = split[1];
                FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
            }
            if (split[0].equals("EngineSound")) {
                this.engineSound = split[1];
                FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
            }
            if (split[0].equals("ShootMainSound")) {
                this.shootMainSound = split[1];
                FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
            }
            if (split[0].equals("ShootSecondarySound")) {
                this.shootSecondarySound = split[1];
                FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
            }
            if (split[0].equals("OnRadar")) {
                this.onRadar = split[1].equals("True");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int numEngines() {
        return 1;
    }

    public int ammoSlots() {
        return this.numPassengerGunners + this.guns.size();
    }

    public ArrayList<ItemStack> getItemsRequired(DriveablePart part, PartType engine) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (this.partwiseRecipe.get((Object)part.type) != null) {
            for (ItemStack itemStack : this.partwiseRecipe.get((Object)part.type)) {
                stacks.add(itemStack.func_77946_l());
            }
        }
        for (PilotGun gun : this.guns) {
            if (gun.driveablePart != part.type) continue;
            stacks.add(new ItemStack(gun.type.item));
        }
        for (Seat seat : this.seats) {
            if (seat == null || seat.part != part.type || seat.gunType == null) continue;
            stacks.add(new ItemStack(seat.gunType.item));
        }
        return stacks;
    }

    public static DriveableType getDriveable(String find) {
        for (DriveableType type : types) {
            if (!type.shortName.equals(find)) continue;
            return type;
        }
        return null;
    }
}

