/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.PhysHelper;
import ckathode.weaponmod.WeaponModAttributes;
import ckathode.weaponmod.item.AbstractWeaponComponent;
import ckathode.weaponmod.item.IExtendedReachItem;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class MeleeComponent
extends AbstractWeaponComponent {
    public final MeleeSpecs meleeSpecs;
    public final Item.ToolMaterial weaponMaterial;

    public MeleeComponent(MeleeSpecs meleespecs, Item.ToolMaterial toolmaterial) {
        this.meleeSpecs = meleespecs;
        this.weaponMaterial = toolmaterial;
    }

    @Override
    protected void onSetItem() {
    }

    @Override
    public void setThisItemProperties() {
        if (this.weaponMaterial == null) {
            this.item.func_77656_e(this.meleeSpecs.durabilityBase);
        } else {
            this.item.func_77656_e((int)((float)this.meleeSpecs.durabilityBase + (float)this.weaponMaterial.func_77997_a() * this.meleeSpecs.damageMult));
        }
        this.item.func_77625_d(this.meleeSpecs.stackSize);
    }

    @Override
    public float getEntityDamageMaterialPart() {
        if (this.weaponMaterial == null) {
            return 0.0f;
        }
        return this.weaponMaterial.func_78000_c() * this.meleeSpecs.damageMult;
    }

    @Override
    public float getEntityDamage() {
        return this.meleeSpecs.damageBase + this.getEntityDamageMaterialPart();
    }

    @Override
    public float getBlockDamage(ItemStack itemstack, Block block) {
        if (this.canHarvestBlock(block)) {
            return this.meleeSpecs.blockDamage * 10.0f;
        }
        Material material = block.func_149688_o();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && material != Material.field_151584_j && material != Material.field_151572_C ? 1.0f : this.meleeSpecs.blockDamage;
    }

    @Override
    public boolean canHarvestBlock(Block block) {
        return block == Blocks.field_150321_G;
    }

    @Override
    public boolean onBlockDestroyed(ItemStack itemstack, World world, Block block, int j, int k, int l, EntityLivingBase entityliving) {
        if ((this.meleeSpecs.blockDamage > 1.0f || this.canHarvestBlock(block)) && block.func_149712_f(world, j, k, l) != 0.0f) {
            itemstack.func_77972_a(this.meleeSpecs.dmgFromBlock, entityliving);
        }
        return true;
    }

    @Override
    public boolean hitEntity(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase attacker) {
        if (entityliving.field_70172_ad == entityliving.field_70771_an) {
            float kb = this.getKnockBack(itemstack, entityliving, attacker);
            PhysHelper.knockBack(entityliving, attacker, kb);
            entityliving.field_70172_ad += this.meleeSpecs.attackDelay;
        }
        itemstack.func_77972_a(this.meleeSpecs.dmgFromEntity, attacker);
        return true;
    }

    @Override
    public float getKnockBack(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase attacker) {
        return this.meleeSpecs.getKnockBack(this.weaponMaterial);
    }

    @Override
    public int getItemEnchantability() {
        return this.weaponMaterial == null ? 1 : this.weaponMaterial.func_77995_e();
    }

    @Override
    public void addItemAttributeModifiers(Multimap<String, AttributeModifier> multimap) {
        float dmg = this.getEntityDamage();
        if (dmg > 0.0f || this.meleeSpecs.damageMult > 0.0f) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(this.weapon.getUUID(), "Weapon modifier", (double)dmg, 0));
        }
        multimap.put((Object)WeaponModAttributes.WEAPON_KNOCKBACK.func_111108_a(), (Object)new AttributeModifier(this.weapon.getUUID(), "Weapon knockback modifier", (double)(this.meleeSpecs.getKnockBack(this.weaponMaterial) - 0.4f), 0));
        multimap.put((Object)WeaponModAttributes.ATTACK_SPEED.func_111108_a(), (Object)new AttributeModifier(this.weapon.getUUID(), "Weapon attack speed modifier", (double)(-this.meleeSpecs.attackDelay), 0));
        if (this instanceof IExtendedReachItem) {
            try {
                multimap.put((Object)WeaponModAttributes.WEAPON_REACH.func_111108_a(), (Object)new AttributeModifier(this.weapon.getUUID(), "Weapon reach modifier", (double)(((IExtendedReachItem)((Object)this)).getExtendedReach(null, null, null) - 3.0f), 0));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean onLeftClickEntity(ItemStack itemstack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            PhysHelper.prepareKnockbackOnEntity((EntityLivingBase)player, (EntityLivingBase)entity);
        }
        return false;
    }

    @Override
    public EnumAction getItemUseAction(ItemStack itemstack) {
        return EnumAction.block;
    }

    @Override
    public int getMaxItemUseDuration(ItemStack itemstack) {
        return 72000;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        entityplayer.func_71008_a(itemstack, this.getMaxItemUseDuration(itemstack));
        return itemstack;
    }

    @Override
    public void onUsingTick(ItemStack itemstack, EntityPlayer entityplayer, int count) {
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer entityplayer, int i) {
    }

    @Override
    public void onUpdate(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRotateAroundWhenRendering() {
        return false;
    }

    public static enum MeleeSpecs {
        SPEAR(0, 1.0f, 3.0f, 1.0f, 1.0f, 0.2f, 1, 2, 1, 0),
        HALBERD(0, 1.0f, 3.0f, 1.0f, 1.5f, 0.6f, 1, 2, 1, 8),
        BATTLEAXE(0, 1.0f, 3.0f, 1.0f, 1.5f, 0.5f, 1, 2, 1, 5),
        WARHAMMER(0, 1.0f, 4.0f, 1.0f, 1.0f, 0.7f, 1, 2, 1, 5),
        KNIFE(0, 0.5f, 3.0f, 1.0f, 1.5f, 0.2f, 1, 2, 1, 0),
        KATANA(0, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1, 2, 1, -6),
        FIREROD(1, 0.0f, 1.0f, 0.0f, 1.0f, 0.4f, 2, 0, 1, 0),
        BOOMERANG(0, 0.5f, 2.0f, 1.0f, 1.0f, 0.4f, 1, 1, 1, 0),
        NONE(0, 0.0f, 1.0f, 0.0f, 1.0f, 0.4f, 0, 0, 1, 0);

        public final int durabilityBase;
        public final float durabilityMult;
        public final float damageBase;
        public final float damageMult;
        public final float blockDamage;
        public final float knockback;
        public final int dmgFromEntity;
        public final int dmgFromBlock;
        public final int stackSize;
        public final int attackDelay;

        private MeleeSpecs(int durbase, float durmult, float dmgbase, float dmgmult, float blockdmg, float knockback, int dmgfromentity, int dmgfromblock, int stacksize, int attackdelay) {
            this.durabilityBase = durbase;
            this.durabilityMult = durmult;
            this.damageBase = dmgbase;
            this.damageMult = dmgmult;
            this.blockDamage = blockdmg;
            this.knockback = knockback;
            this.dmgFromEntity = dmgfromentity;
            this.dmgFromBlock = dmgfromblock;
            this.stackSize = stacksize;
            this.attackDelay = attackdelay;
        }

        public float getKnockBack(Item.ToolMaterial material) {
            return material == Item.ToolMaterial.GOLD ? this.knockback * 1.5f : this.knockback;
        }
    }
}

