/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.item.IItemWeapon;
import ckathode.weaponmod.item.MeleeComponent;
import ckathode.weaponmod.item.RangedComponent;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemShooter
extends ItemBow
implements IItemWeapon {
    protected static final int MAX_DELAY = 72000;
    public final RangedComponent rangedComponent;
    public final MeleeComponent meleeComponent;

    public ItemShooter(String id, RangedComponent rangedcomponent, MeleeComponent meleecomponent) {
        GameRegistry.registerItem((Item)this, (String)id, (String)"weaponmod");
        this.func_77655_b(id);
        this.func_111206_d("weaponmod:" + id);
        this.rangedComponent = rangedcomponent;
        this.meleeComponent = meleecomponent;
        rangedcomponent.setItem(this);
        meleecomponent.setItem(this);
        rangedcomponent.setThisItemProperties();
    }

    public float func_150893_a(ItemStack itemstack, Block block) {
        return this.meleeComponent.getBlockDamage(itemstack, block);
    }

    public boolean func_150897_b(Block block) {
        return this.meleeComponent.canHarvestBlock(block);
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase attacker) {
        return this.meleeComponent.hitEntity(itemstack, entityliving, attacker);
    }

    public boolean func_150894_a(ItemStack itemstack, World world, Block block, int j, int k, int l, EntityLivingBase entityliving) {
        return this.meleeComponent.onBlockDestroyed(itemstack, world, block, j, k, l, entityliving);
    }

    public int func_77619_b() {
        return this.meleeComponent.getItemEnchantability();
    }

    public Multimap<String, AttributeModifier> func_111205_h() {
        HashMultimap multimap = HashMultimap.create();
        this.meleeComponent.addItemAttributeModifiers((Multimap<String, AttributeModifier>)multimap);
        this.rangedComponent.addItemAttributeModifiers((Multimap<String, AttributeModifier>)multimap);
        return multimap;
    }

    @Override
    public boolean onLeftClickEntity(ItemStack itemstack, EntityPlayer player, Entity entity) {
        return this.meleeComponent.onLeftClickEntity(itemstack, player, entity) && this.rangedComponent.onLeftClickEntity(itemstack, player, entity);
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        return this.rangedComponent.getItemUseAction(itemstack);
    }

    public int func_77626_a(ItemStack itemstack) {
        return this.rangedComponent.getMaxItemUseDuration(itemstack);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        return this.rangedComponent.onItemRightClick(itemstack, world, entityplayer);
    }

    public void onUsingTick(ItemStack itemstack, EntityPlayer entityplayer, int count) {
        this.rangedComponent.onUsingTick(itemstack, entityplayer, count);
    }

    public void func_77615_a(ItemStack itemstack, World world, EntityPlayer entityplayer, int i) {
        this.rangedComponent.onPlayerStoppedUsing(itemstack, world, entityplayer, i);
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
        this.meleeComponent.onUpdate(itemstack, world, entity, i, flag);
        this.rangedComponent.onUpdate(itemstack, world, entity, i, flag);
    }

    public boolean func_77629_n_() {
        return this.rangedComponent.shouldRotateAroundWhenRendering();
    }

    @Override
    public final UUID getUUID() {
        return field_111210_e;
    }

    @Override
    public final Random getItemRand() {
        return field_77697_d;
    }

    @Override
    public MeleeComponent getMeleeComponent() {
        return this.meleeComponent;
    }

    @Override
    public RangedComponent getRangedComponent() {
        return this.rangedComponent;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconregister) {
        this.field_77791_bV = iconregister.func_94245_a(this.func_111208_A());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }
}

