/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod;

import ckathode.weaponmod.BalkonsWeaponMod;
import net.minecraft.entity.DataWatcher;
import net.minecraft.entity.player.EntityPlayer;

public abstract class PlayerWeaponData {
    public static final int BOOLEANS = 26;
    public static final int WARHAMMER_LAST_SMASH_TICKS = 27;
    public static final int FLAIL_ENTITY_ID = 28;
    public static final int WARHAMMER_CHARGED = 1;
    public static final int FLAIL_THROWN = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initPlayerWeaponData(EntityPlayer player) {
        String playername = PlayerWeaponData.getPlayerName(player);
        BalkonsWeaponMod.modLog.trace("Initializing DataWatcher values for " + playername);
        DataWatcher datawatcher = player.func_70096_w();
        try {
            datawatcher.func_75679_c(26);
        }
        catch (NullPointerException e) {
            BalkonsWeaponMod.modLog.warn("DataWatcher ID conflict for " + playername + " @ " + 26);
        }
        finally {
            datawatcher.func_75682_a(26, (Object)0);
        }
        try {
            datawatcher.func_75679_c(27);
        }
        catch (NullPointerException e) {
            BalkonsWeaponMod.modLog.warn("DataWatcher ID conflict for " + playername + " @ " + 27);
        }
        finally {
            datawatcher.func_75682_a(27, (Object)player.field_70173_aa);
        }
        try {
            datawatcher.func_75679_c(28);
        }
        catch (NullPointerException e) {
            BalkonsWeaponMod.modLog.warn("DataWatcher ID conflict for " + playername + " @ " + 28);
        }
        finally {
            datawatcher.func_75682_a(28, (Object)0);
        }
    }

    private static String getPlayerName(EntityPlayer player) {
        String playername = player.func_146103_bH() != null ? player.func_70005_c_() : "[unknown]";
        playername = "player:" + playername;
        return playername;
    }

    private static void unavailableError(EntityPlayer player, int id) {
        BalkonsWeaponMod.modLog.error("DataWatcher ID " + id + " for " + PlayerWeaponData.getPlayerName(player) + " unavailable, trying to reinitialize");
        PlayerWeaponData.initPlayerWeaponData(player);
    }

    public static void setFlailEntityId(EntityPlayer player, int id) {
        try {
            player.func_70096_w().func_75692_b(28, (Object)id);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, 28);
        }
    }

    public static int getFlailEntityId(EntityPlayer player) {
        try {
            return player.func_70096_w().func_75679_c(28);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, 28);
            return 0;
        }
    }

    public static int getLastWarhammerSmashTicks(EntityPlayer player) {
        try {
            return player.func_70096_w().func_75679_c(27);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, 27);
            return 0;
        }
    }

    public static void setLastWarhammerSmashTicks(EntityPlayer player, int age) {
        try {
            player.func_70096_w().func_75692_b(27, (Object)age);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, 27);
        }
    }

    public static void setFlailThrown(EntityPlayer player, boolean flag) {
        PlayerWeaponData.setBoolean(player, 2, flag);
    }

    public static boolean isFlailThrown(EntityPlayer player) {
        return PlayerWeaponData.getBoolean(player.func_70096_w().func_75679_c(26), 2);
    }

    public static void setBoolean(EntityPlayer player, int state, boolean flag) {
        try {
            int i = player.func_70096_w().func_75679_c(26);
            i = PlayerWeaponData.setBoolean(i, state, flag);
            player.func_70096_w().func_75692_b(26, (Object)i);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, 26);
        }
    }

    public static boolean getBoolean(EntityPlayer player, int state) {
        try {
            return PlayerWeaponData.getBoolean(player.func_70096_w().func_75679_c(26), state);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, 26);
            return false;
        }
    }

    private static boolean getBoolean(int i, int pos) {
        return (i & 1 << pos) != 0;
    }

    private static int setBoolean(int i, int pos, boolean flag) {
        int mask = 1 << pos;
        i &= ~mask;
        if (flag) {
            i |= mask;
        }
        return i;
    }
}

