/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class AdvancedExplosion
extends Explosion {
    public World field_77287_j;
    protected boolean blocksCalculated;
    protected static final Random rand = new Random();

    public AdvancedExplosion(World world, Entity entity, double d, double d1, double d2, float f) {
        super(world, entity, d, d1, d2, f);
        this.field_77287_j = world;
    }

    public void setAffectedBlockPositions(List<ChunkPosition> list) {
        this.field_77281_g = list;
        this.blocksCalculated = true;
    }

    public void doEntityExplosion() {
        this.doEntityExplosion(DamageSource.func_94539_a((Explosion)this));
    }

    public void doEntityExplosion(DamageSource damagesource) {
        float size = this.field_77280_f * 2.0f;
        int i0 = MathHelper.func_76128_c((double)(this.field_77284_b - (double)size - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.field_77284_b + (double)size + 1.0));
        int j0 = MathHelper.func_76128_c((double)(this.field_77285_c - (double)size - 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.field_77285_c + (double)size + 1.0));
        int k0 = MathHelper.func_76128_c((double)(this.field_77282_d - (double)size - 1.0));
        int k1 = MathHelper.func_76128_c((double)(this.field_77282_d + (double)size + 1.0));
        List list = this.field_77287_j.func_72839_b(this.field_77283_e, AxisAlignedBB.func_72332_a().func_72299_a((double)i0, (double)j0, (double)k0, (double)i1, (double)j1, (double)k1));
        Vec3 vec31 = Vec3.func_72443_a((double)this.field_77284_b, (double)this.field_77285_c, (double)this.field_77282_d);
        for (int i = 0; i < list.size(); ++i) {
            double dz;
            double dy;
            double dx;
            double d;
            Entity entity = (Entity)list.get(i);
            double dr = entity.func_70011_f(this.field_77284_b, this.field_77285_c, this.field_77282_d) / (double)size;
            if (!(dr <= 1.0) || (d = (double)MathHelper.func_76133_a((double)((dx = entity.field_70165_t - this.field_77284_b) * dx + (dy = entity.field_70163_u - this.field_77285_c) * dy + (dz = entity.field_70161_v - this.field_77282_d) * dz))) == 0.0) continue;
            dx /= d;
            dy /= d;
            dz /= d;
            double dens = this.field_77287_j.func_72842_a(vec31, entity.field_70121_D);
            double var36 = (1.0 - dr) * dens;
            int damage = (int)((var36 * var36 + var36) / 2.0 * 8.0 * (double)size + 1.0);
            entity.func_70097_a(damagesource, (float)damage);
            entity.field_70159_w += dx * var36;
            entity.field_70181_x += dy * var36;
            entity.field_70179_y += dz * var36;
        }
    }

    public void doBlockExplosion() {
        if (!this.blocksCalculated) {
            this.calculateBlockExplosion();
        }
        for (int i = this.field_77281_g.size() - 1; i >= 0; --i) {
            ChunkPosition chunkposition = (ChunkPosition)this.field_77281_g.get(i);
            int x = chunkposition.field_151329_a;
            int y = chunkposition.field_151327_b;
            int z = chunkposition.field_151328_c;
            Block block = this.field_77287_j.func_147439_a(x, y, z);
            if (block == null) continue;
            if (block.func_149659_a((Explosion)this)) {
                block.func_149690_a(this.field_77287_j, x, y, z, this.field_77287_j.func_72805_g(x, y, z), 1.0f / this.field_77280_f, 0);
            }
            this.field_77287_j.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 3);
            block.func_149723_a(this.field_77287_j, x, y, z, (Explosion)this);
        }
    }

    public void doParticleExplosion(boolean smallparticles, boolean bigparticles) {
        this.field_77287_j.func_72908_a(this.field_77284_b, this.field_77285_c, this.field_77282_d, "random.explode", 4.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (bigparticles) {
            this.field_77287_j.func_72869_a("hugeexplosion", this.field_77284_b, this.field_77285_c, this.field_77282_d, 0.0, 0.0, 0.0);
        }
        if (!smallparticles) {
            return;
        }
        if (!this.blocksCalculated) {
            this.calculateBlockExplosion();
        }
        for (int i = this.field_77281_g.size() - 1; i >= 0; --i) {
            ChunkPosition chunkposition = (ChunkPosition)this.field_77281_g.get(i);
            int j = chunkposition.field_151329_a;
            int k = chunkposition.field_151327_b;
            int l = chunkposition.field_151328_c;
            double px = (float)j + this.field_77287_j.field_73012_v.nextFloat();
            double py = (float)k + this.field_77287_j.field_73012_v.nextFloat();
            double pz = (float)l + this.field_77287_j.field_73012_v.nextFloat();
            double dx = px - this.field_77284_b;
            double dy = py - this.field_77285_c;
            double dz = pz - this.field_77282_d;
            double distance = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
            dx /= distance;
            dy /= distance;
            dz /= distance;
            double d7 = 0.5 / (distance / (double)this.field_77280_f + 0.1);
            this.field_77287_j.func_72869_a("explode", (px + this.field_77284_b * 1.0) / 2.0, (py + this.field_77285_c * 1.0) / 2.0, (pz + this.field_77282_d * 1.0) / 2.0, dx *= (d7 *= (double)(this.field_77287_j.field_73012_v.nextFloat() * this.field_77287_j.field_73012_v.nextFloat() + 0.3f)), dy *= d7, dz *= d7);
            this.field_77287_j.func_72869_a("smoke", px, py, pz, dx, dy, dz);
        }
    }

    protected void calculateBlockExplosion() {
        int maxsize = 16;
        HashSet<ChunkPosition> set = new HashSet<ChunkPosition>();
        for (int i = 0; i < maxsize; ++i) {
            for (int j = 0; j < maxsize; ++j) {
                for (int k = 0; k < maxsize; ++k) {
                    if (i != 0 && i != maxsize - 1 && j != 0 && j != maxsize - 1 && k != 0 && k != maxsize - 1) continue;
                    double rx = (float)i / ((float)maxsize - 1.0f) * 2.0f - 1.0f;
                    double ry = (float)j / ((float)maxsize - 1.0f) * 2.0f - 1.0f;
                    double rz = (float)k / ((float)maxsize - 1.0f) * 2.0f - 1.0f;
                    double rd = Math.sqrt(rx * rx + ry * ry + rz * rz);
                    rx /= rd;
                    ry /= rd;
                    rz /= rd;
                    double dx = this.field_77284_b;
                    double dy = this.field_77285_c;
                    double dz = this.field_77282_d;
                    float f = 0.3f;
                    for (float strength = this.field_77280_f * (0.7f + this.field_77287_j.field_73012_v.nextFloat() * 0.6f); strength > 0.0f; strength -= f * 0.75f) {
                        int z;
                        int y;
                        int x = MathHelper.func_76128_c((double)dx);
                        Block block = this.field_77287_j.func_147439_a(x, y = MathHelper.func_76128_c((double)dy), z = MathHelper.func_76128_c((double)dz));
                        if (block != null) {
                            strength -= (block.getExplosionResistance(this.field_77283_e, this.field_77287_j, x, y, z, this.field_77284_b, this.field_77285_c, this.field_77282_d) + 0.3f) * f;
                        }
                        if (strength > 0.0f) {
                            set.add(new ChunkPosition(x, y, z));
                        }
                        dx += rx * (double)f;
                        dy += ry * (double)f;
                        dz += rz * (double)f;
                    }
                }
            }
        }
        this.field_77281_g.addAll(set);
        this.blocksCalculated = true;
    }
}

