/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.TagPropertyAccessor;
import mods.flammpfeil.slashblade.stats.AchievementList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class StylishRankManager {
    public static String[] rankText = new String[]{"D", "C", "B", "A", "S", "SS", "SSS"};
    public static int RankRange = 100;
    public static TagPropertyAccessor.TagPropertyIntegerWithRange RankPoint = new TagPropertyAccessor.TagPropertyIntegerWithRange("SBRankPoint", 0, rankText.length * RankRange);
    public static TagPropertyAccessor.TagPropertyLong LastRankPointUpdate = new TagPropertyAccessor.TagPropertyLong("SBLastRPUpdate");
    public static TagPropertyAccessor.TagPropertyString AttackType = new TagPropertyAccessor.TagPropertyString("LastAttackType");
    public static final int initCooltime = 20;
    public static final int addCooltime = 10;
    public static final int maxCooltime = 30;
    public static NBTTagCompound dummyTag = new NBTTagCompound();
    public static final String MessageHeader = "///RankUpdate ";
    public static final String MessageHurt = "///RankUpdateHurt";
    public static Set<String> ignoreDamageTypes = Sets.newHashSet((Object[])new String[]{"thrown"});

    private static String unescape(String source) {
        return source.replace("\"", "").replace("\\quot;", "\"").replace("\\r;", "\r").replace("\\n;", "\n").replace("\\\\", "\\");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StylishRankManager() {
        try {
            SlashBlade.mainConfiguration.load();
            Property propIgnoreDamageType = SlashBlade.mainConfiguration.get("general", "RankDownIgnoreDamageTypes", new String[0]);
            String[] strs = propIgnoreDamageType.getStringList();
            ArrayList tmp = Lists.newArrayList();
            for (String str : strs) {
                ignoreDamageTypes.add(StylishRankManager.unescape(str));
            }
        }
        finally {
            SlashBlade.mainConfiguration.save();
        }
    }

    public static NBTTagCompound getTag(Entity e) {
        if (e != null) {
            return e.getEntityData();
        }
        return dummyTag;
    }

    public static int getTotalRankPoint(Entity e) {
        long lastUpdate;
        NBTTagCompound tag = StylishRankManager.getTag(e);
        int rank = RankPoint.get(tag);
        long now = e.field_70170_p.func_82737_E();
        long descPoint = Math.max(0L, now - (lastUpdate = LastRankPointUpdate.get(tag).longValue()));
        rank = descPoint < (long)(RankRange * 2) ? (int)((long)rank - descPoint) : 0;
        rank = Math.max(0, rank);
        return rank;
    }

    public static float getCurrentProgress(Entity e) {
        int rank = StylishRankManager.getTotalRankPoint(e);
        return (float)(rank %= RankRange) / (float)RankRange;
    }

    public static int getStylishRank(Entity e) {
        return StylishRankManager.getStylishRank(StylishRankManager.getTotalRankPoint(e));
    }

    public static int getStylishRank(int totalRankPoint) {
        int rank = totalRankPoint;
        rank = (int)Math.ceil((float)rank / (float)RankRange);
        rank = Math.max(0, Math.min(rankText.length, rank));
        return rank;
    }

    public static String getRankText(Entity e) {
        return StylishRankManager.getRankText(StylishRankManager.getStylishRank(e));
    }

    public static String getRankText(int rank) {
        return rank <= 0 ? "" : rankText[Math.min(rank - 1, rankText.length - 1)];
    }

    public static void setNextAttackType(Entity e, String key) {
        NBTTagCompound tag = StylishRankManager.getTag(e);
        AttackType.set(tag, key);
    }

    public static void doAttack(Entity e) {
        if (e == null) {
            return;
        }
        NBTTagCompound tag = StylishRankManager.getTag(e);
        String attackType = AttackType.get(tag);
        StylishRankManager.addRankPoint(e, attackType);
    }

    public static void addRankPoint(Entity e, String attackType) {
        if (e == null) {
            return;
        }
        NBTTagCompound tag = StylishRankManager.getTag(e);
        int value = 0;
        if (AttackTypes.types.containsKey(attackType)) {
            value = (int)((float)RankRange * AttackTypes.types.get(attackType).floatValue());
        }
        if (value == 0) {
            return;
        }
        if (value < 0) {
            value = Math.abs(value);
        } else {
            long now;
            String timerKey = "SBAttackTime" + attackType;
            long last = tag.func_74763_f(timerKey);
            if (last < (now = e.field_70170_p.func_82737_E())) {
                tag.func_74772_a(timerKey, now + 20L);
            } else if (last - now < 20L) {
                value /= 2;
                tag.func_74772_a(timerKey, Math.min(now + 30L, last + 10L));
            } else {
                value = 1;
                tag.func_74772_a(timerKey, now + 30L);
            }
        }
        StylishRankManager.addRankPoint(e, value);
    }

    public static void addRankPoint(Entity e, int amount) {
        if (e == null) {
            return;
        }
        if (e.field_70170_p.field_72995_K) {
            return;
        }
        NBTTagCompound tag = StylishRankManager.getTag(e);
        int rankPoint = StylishRankManager.getTotalRankPoint(e);
        int lastRank = StylishRankManager.getStylishRank(rankPoint);
        RankPoint.set(tag, rankPoint += amount);
        LastRankPointUpdate.set(tag, e.field_70170_p.func_82737_E());
        int postRank = StylishRankManager.getStylishRank(rankPoint);
        if (lastRank < postRank && e instanceof EntityPlayer) {
            AchievementList.triggerAchievement((EntityPlayer)e, "rank" + StylishRankManager.getRankText(postRank));
        }
        StylishRankManager.onRiseInRank(e, postRank, rankPoint);
    }

    public static void onRiseInRank(Entity e, int rank, int rankPoint) {
        if (e == null) {
            return;
        }
        NBTTagCompound tag = StylishRankManager.getTag(e);
        if (e instanceof EntityPlayer) {
            ((EntityPlayer)e).func_145747_a((IChatComponent)new ChatComponentText(MessageHeader + rankPoint));
        }
    }

    public static void onHurtChangeRank(Entity e) {
        if (e == null) {
            return;
        }
        if (e instanceof EntityPlayer) {
            ((EntityPlayer)e).func_145747_a((IChatComponent)new ChatComponentText(MessageHurt));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void LivingHurtEvent(LivingHurtEvent e) {
        EntityLivingBase attacker;
        String type = e.source.func_76355_l();
        if (e.isCanceled()) {
            return;
        }
        if (e.entity == null) {
            return;
        }
        if (!(e.entity instanceof EntityPlayer)) {
            return;
        }
        if (e.source.func_76363_c() && e.source.func_76346_g() != null) {
            return;
        }
        if (e.source.func_76346_g() != null && e.source.func_76346_g() instanceof EntityLivingBase && (attacker = (EntityLivingBase)e.source.func_76346_g()).func_142015_aE() == attacker.field_70173_aa) {
            return;
        }
        if (ignoreDamageTypes.contains(type)) {
            return;
        }
        NBTTagCompound tag = StylishRankManager.getTag(e.entity);
        Long lastUpdate = LastRankPointUpdate.get(tag);
        LastRankPointUpdate.set(tag, lastUpdate - (long)(RankRange / 2));
        StylishRankManager.onHurtChangeRank(e.entity);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void ClientChatReceivedEvent(ClientChatReceivedEvent e) {
        String text = e.message.func_150260_c();
        if (text.startsWith(MessageHeader)) {
            int rankPoint;
            String value = text.substring(MessageHeader.length());
            try {
                rankPoint = Integer.parseInt(value);
            }
            catch (Exception ex) {
                rankPoint = 0;
            }
            EntityClientPlayerMP el = Minecraft.func_71410_x().field_71439_g;
            NBTTagCompound tag = StylishRankManager.getTag((Entity)el);
            RankPoint.set(tag, rankPoint);
            LastRankPointUpdate.set(tag, el.field_70170_p.func_82737_E());
            e.setCanceled(true);
        } else if (text.startsWith(MessageHurt)) {
            EntityClientPlayerMP el = Minecraft.func_71410_x().field_71439_g;
            NBTTagCompound tag = StylishRankManager.getTag((Entity)el);
            Long lastUpdate = LastRankPointUpdate.get(tag);
            LastRankPointUpdate.set(tag, lastUpdate - (long)(RankRange / 2));
            e.setCanceled(true);
        }
    }

    public static class AttackTypes {
        public static Map<String, Float> types = Maps.newHashMap();
        public static String None = AttackTypes.registerAttackType("None", 0.0f);
        public static String Saya1 = AttackTypes.registerAttackType("Saya1", 0.3f);
        public static String Saya2 = AttackTypes.registerAttackType("Saya2", 0.3f);
        public static String Battou = AttackTypes.registerAttackType("Battou", 0.5f);
        public static String IaiBattou = AttackTypes.registerAttackType("IaiBattou", -0.5f);
        public static String Kiriage = AttackTypes.registerAttackType("Kiriage", 0.3f);
        public static String Kiriorosi = AttackTypes.registerAttackType("Kiriorosi", 0.4f);
        public static String Iai = AttackTypes.registerAttackType("Iai", 0.3f);
        public static String JumpBattou = AttackTypes.registerAttackType("JumpBattou", 0.4f);
        public static String SlashDim = AttackTypes.registerAttackType("SlashDim", 0.6f);
        public static String SlashDimMagic = AttackTypes.registerAttackType("SlashDimMagic", -0.1f);
        public static String Drive = AttackTypes.registerAttackType("Drive", 0.5f);
        public static String Spear = AttackTypes.registerAttackType("Spear", -0.2f);
        public static String CircleSlash = AttackTypes.registerAttackType("CircleSlash", 0.3f);
        public static String QuickDrive = AttackTypes.registerAttackType("QuickDrive", 0.2f);
        public static String PhantomSword = AttackTypes.registerAttackType("PhantomSword", 0.2f);
        public static String BreakPhantomSword = AttackTypes.registerAttackType("BreakPhantomSword", 0.1f);
        public static String JustGuard = AttackTypes.registerAttackType("JustGuard", 1.0f);
        public static String Noutou = AttackTypes.registerAttackType("Noutou", -1.5f);
        public static String DestructObject = AttackTypes.registerAttackType("DestructObject", -0.1f);
        public static String AttackAvoidance = AttackTypes.registerAttackType("AttackAvoidance", -0.3f);

        public static String registerAttackType(String key, float factor) {
            types.put(key, Float.valueOf(factor));
            return key;
        }
    }
}

