/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.IThrowableEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mods.flammpfeil.slashblade.ConfigEntityListManager;
import mods.flammpfeil.slashblade.EntityDrive;
import mods.flammpfeil.slashblade.InitProxy;
import mods.flammpfeil.slashblade.ItemSlashBladeNamed;
import mods.flammpfeil.slashblade.ItemSlashBladeWrapper;
import mods.flammpfeil.slashblade.MessageRangeAttack;
import mods.flammpfeil.slashblade.PacketHandler;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.TagPropertyAccessor;
import mods.flammpfeil.slashblade.ability.JustGuard;
import mods.flammpfeil.slashblade.ability.StylishRankManager;
import mods.flammpfeil.slashblade.entity.EntityBladeStand;
import mods.flammpfeil.slashblade.entity.EntityPhantomSwordBase;
import mods.flammpfeil.slashblade.specialattack.CircleSlash;
import mods.flammpfeil.slashblade.specialattack.Drive;
import mods.flammpfeil.slashblade.specialattack.SlashDimension;
import mods.flammpfeil.slashblade.specialattack.Spear;
import mods.flammpfeil.slashblade.specialattack.SpecialAttackBase;
import mods.flammpfeil.slashblade.specialattack.WaveEdge;
import mods.flammpfeil.slashblade.stats.AchievementList;
import mods.flammpfeil.slashblade.util.EnchantHelper;
import mods.flammpfeil.slashblade.util.InventoryUtility;
import mods.flammpfeil.slashblade.util.SlashBladeHooks;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.IEntitySelector;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemSlashBlade
extends ItemSword {
    public static IEntitySelector AttackableSelector = new EntitySelectorAttackable();
    public static IEntitySelector DestructableSelector = new EntitySelectorDestructable();
    private static ResourceLocation texture = new ResourceLocation("flammpfeil.slashblade", "model/blade.png");
    public static Map<String, ResourceLocation> textureMap = new HashMap<String, ResourceLocation>();
    public static TagPropertyAccessor.TagPropertyString TextureName = new TagPropertyAccessor.TagPropertyString("TextureName");
    private ResourceLocation model = new ResourceLocation("flammpfeil.slashblade", "model/blade.obj");
    public static Map<String, ResourceLocation> modelMap = new HashMap<String, ResourceLocation>();
    public static TagPropertyAccessor.TagPropertyString ModelName = new TagPropertyAccessor.TagPropertyString("ModelName");
    public static final String adjustXStr = "adjustX";
    public static final String adjustYStr = "adjustY";
    public static final String adjustZStr = "adjustZ";
    public static final String comboSeqStr = "comboSeq";
    public static final String lastPosHashStr = "lastPosHash";
    public static final float RefineBase = 10.0f;
    public static TagPropertyAccessor.TagPropertyLong LastActionTime = new TagPropertyAccessor.TagPropertyLong("lastActionTime");
    public static TagPropertyAccessor.TagPropertyInteger SpecialAttackType = new TagPropertyAccessor.TagPropertyInteger("SpecialAttackType");
    public static TagPropertyAccessor.TagPropertyInteger StandbyRenderType = new TagPropertyAccessor.TagPropertyInteger("StandbyRenderType");
    public static TagPropertyAccessor.TagPropertyInteger TargetEntityId = new TagPropertyAccessor.TagPropertyInteger("TargetEntity");
    public static TagPropertyAccessor.TagPropertyBoolean IsBroken = new TagPropertyAccessor.TagPropertyBoolean("isBroken");
    public static TagPropertyAccessor.TagPropertyBoolean OnClick = new TagPropertyAccessor.TagPropertyBoolean("onClick");
    public static TagPropertyAccessor.TagPropertyBoolean OnJumpAttacked = new TagPropertyAccessor.TagPropertyBoolean("onJumpAttacked");
    public static TagPropertyAccessor.TagPropertyBoolean IsNoScabbard = new TagPropertyAccessor.TagPropertyBoolean("isNoScabbard");
    public static TagPropertyAccessor.TagPropertyBoolean IsSealed = new TagPropertyAccessor.TagPropertyBoolean("isSealed");
    public static TagPropertyAccessor.TagPropertyBoolean IsCharged = new TagPropertyAccessor.TagPropertyBoolean("isCharged");
    public static TagPropertyAccessor.TagPropertyBoolean IsDestructable = new TagPropertyAccessor.TagPropertyBoolean("isDestructable");
    public static TagPropertyAccessor.TagPropertyFloat AttackAmplifier = new TagPropertyAccessor.TagPropertyFloat("AttackAmplifier");
    public static TagPropertyAccessor.TagPropertyFloat BaseAttackModifier = new TagPropertyAccessor.TagPropertyFloat("baseAttackModifier");
    public static TagPropertyAccessor.TagPropertyInteger PrevExp = new TagPropertyAccessor.TagPropertyInteger("prevExp");
    public static TagPropertyAccessor.TagPropertyIntegerWithRange ProudSoul = new TagPropertyAccessor.TagPropertyIntegerWithRange("ProudSoul", 0, 999999999);
    public static TagPropertyAccessor.TagPropertyIntegerWithRange KillCount = new TagPropertyAccessor.TagPropertyIntegerWithRange("killCount", 0, 999999999);
    public static TagPropertyAccessor.TagPropertyIntegerWithRange RepairCount = new TagPropertyAccessor.TagPropertyIntegerWithRange("RepairCounter", 0, 999999999);
    public static int AnvilRepairBonus = 100;
    private static ArrayList<ComboSequence> Seqs = new ArrayList();
    public static int RequiredChargeTick = 15;
    public static int ComboInterval = 4;
    public float defaultBaseAttackModifier = 4.0f;
    private String[] repairMaterialOreDic = null;
    private ItemStack repairMaterial = null;
    public static Map<Integer, SpecialAttackBase> specialAttacks = ItemSlashBlade.createSpacialAttaksMap();
    public static SpecialAttackBase defaultSA;

    public ResourceLocation getModelTexture() {
        return texture;
    }

    public static ResourceLocation getModelTexture(ItemStack par1ItemStack) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(par1ItemStack);
        if (TextureName.exists(tag)) {
            ResourceLocation loc;
            String textureName = TextureName.get(tag);
            if (!textureMap.containsKey(textureName)) {
                loc = new ResourceLocation("flammpfeil.slashblade", "model/" + textureName + ".png");
                textureMap.put(textureName, loc);
            } else {
                loc = textureMap.get(textureName);
            }
            return loc;
        }
        return ((ItemSlashBlade)par1ItemStack.func_77973_b()).getModelTexture();
    }

    public ResourceLocation getModel() {
        return this.model;
    }

    public static ResourceLocation getModelLocation(ItemStack par1ItemStack) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(par1ItemStack);
        if (ModelName.exists(tag)) {
            ResourceLocation loc;
            String modelName = ModelName.get(tag);
            if (!modelMap.containsKey(modelName)) {
                loc = new ResourceLocation("flammpfeil.slashblade", "model/" + modelName + ".obj");
                modelMap.put(modelName, loc);
            } else {
                loc = modelMap.get(modelName);
            }
            return loc;
        }
        return ((ItemSlashBlade)par1ItemStack.func_77973_b()).getModel();
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.none;
    }

    public static void setComboSequence(NBTTagCompound tag, ComboSequence comboSeq) {
        tag.func_74768_a(comboSeqStr, comboSeq.ordinal());
        if (comboSeq == ComboSequence.None) {
            IsCharged.set(tag, false);
        }
    }

    public static ComboSequence getComboSequence(NBTTagCompound tag) {
        return ComboSequence.get(tag.func_74762_e(comboSeqStr));
    }

    public void dropItemDestructed(Entity entity, ItemStack stack) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        if (!entity.field_70170_p.field_72995_K) {
            int proudSouls = ProudSoul.get(tag);
            int count = 0;
            if (proudSouls > 1000) {
                count = (proudSouls - 800) / 100;
                count = Math.min(8, Math.max(0, count));
                proudSouls -= count * 100;
            } else {
                count = proudSouls / 100;
                proudSouls -= count * 100;
            }
            ProudSoul.set(tag, proudSouls);
            entity.func_70099_a(GameRegistry.findItemStack((String)"flammpfeil.slashblade", (String)"proudsoul", (int)(++count)), 0.0f);
            if (entity instanceof EntityPlayer) {
                AchievementList.triggerAchievement((EntityPlayer)entity, "proudSoul");
            }
            if (stack.func_77948_v() && entity instanceof EntityLivingBase) {
                int enchCount;
                ItemStack tinySoul = GameRegistry.findItemStack((String)"flammpfeil.slashblade", (String)"tiny_bladesoul", (int)1);
                int unbreakingLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)stack);
                Random rand = ((EntityLivingBase)entity).func_70681_au();
                boolean isRare = false;
                for (int loop = 0; loop < unbreakingLevel; ++loop) {
                    boolean bl = isRare = (double)rand.nextFloat() < 0.1;
                    if (isRare) break;
                }
                if (isRare) {
                    tinySoul.func_77966_a(EnchantHelper.getEnchantmentRare(rand), 1);
                } else {
                    tinySoul.func_77966_a(EnchantHelper.getEnchantmentNormal(rand), 1);
                }
                entity.func_70099_a(tinySoul, 0.0f);
                if (entity instanceof EntityPlayer) {
                    AchievementList.triggerAchievement((EntityPlayer)entity, "enchantmentSoul");
                }
                if (5 < (enchCount = stack.func_77986_q().func_74745_c())) {
                    if (0 < unbreakingLevel) {
                        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
                        if (unbreakingLevel == 1) {
                            enchantments.remove(Enchantment.field_77347_r.field_77352_x);
                        } else {
                            enchantments.put(Enchantment.field_77347_r.field_77352_x, unbreakingLevel - 1);
                        }
                        ItemStack rareTinySoul = GameRegistry.findItemStack((String)"flammpfeil.slashblade", (String)"tiny_bladesoul", (int)1);
                        rareTinySoul.func_77966_a(EnchantHelper.getEnchantmentRare(rand), 1);
                        entity.func_70099_a(rareTinySoul, 0.0f);
                        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
                    } else {
                        int targetTag = rand.nextInt(enchCount);
                        NBTTagCompound enchTag = stack.func_77986_q().func_150305_b(targetTag);
                        enchTag = (NBTTagCompound)enchTag.func_74737_b();
                        stack.func_77986_q().func_74744_a(targetTag);
                        ItemStack proudSoul = GameRegistry.findItemStack((String)"flammpfeil.slashblade", (String)"proudsoul", (int)1);
                        if (proudSoul.field_77990_d == null) {
                            proudSoul.func_77982_d(new NBTTagCompound());
                        }
                        if (!proudSoul.field_77990_d.func_150297_b("ench", 9)) {
                            proudSoul.field_77990_d.func_74782_a("ench", (NBTBase)new NBTTagList());
                        }
                        NBTTagList nbttaglist = proudSoul.field_77990_d.func_150295_c("ench", 10);
                        nbttaglist.func_74742_a((NBTBase)enchTag);
                        entity.func_70099_a(proudSoul, 0.0f);
                    }
                }
            }
        }
    }

    public EntityLivingBase setDaunting(EntityLivingBase entity) {
        if (!entity.field_70170_p.field_72995_K) {
            entity.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 10, 30, true));
            entity.field_70724_aR = 20;
        }
        return entity;
    }

    public static void updateKillCount(ItemStack stack, EntityLivingBase target, EntityLivingBase player) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        if (!target.func_70089_S() && target.field_70725_aQ == 0) {
            int count = KillCount.add(tag, 1);
            if (player instanceof EntityPlayer) {
                switch (count) {
                    case 100: {
                        AchievementList.triggerAchievement((EntityPlayer)player, "hundredKill");
                        break;
                    }
                    case 1000: {
                        AchievementList.triggerAchievement((EntityPlayer)player, "thousandKill");
                        break;
                    }
                }
            }
        }
    }

    public void setArmorDrop(ItemStack stack, EntityLivingBase entity) {
        int slots;
        if (!(entity instanceof EntityLiving)) {
            return;
        }
        if (!stack.func_77948_v()) {
            return;
        }
        int lv = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack);
        switch (lv) {
            case 0: {
                return;
            }
            case 1: {
                slots = 1;
                break;
            }
            default: {
                slots = 5;
            }
        }
        for (int i = 0; i < slots; ++i) {
            try {
                ((EntityLiving)entity).func_96120_a(i, 0.99f);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setImpactEffect(ItemStack stack, EntityLivingBase target, EntityLivingBase user, ComboSequence comboSec) {
        switch (comboSec) {
            case Kiriage: {
                target.field_70122_E = false;
                target.field_70159_w = 0.0;
                target.field_70181_x = 0.0;
                target.field_70179_y = 0.0;
                target.func_70024_g(0.0, 0.7, 0.0);
                this.setDaunting(target);
                break;
            }
            case Kiriorosi: {
                if (0.0 < target.field_70181_x) {
                    target.field_70181_x = 0.0;
                }
                target.field_70143_R += 4.0f;
                float knockbackFactor = 0.5f;
                target.func_70024_g((double)(-MathHelper.func_76126_a((float)(user.field_70177_z * (float)Math.PI / 180.0f)) * knockbackFactor * 0.5f), -0.2, (double)(MathHelper.func_76134_b((float)(user.field_70177_z * (float)Math.PI / 180.0f)) * knockbackFactor * 0.5f));
                target.field_70172_ad = 0;
                break;
            }
            case HiraTuki: {
                this.setDaunting(target);
            }
            case Battou: {
                float knockbackFactor = 0.0f;
                if (target instanceof EntityLivingBase) {
                    knockbackFactor = EnchantmentHelper.func_77507_b((EntityLivingBase)user, (EntityLivingBase)target);
                }
                if (!(0.0f < knockbackFactor)) {
                    knockbackFactor = 1.5f;
                }
                target.field_70159_w = 0.0;
                target.field_70181_x = 0.0;
                target.field_70179_y = 0.0;
                target.func_70024_g((double)(-MathHelper.func_76126_a((float)(user.field_70177_z * (float)Math.PI / 180.0f)) * knockbackFactor * 0.5f), 0.2, (double)(MathHelper.func_76134_b((float)(user.field_70177_z * (float)Math.PI / 180.0f)) * knockbackFactor * 0.5f));
                break;
            }
            case Iai: {
                target.field_70159_w = 0.0;
                target.field_70181_x = 0.0;
                target.field_70179_y = 0.0;
                target.func_70024_g(0.0, 0.3, 0.0);
                this.setDaunting(target);
                break;
            }
            case Saya1: 
            case Saya2: {
                target.field_70159_w = 0.0;
                target.field_70181_x = 0.0;
                target.field_70179_y = 0.0;
                this.setDaunting(target);
                this.setArmorDrop(stack, target);
                break;
            }
            case SlashDim: {
                int level = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)stack);
                if (0 < level) {
                    target.field_70159_w = 0.0;
                    target.field_70181_x = 0.0;
                    target.field_70179_y = 0.0;
                    target.func_70024_g((double)(MathHelper.func_76126_a((float)(user.field_70177_z * (float)Math.PI / 180.0f)) * (float)level * 0.5f), 0.2, (double)(-MathHelper.func_76134_b((float)(user.field_70177_z * (float)Math.PI / 180.0f)) * (float)level * 0.5f));
                }
                this.setDaunting(target);
                break;
            }
        }
    }

    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(par1ItemStack);
        ItemSlashBlade.updateKillCount(par1ItemStack, par2EntityLivingBase, par3EntityLivingBase);
        ComboSequence comboSec = ItemSlashBlade.getComboSequence(tag);
        this.setImpactEffect(par1ItemStack, par2EntityLivingBase, par3EntityLivingBase, comboSec);
        if (!comboSec.useScabbard || IsNoScabbard.get(tag).booleanValue()) {
            par1ItemStack.func_77972_a(1, par3EntityLivingBase);
        }
        StylishRankManager.doAttack((Entity)par3EntityLivingBase);
        return true;
    }

    public boolean func_150894_a(ItemStack par1ItemStack, World par2World, Block par3, int par4, int par5, int par6, EntityLivingBase par7EntityLivingBase) {
        if ((double)par3.func_149712_f(par2World, par4, par5, par6) != 0.0) {
            par1ItemStack.func_77972_a(1, par7EntityLivingBase);
        }
        return true;
    }

    public Multimap func_111205_h() {
        Multimap multimap = super.func_111205_h();
        multimap.removeAll((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.defaultBaseAttackModifier, 0));
        return multimap;
    }

    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("flammpfeil.slashblade:proudsoul");
    }

    public ItemSlashBlade(Item.ToolMaterial par2EnumToolMaterial, float defaultBaseAttackModifier) {
        super(par2EnumToolMaterial);
        this.func_77656_e(50);
        this.defaultBaseAttackModifier = defaultBaseAttackModifier;
    }

    public static NBTTagCompound getItemTagCompound(ItemStack stack) {
        NBTTagCompound tag;
        if (stack.func_77942_o()) {
            tag = stack.func_77978_p();
        } else {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        return tag;
    }

    public ComboSequence getNextComboSeq(ItemStack itemStack, ComboSequence current, boolean isRightClick, EntityPlayer player) {
        ComboSequence result = ComboSequence.None;
        EnumSet<SwordType> types = this.getSwordType(itemStack);
        if (types.contains((Object)SwordType.NoScabbard)) {
            result = ComboSequence.None;
        } else if (!player.field_70122_E) {
            switch (current) {
                case Iai: {
                    result = ComboSequence.Battou;
                    break;
                }
                default: {
                    result = ComboSequence.Iai;
                    break;
                }
            }
        } else if (isRightClick) {
            switch (current) {
                case Saya1: {
                    result = ComboSequence.Saya2;
                    break;
                }
                case Saya2: {
                    result = ComboSequence.Battou;
                    break;
                }
                case Kiriage: {
                    result = ComboSequence.Kiriorosi;
                    break;
                }
                default: {
                    result = ComboSequence.Saya1;
                    break;
                }
            }
        } else {
            switch (current) {
                case Kiriage: {
                    result = ComboSequence.Kiriorosi;
                    break;
                }
                default: {
                    result = ComboSequence.Kiriage;
                }
            }
        }
        return result;
    }

    public void setPlayerEffect(ItemStack itemStack, ComboSequence current, EntityPlayer player) {
        EnumSet<SwordType> swordType = this.getSwordType(itemStack);
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(itemStack);
        switch (current) {
            case Iai: {
                player.field_70143_R = 0.0f;
                if (player.field_70122_E || OnJumpAttacked.get(tag).booleanValue()) break;
                player.field_70181_x = 0.0;
                player.func_70024_g(0.0, 0.3, 0.0);
                int level = 1 + EnchantmentHelper.func_77506_a((int)Enchantment.field_77330_e.field_77352_x, (ItemStack)itemStack);
                player.field_70143_R = (float)((double)player.field_70143_R * Math.max(0.0, (4.5 - (double)level) / 5.0));
                break;
            }
            case Battou: {
                if (!player.field_70122_E && !OnJumpAttacked.get(tag).booleanValue()) {
                    player.field_70181_x = 0.0;
                    player.func_70024_g(0.0, 0.2, 0.0);
                    OnJumpAttacked.set(tag, true);
                    int level = 1 + EnchantmentHelper.func_77506_a((int)Enchantment.field_77330_e.field_77352_x, (ItemStack)itemStack);
                    player.field_70143_R = (float)((double)player.field_70143_R * Math.max(0.0, (4.5 - (double)level) / 5.0));
                }
                if (!swordType.containsAll(SwordType.BewitchedPerfect)) break;
                Random rand = player.func_70681_au();
                for (int spread = 0; spread < 12; ++spread) {
                    float xSp = rand.nextFloat() * 2.0f - 1.0f;
                    float zSp = rand.nextFloat() * 2.0f - 1.0f;
                    xSp = (float)((double)xSp + 0.2 * (double)Math.signum(xSp));
                    zSp = (float)((double)zSp + 0.2 * (double)Math.signum(zSp));
                    player.field_70170_p.func_72869_a("largeexplode", player.field_70165_t + (double)(3.0f * xSp), player.field_70163_u, player.field_70161_v + (double)(3.0f * zSp), 1.0, 1.0, 1.0);
                }
                break;
            }
        }
        if (!current.useScabbard && IsCharged.get(tag).booleanValue()) {
            IsCharged.set(tag, false);
            int rank = StylishRankManager.getStylishRank((Entity)player);
            if (4 <= rank && !IsBroken.get(tag).booleanValue() && swordType.contains((Object)SwordType.Bewitched) && player instanceof EntityPlayer) {
                this.doAddAttack(itemStack, player, current);
            }
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        if (!OnClick.get(tag).booleanValue() && entity.func_70075_an() && (!entity.func_85031_j((Entity)player) || entity instanceof EntityLivingBase)) {
            if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).field_70738_aO != 0 && ComboInterval + 2 > ((EntityLivingBase)entity).field_70738_aO - ((EntityLivingBase)entity).field_70737_aN) {
                player.field_110158_av = 0;
                player.field_70733_aJ = 0.0f;
                player.field_82175_bq = false;
                return true;
            }
            ComboSequence comboSec = ItemSlashBlade.getComboSequence(tag);
            comboSec = this.getNextComboSeq(stack, comboSec, false, player);
            this.setPlayerEffect(stack, comboSec, player);
            ItemSlashBlade.setComboSequence(tag, comboSec);
            LastActionTime.set(tag, player.field_70170_p.func_82737_E());
            this.updateStyleAttackType(stack, (EntityLivingBase)player);
        }
        entity.field_70172_ad = 0;
        return false;
    }

    public ItemStack func_77659_a(ItemStack sitem, World par2World, EntityPlayer par3EntityPlayer) {
        JustGuard.setJustGuardState((EntityLivingBase)par3EntityPlayer);
        return super.func_77659_a(sitem, par2World, par3EntityPlayer);
    }

    public void doAddAttack(ItemStack stack, EntityPlayer player, ComboSequence setCombo) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            EntityDrive entityDrive;
            int cost = -10;
            if (!ProudSoul.tryAdd(tag, -10, false)) {
                stack.func_77972_a(5, (EntityLivingBase)player);
            }
            float baseModif = this.getBaseAttackModifiers(tag);
            int level = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack);
            float magicDamage = baseModif;
            int rank = StylishRankManager.getStylishRank((Entity)player);
            if (5 <= rank) {
                magicDamage += AttackAmplifier.get(tag).floatValue() * (0.5f + (float)level / 5.0f);
            }
            if ((entityDrive = new EntityDrive(world, (EntityLivingBase)player, magicDamage, false, 90.0f - setCombo.swingDirection)) != null) {
                entityDrive.setInitialSpeed(0.75f);
                entityDrive.setLifeTime(20);
                world.func_72838_d((Entity)entityDrive);
            }
            ItemSlashBlade.setComboSequence(tag, setCombo);
            return;
        }
    }

    public void doChargeAttack(ItemStack stack, EntityPlayer par3EntityPlayer) {
        AchievementList.triggerAchievement(par3EntityPlayer, "enchanted");
        this.getSpecialAttack(stack).doSpacialAttack(stack, par3EntityPlayer);
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        IsCharged.set(tag, true);
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        EnumSet<SwordType> swordType = this.getSwordType(stack);
        int charge = this.func_77626_a(stack) - count;
        if (RequiredChargeTick == charge && swordType.contains((Object)SwordType.Enchanted) && !swordType.contains((Object)SwordType.Broken)) {
            player.func_71009_b((Entity)player);
        }
    }

    public void func_77615_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer, int par4) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(par1ItemStack);
        int var6 = this.func_77626_a(par1ItemStack) - par4;
        EnumSet<SwordType> swordType = this.getSwordType(par1ItemStack);
        if (RequiredChargeTick < var6 && swordType.contains((Object)SwordType.Enchanted) && !swordType.contains((Object)SwordType.Broken)) {
            this.doSwingItem(par1ItemStack, par3EntityPlayer);
            this.doChargeAttack(par1ItemStack, par3EntityPlayer);
            LastActionTime.set(tag, par3EntityPlayer.field_70170_p.func_82737_E());
        } else if (!JustGuard.atJustGuard((EntityLivingBase)par3EntityPlayer)) {
            OnClick.set(tag, true);
            par3EntityPlayer.field_70181_x = 0.0;
        }
    }

    public NBTTagCompound getAttrTag(String attrName, AttributeModifier par0AttributeModifier) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74778_a("AttributeName", attrName);
        nbttagcompound.func_74778_a("Name", par0AttributeModifier.func_111166_b());
        nbttagcompound.func_74780_a("Amount", par0AttributeModifier.func_111164_d());
        nbttagcompound.func_74768_a("Operation", par0AttributeModifier.func_111169_c());
        nbttagcompound.func_74772_a("UUIDMost", par0AttributeModifier.func_111167_a().getMostSignificantBits());
        nbttagcompound.func_74772_a("UUIDLeast", par0AttributeModifier.func_111167_a().getLeastSignificantBits());
        return nbttagcompound;
    }

    public AxisAlignedBB getBBofCombo(ItemStack itemStack, ComboSequence combo, EntityLivingBase user) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(itemStack);
        EnumSet<SwordType> swordType = this.getSwordType(itemStack);
        AxisAlignedBB bb = user.field_70121_D.func_72329_c();
        Vec3 vec = user.func_70040_Z();
        vec.field_72448_b = 0.0;
        vec = vec.func_72432_b();
        switch (combo) {
            case Battou: {
                if (swordType.contains((Object)SwordType.Broken)) {
                    bb = bb.func_72314_b(1.0, 0.0, 1.0);
                    bb = bb.func_72317_d(vec.field_72450_a * 1.0, 0.0, vec.field_72449_c * 1.0);
                    break;
                }
                if (swordType.containsAll(SwordType.BewitchedPerfect)) {
                    bb = bb.func_72314_b(5.0, 0.25, 5.0);
                    break;
                }
                bb = bb.func_72314_b(2.0, 0.25, 2.0);
                bb = bb.func_72317_d(vec.field_72450_a * 2.5, 0.0, vec.field_72449_c * 2.5);
                break;
            }
            case Iai: {
                if (swordType.contains((Object)SwordType.Broken)) {
                    bb = bb.func_72314_b(1.0, 0.0, 1.0);
                    bb = bb.func_72317_d(vec.field_72450_a * 1.0, 0.0, vec.field_72449_c * 1.0);
                    break;
                }
                bb = bb.func_72314_b(2.0, 1.0, 2.0);
                bb = bb.func_72317_d(vec.field_72450_a * 2.5, 0.0, vec.field_72449_c * 2.5);
                break;
            }
            case Saya1: 
            case Saya2: {
                bb = bb.func_72314_b((double)1.2f, 0.25, (double)1.2f);
                bb = bb.func_72317_d(vec.field_72450_a * 2.0, 0.0, vec.field_72449_c * 2.0);
                break;
            }
            default: {
                if (swordType.contains((Object)SwordType.Broken)) {
                    bb = bb.func_72314_b(1.0, 0.0, 1.0);
                    bb = bb.func_72317_d(vec.field_72450_a * 1.0, 0.0, vec.field_72449_c * 1.0);
                    break;
                }
                bb = bb.func_72314_b((double)1.2f, 1.25, (double)1.2f);
                bb = bb.func_72317_d(vec.field_72450_a * 2.0, 0.5, vec.field_72449_c * 2.0);
            }
        }
        return bb;
    }

    public EnumSet<SwordType> getSwordType(ItemStack itemStack) {
        EnumSet<SwordType> result = EnumSet.noneOf(SwordType.class);
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(itemStack);
        if (IsSealed.get(tag).booleanValue()) {
            result.add(SwordType.Sealed);
        } else if (itemStack.func_77948_v()) {
            result.add(SwordType.Enchanted);
            if (itemStack.func_82837_s()) {
                result.add(SwordType.Bewitched);
            }
        }
        if (itemStack.func_77960_j() == 0 && !result.contains((Object)SwordType.Sealed)) {
            result.add(SwordType.Perfect);
        }
        if (IsBroken.get(tag).booleanValue()) {
            if (result.contains((Object)SwordType.Perfect)) {
                IsBroken.set(tag, false);
            } else {
                result.add(SwordType.Broken);
            }
        }
        if (1000 <= ProudSoul.get(tag)) {
            result.add(SwordType.SoulEeater);
        }
        if (1000 <= KillCount.get(tag)) {
            result.add(SwordType.FiercerEdge);
        }
        if (IsNoScabbard.get(tag).booleanValue()) {
            result.add(SwordType.NoScabbard);
        }
        return result;
    }

    public void updateAttackAmplifier(EnumSet<SwordType> swordType, NBTTagCompound tag, EntityPlayer el, ItemStack sitem) {
        float tagAttackAmplifier = AttackAmplifier.get(tag).floatValue();
        float baseModif = this.getBaseAttackModifiers(tag);
        float attackAmplifier = 0.0f;
        int rank = StylishRankManager.getStylishRank((Entity)el);
        if (rank < 3 || swordType.contains((Object)SwordType.Broken) || swordType.contains((Object)SwordType.Sealed)) {
            attackAmplifier = 2.0f - baseModif;
        } else if (rank == 7 || 5 <= rank && swordType.contains((Object)SwordType.FiercerEdge)) {
            float tmp = el.field_71068_ca;
            tmp = 1.0f + (tmp < 15.0f ? tmp * 0.5f : (tmp < 30.0f ? 3.0f + tmp * 0.45f : 7.0f + 0.4f * tmp));
            float max = 10.0f + (float)RepairCount.get(tag).intValue();
            attackAmplifier = Math.min(tmp, max);
        }
        if (tagAttackAmplifier != attackAmplifier) {
            AttackAmplifier.set(tag, Float.valueOf(attackAmplifier));
            NBTTagList attrTag = null;
            attrTag = new NBTTagList();
            tag.func_74782_a("AttributeModifiers", (NBTBase)attrTag);
            attrTag.func_74742_a((NBTBase)this.getAttrTag(SharedMonsterAttributes.field_111264_e.func_111108_a(), new AttributeModifier(field_111210_e, "Weapon modifier", (double)(attackAmplifier + baseModif), 0)));
            el.func_110140_aT().func_111148_a(sitem.func_111283_C());
            el.func_110140_aT().func_111147_b(sitem.func_111283_C());
        }
    }

    public void func_77663_a(ItemStack sitem, World par2World, Entity par3Entity, int indexOfMainSlot, boolean isCurrent) {
        int idx;
        if (SlashBladeHooks.onUpdateHooks(sitem, par2World, par3Entity, indexOfMainSlot, isCurrent)) {
            return;
        }
        if (!(par3Entity instanceof EntityPlayer)) {
            super.func_77663_a(sitem, par2World, par3Entity, indexOfMainSlot, isCurrent);
            return;
        }
        EntityPlayer el = (EntityPlayer)par3Entity;
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(sitem);
        int curDamage = sitem.func_77960_j();
        EnumSet<SwordType> swordType = this.getSwordType(sitem);
        this.updateAttackAmplifier(swordType, tag, el, sitem);
        int cost = sitem.func_82838_A();
        if (cost != 0) {
            Map map = EnchantmentHelper.func_82781_a((ItemStack)sitem);
            cost = map.size() + 1;
            ProudSoul.add(tag, cost *= AnvilRepairBonus);
            RepairCount.add(tag, 1);
            sitem.func_82841_c(0);
        }
        if (!par2World.field_72995_K && !isCurrent && PrevExp.exists(tag)) {
            PrevExp.remove(tag);
        }
        if (!par2World.field_72995_K && isCurrent && par2World.func_82737_E() % 20L == 0L) {
            int nowExp = el.field_71067_cb;
            int increasedExp = 0;
            if (PrevExp.exists(tag)) {
                int prevExp = PrevExp.get(tag);
                increasedExp = nowExp - prevExp;
            }
            PrevExp.set(tag, nowExp);
            if (0 < increasedExp) {
                if (0 < curDamage && swordType.containsAll(SwordType.BewitchedSoulEater) && !swordType.contains((Object)SwordType.NoScabbard)) {
                    int repairAmount = Math.max(1, (int)((double)increasedExp / 10.0));
                    increasedExp -= repairAmount;
                    sitem.func_77964_b(Math.max(0, curDamage - repairAmount));
                    if (sitem.func_77960_j() == 0) {
                        AchievementList.triggerAchievement(el, "soulEater");
                    }
                }
                ProudSoul.add(tag, increasedExp);
            }
        }
        if (!isCurrent && !par2World.field_72995_K && swordType.contains((Object)SwordType.Bewitched) && !swordType.contains((Object)SwordType.NoScabbard) && 0 < curDamage && par2World.func_82737_E() % 20L == 0L && 0 <= (idx = Arrays.asList(el.field_71071_by.field_70462_a).indexOf(sitem)) && idx < 9 && 0 < el.field_71068_ca) {
            int repair;
            int descExp = 0;
            int descLv = 0;
            int addProudSoul = 0;
            if (swordType.contains((Object)SwordType.Broken)) {
                repair = Math.max(1, (int)((double)sitem.func_77958_k() / 10.0));
                ItemStack tinySoul = GameRegistry.findItemStack((String)"flammpfeil.slashblade", (String)"tiny_bladesoul", (int)1);
                addProudSoul = 20;
                if (!InventoryUtility.consumeInventoryItem((IInventory)el.field_71071_by, tinySoul, false)) {
                    descLv = 1;
                }
            } else {
                repair = 1;
                descExp = 10;
                addProudSoul = 10;
            }
            if (0 < curDamage) {
                el.func_71020_j(0.025f);
                sitem.func_77964_b(Math.max(0, curDamage - repair));
            }
            ProudSoul.add(tag, addProudSoul);
            if (0 < descExp) {
                while (descExp > 0) {
                    el.func_71023_q(-1);
                    if (el.field_71106_cc < 0.0f) {
                        if (el.field_71068_ca <= 0) {
                            el.field_71106_cc = 0.0f;
                        } else {
                            --el.field_71068_ca;
                            el.field_71106_cc = 1.0f - 0.9f / (float)el.func_71050_bK();
                        }
                    }
                    --descExp;
                }
            }
            if (0 < descLv) {
                while (descLv > 0) {
                    if (0 < el.field_71068_ca) {
                        --el.field_71068_ca;
                        el.func_71023_q(-1);
                    }
                    --descLv;
                }
            }
        }
        if (el.field_70122_E && !el.field_70160_al && OnJumpAttacked.get(tag).booleanValue()) {
            ItemSlashBlade.setComboSequence(tag, ComboSequence.None);
        }
        if (el.field_70122_E && OnJumpAttacked.get(tag).booleanValue()) {
            OnJumpAttacked.set(tag, false);
        }
        ComboSequence comboSeq = ItemSlashBlade.getComboSequence(tag);
        long prevAttackTime = LastActionTime.get(tag);
        long currentTime = el.field_70170_p.func_82737_E();
        if (currentTime + 1000L < prevAttackTime) {
            prevAttackTime = 0L;
            LastActionTime.set(tag, 0L);
        }
        if (isCurrent) {
            AxisAlignedBB bb;
            if (OnClick.get(tag).booleanValue()) {
                if (prevAttackTime + (long)ComboInterval < currentTime) {
                    comboSeq = this.getNextComboSeq(sitem, comboSeq, true, el);
                    this.setPlayerEffect(sitem, comboSeq, el);
                    ItemSlashBlade.setComboSequence(tag, comboSeq);
                    this.doSwingItem(sitem, el);
                    this.updateStyleAttackType(sitem, (EntityLivingBase)el);
                    bb = this.getBBofCombo(sitem, comboSeq, (EntityLivingBase)el);
                    int rank = StylishRankManager.getStylishRank((Entity)el);
                    List list = par2World.func_94576_a((Entity)el, bb, AttackableSelector);
                    block11: for (Entity curEntity : list) {
                        switch (comboSeq) {
                            case Saya1: 
                            case Saya2: {
                                float attack = 4.0f;
                                if (rank < 3 || swordType.contains((Object)SwordType.Broken)) {
                                    attack = 2.0f;
                                } else {
                                    attack += Item.ToolMaterial.STONE.func_78000_c();
                                    if (swordType.contains((Object)SwordType.FiercerEdge) && el instanceof EntityPlayer) {
                                        attack += AttackAmplifier.get(tag).floatValue() * 0.5f;
                                    }
                                }
                                if (curEntity instanceof EntityLivingBase) {
                                    float var4 = 0.0f;
                                    var4 = EnchantmentHelper.func_77512_a((EntityLivingBase)el, (EntityLivingBase)((EntityLiving)curEntity));
                                    if (var4 > 0.0f) {
                                        attack += var4;
                                    }
                                }
                                if (curEntity instanceof EntityLivingBase) {
                                    attack = Math.min(attack, ((EntityLivingBase)curEntity).func_110143_aJ() - 1.0f);
                                }
                                curEntity.field_70172_ad = 0;
                                curEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)el), attack);
                                if (!(curEntity instanceof EntityLivingBase)) continue block11;
                                this.func_77644_a(sitem, (EntityLivingBase)curEntity, (EntityLivingBase)el);
                                continue block11;
                            }
                            case None: {
                                continue block11;
                            }
                        }
                        el.func_71059_n(curEntity);
                        el.func_71009_b(curEntity);
                    }
                    OnClick.set(tag, false);
                    LastActionTime.set(tag, currentTime);
                    if (swordType.containsAll(SwordType.BewitchedPerfect) && comboSeq.equals((Object)ComboSequence.Battou)) {
                        sitem.func_77972_a(10, (EntityLivingBase)el);
                    }
                }
            } else {
                if (!(comboSeq == ComboSequence.None || prevAttackTime + (long)(comboSeq.comboResetTicks - (el.field_70170_p.field_72995_K ? 1 : 0)) >= currentTime || !comboSeq.useScabbard && el.field_82175_bq || el.func_71039_bw())) {
                    switch (comboSeq) {
                        case None: {
                            break;
                        }
                        case Noutou: {
                            if (tag.func_74762_e(lastPosHashStr) == (int)((el.field_70165_t + el.field_70163_u + el.field_70161_v) * 10.0)) {
                                bb = el.field_70121_D.func_72329_c();
                                List list = par2World.func_94576_a((Entity)el, bb = bb.func_72314_b(10.0, 5.0, 10.0), AttackableSelector);
                                if (0 < list.size()) {
                                    StylishRankManager.addRankPoint((Entity)el, StylishRankManager.AttackTypes.Noutou);
                                    el.func_71009_b((Entity)el);
                                }
                            }
                        }
                        case Iai: 
                        case SlashDim: {
                            StylishRankManager.setNextAttackType((Entity)el, StylishRankManager.AttackTypes.None);
                            ItemSlashBlade.setComboSequence(tag, ComboSequence.None);
                            break;
                        }
                        default: {
                            if (comboSeq.useScabbard) {
                                StylishRankManager.setNextAttackType((Entity)el, StylishRankManager.AttackTypes.None);
                                ItemSlashBlade.setComboSequence(tag, ComboSequence.None);
                                break;
                            }
                            tag.func_74768_a(lastPosHashStr, (int)((el.field_70165_t + el.field_70163_u + el.field_70161_v) * 10.0));
                            LastActionTime.set(tag, currentTime);
                            ItemSlashBlade.setComboSequence(tag, ComboSequence.Noutou);
                            this.doSwingItem(sitem, el);
                        }
                    }
                }
                if (!comboSeq.equals((Object)ComboSequence.None) && el.field_110158_av != 0 && currentTime < prevAttackTime + (long)comboSeq.comboResetTicks) {
                    this.DestructEntity((EntityLivingBase)el, sitem);
                }
            }
            if (swordType.contains((Object)SwordType.Bewitched)) {
                bb = el.field_70121_D.func_72329_c();
                bb = bb.func_72314_b(2.0, 1.5, 2.0);
                List list = par2World.func_94576_a((Entity)el, bb, AttackableSelector);
                if (0 < list.size() && el.field_70160_al) {
                    Entity target = null;
                    float distance = 10.0f;
                    for (Entity curEntity : list) {
                        float curDist = curEntity.func_70032_d((Entity)el);
                        if (!(curDist < distance)) continue;
                        target = curEntity;
                        distance = curDist;
                    }
                    if (target != null) {
                        el.field_70122_E = true;
                        el.func_70637_d(false);
                    }
                }
            }
        } else if (!comboSeq.equals((Object)ComboSequence.None) && prevAttackTime + (long)comboSeq.comboResetTicks < currentTime) {
            StylishRankManager.setNextAttackType((Entity)el, StylishRankManager.AttackTypes.None);
            ItemSlashBlade.setComboSequence(tag, ComboSequence.None);
        }
        if (sitem.equals(el.func_70694_bm())) {
            if (!el.field_70170_p.field_72995_K) {
                int eId = TargetEntityId.get(tag);
                if (el.func_70093_af()) {
                    Entity target;
                    if (eId == 0) {
                        Entity rayEntity = this.getRayTrace((EntityLivingBase)el, 10.0);
                        if (rayEntity == null || !AttackableSelector.func_82704_a(rayEntity)) {
                            // empty if block
                        }
                        if (rayEntity != null) {
                            eId = rayEntity.func_145782_y();
                        } else {
                            AxisAlignedBB bb = el.field_70121_D.func_72329_c();
                            bb = bb.func_72314_b(10.0, 5.0, 10.0);
                            float distance = 20.0f;
                            List list = par2World.func_94576_a((Entity)el, bb, AttackableSelector);
                            for (Entity curEntity : list) {
                                float curDist = curEntity.func_70032_d((Entity)el);
                                if (!(curDist < distance)) continue;
                                eId = curEntity.func_145782_y();
                                distance = curDist;
                            }
                        }
                        TargetEntityId.set(tag, eId);
                    } else if (3 <= EnchantmentHelper.func_77506_a((int)Enchantment.field_92091_k.field_77352_x, (ItemStack)sitem) && (target = par2World.func_73045_a(eId)) != null && target instanceof EntityWither && 10.0f > el.func_70032_d(target) && (double)(((EntityWither)target).func_110143_aJ() / ((EntityWither)target).func_110138_aP()) > 0.5) {
                        Vec3 vec = el.func_70040_Z();
                        double y = -vec.field_72448_b * 2.0;
                        if (target.field_70163_u <= el.field_70163_u + 5.0) {
                            y = 0.0;
                        }
                        target.func_70024_g(vec.field_72450_a, y, vec.field_72449_c);
                    }
                } else if (eId != 0) {
                    TargetEntityId.set(tag, 0);
                }
            } else {
                Entity target;
                int eId = TargetEntityId.get(tag);
                if (eId != 0 && (target = par2World.func_73045_a(eId)) != null) {
                    this.faceEntity((EntityLivingBase)el, target, 1000.0f, 1000.0f);
                }
            }
        }
    }

    private void updateStyleAttackType(ItemStack stack, EntityLivingBase e) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        ComboSequence combo = ItemSlashBlade.getComboSequence(tag);
        switch (combo) {
            case Kiriage: {
                StylishRankManager.setNextAttackType((Entity)e, StylishRankManager.AttackTypes.Kiriage);
                break;
            }
            case Kiriorosi: {
                StylishRankManager.setNextAttackType((Entity)e, StylishRankManager.AttackTypes.Kiriorosi);
                break;
            }
            case Iai: {
                StylishRankManager.setNextAttackType((Entity)e, StylishRankManager.AttackTypes.Iai);
                break;
            }
            case Battou: {
                EnumSet<SwordType> swordType = this.getSwordType(stack);
                if (swordType.containsAll(SwordType.BewitchedPerfect)) {
                    if (e instanceof EntityPlayer) {
                        AchievementList.triggerAchievement((EntityPlayer)e, "bewitched");
                    }
                    StylishRankManager.setNextAttackType((Entity)e, StylishRankManager.AttackTypes.IaiBattou);
                    break;
                }
                if (e.field_70122_E) {
                    StylishRankManager.setNextAttackType((Entity)e, StylishRankManager.AttackTypes.Battou);
                    break;
                }
                StylishRankManager.setNextAttackType((Entity)e, StylishRankManager.AttackTypes.JumpBattou);
                break;
            }
            case Saya1: {
                StylishRankManager.setNextAttackType((Entity)e, StylishRankManager.AttackTypes.Saya1);
                break;
            }
            case Saya2: {
                StylishRankManager.setNextAttackType((Entity)e, StylishRankManager.AttackTypes.Saya2);
                break;
            }
            case HiraTuki: {
                StylishRankManager.setNextAttackType((Entity)e, StylishRankManager.AttackTypes.Kiriage);
            }
        }
    }

    protected void dropXpOnBlockBreak(World par1World, int par2, int par3, int par4, int par5) {
        if (!par1World.field_72995_K) {
            while (par5 > 0) {
                int i1 = EntityXPOrb.func_70527_a((int)par5);
                par5 -= i1;
                par1World.func_72838_d((Entity)new EntityXPOrb(par1World, (double)par2 + 0.5, (double)par3 + 0.5, (double)par4 + 0.5, i1));
            }
        }
    }

    public void faceEntity(EntityLivingBase owner, Entity par1Entity, float par2, float par3) {
        double d2;
        double d0 = par1Entity.field_70165_t - owner.field_70165_t;
        double d1 = par1Entity.field_70161_v - owner.field_70161_v;
        if (par1Entity instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)par1Entity;
            d2 = entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() - (owner.field_70163_u + (double)owner.func_70047_e());
        } else {
            d2 = (par1Entity.field_70121_D.field_72338_b + par1Entity.field_70121_D.field_72337_e) / 2.0 - (owner.field_70163_u + (double)owner.func_70047_e());
        }
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        float f2 = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(d2, d3) * 180.0 / Math.PI));
        owner.field_70125_A = this.updateRotation(owner.field_70125_A, f3, par3);
        owner.field_70125_A = Math.min(Math.max(owner.field_70125_A, -30.0f), 60.0f);
        owner.field_70177_z = this.updateRotation(owner.field_70177_z, f2, par2);
    }

    private float updateRotation(float par1, float par2, float par3) {
        float f3 = MathHelper.func_76142_g((float)(par2 - par1));
        if (f3 > par3) {
            f3 = par3;
        }
        if (f3 < -par3) {
            f3 = -par3;
        }
        return par1 + f3;
    }

    public void addInformationSwordClass(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        EnumSet<SwordType> swordType = this.getSwordType(par1ItemStack);
        if (swordType.contains((Object)SwordType.Enchanted)) {
            if (swordType.contains((Object)SwordType.Bewitched)) {
                par3List.add(String.format("\u00a75%s", StatCollector.func_74838_a((String)"flammpfeil.swaepon.info.bewitched")));
            } else {
                par3List.add(String.format("\u00a73%s", StatCollector.func_74838_a((String)"flammpfeil.swaepon.info.magic")));
            }
        } else {
            par3List.add(String.format("\u00a78%s", StatCollector.func_74838_a((String)"flammpfeil.swaepon.info.noname")));
        }
    }

    public void addInformationKillCount(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        EnumSet<SwordType> swordType = this.getSwordType(par1ItemStack);
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(par1ItemStack);
        par3List.add(String.format("%sKillCount : %d", swordType.contains((Object)SwordType.FiercerEdge) ? "\u00a74" : "", KillCount.get(tag)));
    }

    public void addInformationProudSoul(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        EnumSet<SwordType> swordType = this.getSwordType(par1ItemStack);
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(par1ItemStack);
        par3List.add(String.format("%sProudSoul : %d", swordType.contains((Object)SwordType.SoulEeater) ? "\u00a75" : "", ProudSoul.get(tag)));
    }

    public void addInformationSpecialAttack(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        EnumSet<SwordType> swordType = this.getSwordType(par1ItemStack);
        if (swordType.contains((Object)SwordType.Bewitched)) {
            NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(par1ItemStack);
            String key = "flammpfeil.slashblade.specialattack." + this.getSpecialAttack(par1ItemStack).toString();
            par3List.add(String.format("SA:%s", StatCollector.func_74838_a((String)key)));
        }
    }

    public void addInformationRepairCount(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(par1ItemStack);
        int repair = RepairCount.get(tag);
        if (0 < repair) {
            par3List.add(String.format("Refine : %d", repair));
        }
    }

    public void addInformationMaxAttack(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(par1ItemStack);
        float repair = RepairCount.get(tag).intValue();
        EnumSet<SwordType> swordType = this.getSwordType(par1ItemStack);
        if (swordType.contains((Object)SwordType.FiercerEdge)) {
            float baseModif = this.getBaseAttackModifiers(tag);
            par3List.add(String.format("\u00a74+%.1f Max Attack Damage", Float.valueOf(baseModif + 10.0f + repair)));
        }
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        this.addInformationSwordClass(par1ItemStack, par2EntityPlayer, par3List, par4);
        this.addInformationKillCount(par1ItemStack, par2EntityPlayer, par3List, par4);
        this.addInformationMaxAttack(par1ItemStack, par2EntityPlayer, par3List, par4);
        this.addInformationProudSoul(par1ItemStack, par2EntityPlayer, par3List, par4);
        this.addInformationSpecialAttack(par1ItemStack, par2EntityPlayer, par3List, par4);
        this.addInformationRepairCount(par1ItemStack, par2EntityPlayer, par3List, par4);
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(par1ItemStack);
        if (tag.func_74764_b(adjustXStr)) {
            float ax = tag.func_74760_g(adjustXStr);
            float ay = tag.func_74760_g(adjustYStr);
            float az = tag.func_74760_g(adjustZStr);
            par3List.add(String.format("adjust x:%.1f y:%.1f z:%.1f", Float.valueOf(ax), Float.valueOf(ay), Float.valueOf(az)));
        }
    }

    public Vec3 getEntityToEntityVec(Entity root, Entity target, float yawLimit, float pitchLimit) {
        double d2;
        double d0 = target.field_70165_t + target.field_70159_w - root.field_70165_t;
        double d1 = target.field_70161_v + target.field_70179_y - root.field_70161_v;
        if (target instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)target;
            d2 = entitylivingbase.field_70163_u + entitylivingbase.field_70181_x + (double)entitylivingbase.func_70047_e() - (root.field_70163_u + (double)root.func_70047_e());
        } else {
            d2 = (target.field_70121_D.field_72338_b + target.field_70121_D.field_72337_e) / 2.0 + target.field_70181_x - (root.field_70163_u + (double)root.func_70047_e());
        }
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        float f2 = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(d2, d3) * 180.0 / Math.PI));
        double yaw = Math.atan2(d1, d0) - 1.5707963267948966;
        double pitch = Math.atan2(d2, d3);
        double y = Math.sin(pitch);
        double x = -Math.sin(yaw);
        double z = Math.cos(yaw);
        return Vec3.func_72443_a((double)x, (double)y, (double)z).func_72432_b();
    }

    public void ReflectionProjecTile(Entity projecTile, EntityLivingBase player) {
        EntityLivingBase target = null;
        if (projecTile instanceof EntityFireball) {
            target = ((EntityFireball)projecTile).field_70235_a;
        } else if (projecTile instanceof EntityArrow) {
            target = ((EntityArrow)projecTile).field_70250_c;
        }
        if (target != null) {
            Vec3 vec = this.getEntityToEntityVec(projecTile, (Entity)target, 360.0f, 360.0f);
            this.InductionProjecTile(projecTile, player, vec);
        } else {
            Vec3 vec = Vec3.func_72443_a((double)(-projecTile.field_70159_w), (double)(-projecTile.field_70181_x), (double)(-projecTile.field_70179_y));
            vec = vec.func_72432_b();
            this.InductionProjecTile(projecTile, player, vec);
        }
    }

    public void InductionProjecTile(Entity projecTile, EntityLivingBase user) {
        this.InductionProjecTile(projecTile, user, user.func_70040_Z());
    }

    public void InductionProjecTile(Entity projecTile, EntityLivingBase user, Vec3 dir) {
        if (dir != null) {
            Vec3 vector = Vec3.func_72443_a((double)projecTile.field_70159_w, (double)projecTile.field_70181_x, (double)projecTile.field_70179_y);
            projecTile.field_70159_w = dir.field_72450_a;
            projecTile.field_70181_x = dir.field_72448_b;
            projecTile.field_70179_y = dir.field_72449_c;
            if (projecTile instanceof EntityFireball) {
                ((EntityFireball)projecTile).field_70232_b = projecTile.field_70159_w * 0.1;
                ((EntityFireball)projecTile).field_70233_c = projecTile.field_70181_x * 0.1;
                ((EntityFireball)projecTile).field_70230_d = projecTile.field_70179_y * 0.1;
            }
            if (projecTile instanceof EntityArrow) {
                ((EntityArrow)projecTile).func_70243_d(true);
            }
            projecTile.field_70159_w *= 1.5;
            projecTile.field_70181_x *= 1.5;
            projecTile.field_70179_y *= 1.5;
        }
        if (user != null) {
            if (projecTile instanceof EntityFireball) {
                ((EntityFireball)projecTile).field_70235_a = user;
            } else if (projecTile instanceof EntityArrow) {
                ((EntityArrow)projecTile).field_70250_c = user;
            } else if (projecTile instanceof IThrowableEntity) {
                ((IThrowableEntity)projecTile).setThrower((Entity)user);
            } else if (projecTile instanceof EntityThrowable && user instanceof EntityPlayer) {
                NBTTagCompound tag = new NBTTagCompound();
                ((EntityThrowable)projecTile).func_70014_b(tag);
                tag.func_74778_a("ownerName", ((EntityPlayer)user).func_70005_c_());
                ((EntityThrowable)projecTile).func_70037_a(tag);
            }
        }
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        EnumSet<SwordType> type = this.getSwordType(stack);
        double swordLen = 5.5;
        if (type.contains((Object)SwordType.Broken)) {
            swordLen = 2.8;
        }
        InitProxy.proxy.getMouseOver(swordLen);
        return false;
    }

    public void DestructEntity(EntityLivingBase entityLiving, ItemStack stack) {
        ComboSequence comboSeq = ItemSlashBlade.getComboSequence(ItemSlashBlade.getItemTagCompound(stack));
        if (!comboSeq.equals((Object)ComboSequence.None)) {
            int destructedCount = 0;
            AxisAlignedBB bb = this.getBBofCombo(stack, comboSeq, entityLiving);
            StylishRankManager.setNextAttackType((Entity)entityLiving, StylishRankManager.AttackTypes.DestructObject);
            List list = entityLiving.field_70170_p.func_94576_a((Entity)entityLiving, bb, DestructableSelector);
            for (Entity curEntity : list) {
                boolean isDestruction = true;
                EnumSet<SwordType> swordType = this.getSwordType(stack);
                if (curEntity instanceof EntityFireball) {
                    if (((EntityFireball)curEntity).field_70235_a != null && ((EntityFireball)curEntity).field_70235_a.func_145782_y() == entityLiving.func_145782_y()) {
                        isDestruction = false;
                    } else if (!swordType.contains((Object)SwordType.Bewitched)) {
                        boolean bl = isDestruction = !curEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)entityLiving), this.defaultBaseAttackModifier);
                    }
                    if (isDestruction && swordType.contains((Object)SwordType.Bewitched)) {
                        if (0 < EnchantmentHelper.func_77506_a((int)Enchantment.field_92091_k.field_77352_x, (ItemStack)stack)) {
                            this.ReflectionProjecTile(curEntity, entityLiving);
                        } else {
                            this.InductionProjecTile(curEntity, entityLiving);
                        }
                        isDestruction = false;
                    }
                } else if (curEntity instanceof EntityArrow) {
                    if (((EntityArrow)curEntity).field_70250_c != null && ((EntityArrow)curEntity).field_70250_c.func_145782_y() == entityLiving.func_145782_y()) {
                        isDestruction = false;
                    }
                    if (isDestruction && swordType.contains((Object)SwordType.Bewitched)) {
                        if (0 < EnchantmentHelper.func_77506_a((int)Enchantment.field_92091_k.field_77352_x, (ItemStack)stack)) {
                            this.ReflectionProjecTile(curEntity, entityLiving);
                        } else {
                            Entity tmp;
                            Entity target = null;
                            NBTTagCompound tag = stack.func_77978_p();
                            int eId = TargetEntityId.get(tag);
                            if (eId != 0 && (tmp = entityLiving.field_70170_p.func_73045_a(eId)) != null && tmp.func_70032_d((Entity)entityLiving) < 30.0f) {
                                target = tmp;
                            }
                            if (target != null && target instanceof EntityCreeper) {
                                this.InductionProjecTile(curEntity, null, entityLiving.func_70040_Z());
                            } else {
                                this.InductionProjecTile(curEntity, entityLiving);
                            }
                        }
                        isDestruction = false;
                    }
                } else if (curEntity instanceof IThrowableEntity) {
                    if (((IThrowableEntity)curEntity).getThrower() != null && ((IThrowableEntity)curEntity).getThrower().func_145782_y() == entityLiving.func_145782_y()) {
                        isDestruction = false;
                    }
                    if (isDestruction && swordType.contains((Object)SwordType.Bewitched)) {
                        if (0 < EnchantmentHelper.func_77506_a((int)Enchantment.field_92091_k.field_77352_x, (ItemStack)stack)) {
                            this.ReflectionProjecTile(curEntity, entityLiving);
                        } else {
                            this.InductionProjecTile(curEntity, entityLiving);
                        }
                        isDestruction = false;
                    }
                } else if (curEntity instanceof EntityThrowable) {
                    if (((EntityThrowable)curEntity).func_85052_h() != null && ((EntityThrowable)curEntity).func_85052_h().func_145782_y() == entityLiving.func_145782_y()) {
                        isDestruction = false;
                    }
                    if (isDestruction && swordType.contains((Object)SwordType.Bewitched)) {
                        if (0 < EnchantmentHelper.func_77506_a((int)Enchantment.field_92091_k.field_77352_x, (ItemStack)stack)) {
                            this.ReflectionProjecTile(curEntity, entityLiving);
                        } else {
                            this.InductionProjecTile(curEntity, entityLiving);
                        }
                        isDestruction = false;
                    }
                }
                if (!isDestruction) continue;
                curEntity.field_70159_w = 0.0;
                curEntity.field_70181_x = 0.0;
                curEntity.field_70179_y = 0.0;
                curEntity.func_70106_y();
                for (int var1 = 0; var1 < 10; ++var1) {
                    Random rand = entityLiving.func_70681_au();
                    double var2 = rand.nextGaussian() * 0.02;
                    double var4 = rand.nextGaussian() * 0.02;
                    double var6 = rand.nextGaussian() * 0.02;
                    double var8 = 10.0;
                    entityLiving.field_70170_p.func_72869_a("explode", curEntity.field_70165_t + (double)(rand.nextFloat() * curEntity.field_70130_N * 2.0f) - (double)curEntity.field_70130_N - var2 * var8, curEntity.field_70163_u + (double)(rand.nextFloat() * curEntity.field_70131_O) - var4 * var8, curEntity.field_70161_v + (double)(rand.nextFloat() * curEntity.field_70130_N * 2.0f) - (double)curEntity.field_70130_N - var6 * var8, var2, var4, var6);
                }
                ++destructedCount;
                StylishRankManager.doAttack((Entity)entityLiving);
            }
            if (0 < destructedCount) {
                stack.func_77972_a(1, entityLiving);
            }
        }
    }

    public MovingObjectPosition rayTrace(EntityLivingBase owner, double par1, float par3) {
        Vec3 vec3 = this.getPosition(owner);
        Vec3 vec31 = owner.func_70676_i(par3);
        Vec3 vec32 = vec3.func_72441_c(vec31.field_72450_a * par1, vec31.field_72448_b * par1, vec31.field_72449_c * par1);
        return owner.field_70170_p.func_147447_a(vec3, vec32, false, false, true);
    }

    public Vec3 getPosition(EntityLivingBase owner) {
        return Vec3.func_72443_a((double)owner.field_70165_t, (double)(owner.field_70163_u + (double)owner.func_70047_e()), (double)owner.field_70161_v);
    }

    public Entity getRayTrace(EntityLivingBase owner, double reachMax) {
        float par1 = 1.0f;
        MovingObjectPosition objectMouseOver = this.rayTrace(owner, reachMax, par1);
        double reachMin = reachMax;
        Vec3 entityPos = this.getPosition(owner);
        if (objectMouseOver != null) {
            reachMin = objectMouseOver.field_72307_f.func_72438_d(entityPos);
        }
        Vec3 lookVec = owner.func_70676_i(par1);
        Vec3 reachVec = entityPos.func_72441_c(lookVec.field_72450_a * reachMax, lookVec.field_72448_b * reachMax, lookVec.field_72449_c * reachMax);
        Entity pointedEntity = null;
        float expandFactor = 1.0f;
        List list = owner.field_70170_p.func_72839_b((Entity)owner, owner.field_70121_D.func_72321_a(lookVec.field_72450_a * reachMax, lookVec.field_72448_b * reachMax, lookVec.field_72449_c * reachMax).func_72314_b((double)expandFactor, (double)expandFactor, (double)expandFactor));
        double tmpDistance = reachMin;
        for (Entity entity : list) {
            double d3;
            if (entity == null || !entity.func_70067_L()) continue;
            float borderSize = entity.func_70111_Y();
            AxisAlignedBB axisalignedbb = entity.field_70121_D.func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
            MovingObjectPosition movingobjectposition = axisalignedbb.func_72327_a(entityPos, reachVec);
            if (axisalignedbb.func_72318_a(entityPos)) {
                if (!(0.0 < tmpDistance) && tmpDistance != 0.0) continue;
                pointedEntity = entity;
                tmpDistance = 0.0;
                continue;
            }
            if (movingobjectposition == null || !((d3 = entityPos.func_72438_d(movingobjectposition.field_72307_f)) < tmpDistance) && tmpDistance != 0.0) continue;
            if (entity == owner.field_70154_o && !entity.canRiderInteract()) {
                if (tmpDistance != 0.0) continue;
                pointedEntity = entity;
                continue;
            }
            pointedEntity = entity;
            tmpDistance = d3;
        }
        return pointedEntity;
    }

    public ItemSlashBlade setRepairMaterialOreDic(String ... material) {
        this.repairMaterialOreDic = material;
        return this;
    }

    public ItemSlashBlade setRepairMaterial(ItemStack item) {
        this.repairMaterial = item;
        return this;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        boolean result = false;
        if (par2ItemStack.func_77973_b() == SlashBlade.proudSoul) {
            result = true;
        }
        if (!result && this.repairMaterial != null) {
            result = par2ItemStack.func_77969_a(this.repairMaterial);
        }
        if (!result && this.repairMaterialOreDic != null) {
            for (String oreName : this.repairMaterialOreDic) {
                ItemStack curItem;
                ArrayList list = OreDictionary.getOres((String)oreName);
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && !(result = (curItem = (ItemStack)iterator.next()).func_77960_j() == Short.MAX_VALUE ? curItem.func_77973_b() == par2ItemStack.func_77973_b() : curItem.func_77969_a(par2ItemStack))) {
                }
            }
        }
        return result;
    }

    public void doSwingItem(ItemStack stack, EntityPlayer entity) {
        if (entity.field_70170_p.field_72995_K) {
            entity.field_82175_bq = true;
            entity.field_110158_av = 0;
            entity.func_71038_i();
        }
    }

    public static void setBaseAttackModifier(NBTTagCompound tag, float modif) {
        BaseAttackModifier.set(tag, Float.valueOf(modif));
        AttackAmplifier.set(tag, Float.valueOf(0.01f));
    }

    public float getBaseAttackModifiers(NBTTagCompound tag) {
        if (BaseAttackModifier.exists(tag)) {
            return BaseAttackModifier.get(tag).floatValue();
        }
        return this.defaultBaseAttackModifier;
    }

    public boolean isDestructable(ItemStack stack) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        return IsDestructable.get(tag);
    }

    public void setDamage(ItemStack stack, int damage) {
        if (damage != Short.MAX_VALUE) {
            NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
            EnumSet<SwordType> types = this.getSwordType(stack);
            int maxDamage = stack.func_77958_k();
            if (damage <= 0 && !types.contains((Object)SwordType.Sealed)) {
                IsBroken.set(tag, false);
            } else if (maxDamage < damage) {
                if (IsBroken.get(tag).booleanValue()) {
                    if (!this.isDestructable(stack)) {
                        damage = Math.min(damage, maxDamage);
                    }
                } else {
                    IsBroken.set(tag, true);
                }
            }
        }
        super.setDamage(stack, damage);
    }

    public void attackTargetEntity(ItemStack stack, Entity target, EntityPlayer player, Boolean isRightClick) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        OnClick.set(tag, isRightClick);
        player.func_71059_n(target);
        OnClick.set(tag, false);
    }

    static Map<Integer, SpecialAttackBase> createSpacialAttaksMap() {
        HashMap saMap = Maps.newHashMap();
        defaultSA = new SlashDimension();
        saMap.put(0, defaultSA);
        saMap.put(1, new Drive(0.75f, 20, false, ComboSequence.Kiriage));
        saMap.put(2, new WaveEdge());
        saMap.put(3, new Drive(1.5f, 10, true, ComboSequence.Iai));
        saMap.put(4, new Spear());
        saMap.put(5, new CircleSlash());
        return saMap;
    }

    public SpecialAttackBase getSpecialAttack(ItemStack stack) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        int key = SpecialAttackType.get(tag);
        return specialAttacks.containsKey(key) ? specialAttacks.get(key) : defaultSA;
    }

    public void doRangeAttack(ItemStack item, EntityLivingBase entity, int mode) {
        int level;
        World w = entity.field_70170_p;
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(item);
        EnumSet<SwordType> types = this.getSwordType(item);
        if (mode == 1 && types.contains((Object)SwordType.Bewitched) && !types.contains((Object)SwordType.Broken) && 0 < (level = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)item)) && ProudSoul.tryAdd(tag, -1, false)) {
            int rank = StylishRankManager.getStylishRank((Entity)entity);
            if (rank < 3) {
                level = Math.min(1, level);
            }
            float magicDamage = level;
            if (!w.field_72995_K) {
                EntityPhantomSwordBase entityDrive = new EntityPhantomSwordBase(w, entity, magicDamage, 90.0f);
                if (entityDrive != null) {
                    entityDrive.setLifeTime(30);
                    int targetid = TargetEntityId.get(tag);
                    entityDrive.setTargetEntityId(targetid);
                    w.func_72838_d((Entity)entityDrive);
                    if (entity instanceof EntityPlayer) {
                        AchievementList.triggerAchievement((EntityPlayer)entity, "phantomSword");
                    }
                }
            } else {
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageRangeAttack(1));
            }
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        if (tag.func_74764_b("rarityType")) {
            byte type = tag.func_74771_c("rarityType");
            switch (type) {
                case 1: {
                    return EnumRarity.common;
                }
                case 2: {
                    return EnumRarity.uncommon;
                }
                case 3: {
                    return EnumRarity.rare;
                }
                case 4: {
                    return EnumRarity.epic;
                }
            }
        }
        EnumSet<SwordType> types = this.getSwordType(stack);
        if (stack.func_77948_v()) {
            if (types.contains((Object)SwordType.Bewitched) || types.contains((Object)SwordType.FiercerEdge)) {
                if (tag.func_74767_n("isDefaultBewitched")) {
                    return EnumRarity.epic;
                }
                return EnumRarity.rare;
            }
            return EnumRarity.uncommon;
        }
        if (tag.func_74767_n("isDefaultBewitched")) {
            return EnumRarity.uncommon;
        }
        return EnumRarity.common;
    }

    public void func_77622_d(ItemStack p_77622_1_, World p_77622_2_, EntityPlayer p_77622_3_) {
        super.func_77622_d(p_77622_1_, p_77622_2_, p_77622_3_);
        AchievementList.triggerCraftingAchievement(p_77622_1_, p_77622_3_);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.field_70170_p.field_72995_K) {
            return false;
        }
        if (entityItem.getEntityData().func_74767_n("noBladeStand")) {
            return false;
        }
        ItemStack stack = entityItem.func_92059_d();
        if (stack.func_77973_b() instanceof ItemSlashBladeWrapper && !ItemSlashBladeWrapper.hasWrapedItem(stack)) {
            return false;
        }
        if (stack.func_77953_t() != EnumRarity.common || stack.func_82837_s() || stack.func_77942_o() && ItemSlashBladeNamed.TrueItemName.exists(stack.func_77978_p())) {
            EntityBladeStand e = new EntityBladeStand(entityItem.field_70170_p, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, stack);
            e.setFlip(e.getRand().nextInt(2));
            e.func_70091_d(entityItem.field_70159_w * 2.0, entityItem.field_70181_x * 2.0, entityItem.field_70179_y * 2.0);
            entityItem.field_70170_p.func_72838_d((Entity)e);
            entityItem.func_70106_y();
            return true;
        }
        return false;
    }

    public static enum SwordType {
        Broken,
        Perfect,
        Enchanted,
        Bewitched,
        SoulEeater,
        FiercerEdge,
        NoScabbard,
        Sealed;

        public static final EnumSet<SwordType> BewitchedSoulEater;
        public static final EnumSet<SwordType> BewitchedPerfect;

        static {
            BewitchedSoulEater = EnumSet.of(SoulEeater, Bewitched);
            BewitchedPerfect = EnumSet.of(Perfect, Bewitched);
        }
    }

    public static enum ComboSequence {
        None(true, 0.0f, 0.0f, false, 0),
        Saya1(true, 200.0f, 5.0f, false, 6),
        Saya2(true, -200.0f, 5.0f, false, 12),
        Battou(false, 240.0f, 0.0f, false, 12),
        Noutou(false, -210.0f, 10.0f, false, 5),
        Kiriage(false, 260.0f, 70.0f, false, 20),
        Kiriorosi(false, -260.0f, 90.0f, false, 12),
        SlashDim(false, -220.0f, 10.0f, true, 8),
        Iai(false, 240.0f, 0.0f, false, 8),
        HiraTuki(false, 180.0f, 180.0f, false, 20);

        public boolean useScabbard;
        public float swingAmplitude;
        public float swingDirection;
        public boolean isCharged;
        public int comboResetTicks;

        private ComboSequence(boolean useScabbard, float swingAmplitude, float swingDirection, boolean isCharged, int comboResetTicks) {
            Seqs.add(this.ordinal(), this);
            this.useScabbard = useScabbard;
            this.swingAmplitude = swingAmplitude;
            this.swingDirection = swingDirection;
            this.isCharged = isCharged;
            this.comboResetTicks = comboResetTicks;
        }

        public static ComboSequence get(int ordinal) {
            return (ComboSequence)((Object)Seqs.get(ordinal));
        }
    }

    static final class EntitySelectorDestructable
    implements IEntitySelector {
        EntitySelectorDestructable() {
        }

        public boolean func_82704_a(Entity par1Entity) {
            boolean result = false;
            if (par1Entity instanceof IProjectile || par1Entity instanceof EntityTNTPrimed || par1Entity instanceof EntityFireball || par1Entity instanceof IThrowableEntity) {
                result = par1Entity.func_70089_S();
            } else {
                String className = par1Entity.getClass().getSimpleName();
                if (ConfigEntityListManager.destructableTargets.containsKey(className)) {
                    if (ConfigEntityListManager.destructableTargets.get(className).booleanValue()) {
                        result = par1Entity.func_70089_S();
                    }
                }
            }
            return result;
        }
    }

    static final class EntitySelectorAttackable
    implements IEntitySelector {
        EntitySelectorAttackable() {
        }

        public boolean func_82704_a(Entity par1Entity) {
            boolean result;
            block4: {
                block3: {
                    block2: {
                        result = false;
                        String entityStr = EntityList.func_75621_b((Entity)par1Entity);
                        if (entityStr == null) break block2;
                        if (!ConfigEntityListManager.attackableTargets.containsKey(entityStr)) break block2;
                        if (ConfigEntityListManager.attackableTargets.get(entityStr).booleanValue()) break block3;
                    }
                    if (!(par1Entity instanceof EntityDragonPart)) break block4;
                }
                result = par1Entity.func_70089_S();
            }
            return result;
        }
    }
}

