/*
 * Decompiled with CFR 0.152.
 */
package tk.ccbluex.PluginLoader.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import tk.ccbluex.PluginLoader.plugin.Plugin;

public class LoaderUtils {
    public static List<Class<Plugin>> extractClassesFromJAR(File jar, ClassLoader cl) throws IOException {
        ArrayList<Class<Plugin>> classes = new ArrayList<Class<Plugin>>();
        JarInputStream jaris = new JarInputStream(new FileInputStream(jar));
        JarEntry ent = null;
        while ((ent = jaris.getNextJarEntry()) != null) {
            if (!ent.getName().toLowerCase().endsWith(".class")) continue;
            try {
                Class<?> cls = cl.loadClass(ent.getName().substring(0, ent.getName().length() - 6).replace('/', '.'));
                if (!LoaderUtils.isPlugin(cls)) continue;
                classes.add(cls);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        jaris.close();
        return classes;
    }

    public static boolean isPlugin(Class<?> cls) {
        return cls.getSuperclass().equals(Plugin.class);
    }
}

