/*
 * Decompiled with CFR 0.152.
 */
package tk.ccbluex.PluginLoader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import tk.ccbluex.PluginLoader.exeptions.NoPluginInfoExeption;
import tk.ccbluex.PluginLoader.plugin.Plugin;
import tk.ccbluex.PluginLoader.util.JARFileFilter;
import tk.ccbluex.PluginLoader.util.LoaderUtils;

public class PluginLoader {
    private String prefix;
    private ArrayList<Plugin> plugins = new ArrayList();

    public PluginLoader(String prefix) {
        this.setPrefix(prefix);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Plugin getPlugin(String name) {
        for (Plugin plugin : this.plugins) {
            if (!plugin.getPluginInfo().name().equalsIgnoreCase(name)) continue;
            return plugin;
        }
        return null;
    }

    public ArrayList<Plugin> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(ArrayList<Plugin> plugins) {
        this.plugins = plugins;
    }

    public void registerPlugin(Plugin plugin) {
        this.plugins.add(plugin);
    }

    public void unregisterPlugin(Plugin plugin) {
        this.plugins.remove(plugin);
    }

    public void loadPlugins(String path) throws InstantiationException, IllegalAccessException, IOException, NoPluginInfoExeption {
        System.out.println("[" + this.getPrefix() + "] All plugins are loading.");
        File dir = new File(path);
        List<File> files = Arrays.asList(dir.listFiles(new JARFileFilter()));
        if (files.isEmpty()) {
            return;
        }
        for (File file : files) {
            this.loadPlugin(file.getPath());
        }
        System.out.println("[" + this.getPrefix() + "] All plugins were loaded.");
    }

    public void loadPlugin(String path) throws IOException, InstantiationException, IllegalAccessException, NoPluginInfoExeption {
        File file = new File(path);
        URLClassLoader loader = new URLClassLoader(new URL[]{file.toURI().toURL()});
        for (Class<Plugin> plug : LoaderUtils.extractClassesFromJAR(file, loader)) {
            Plugin plugin = plug.newInstance();
            if (plugin.getPluginInfo() == null) {
                throw new NoPluginInfoExeption("The plugin class " + plug.getSimpleName() + " have no PluginInfo Annotation!");
            }
            this.registerPlugin(plugin);
            System.out.println("[" + this.getPrefix() + "] " + plugin.getPluginInfo().name() + " v" + plugin.getPluginInfo().version() + " is loading.");
            plugin.onLoad();
            System.out.println("[" + this.getPrefix() + "] " + plugin.getPluginInfo().name() + " v" + plugin.getPluginInfo().version() + " was loaded.");
        }
    }

    public void enablePlugins() {
        for (Plugin plugin : this.plugins) {
            System.out.println("[" + this.getPrefix() + "] " + plugin.getPluginInfo().name() + " v" + plugin.getPluginInfo().version() + " is activated.");
            plugin.onEnable();
            System.out.println("[" + this.getPrefix() + "] " + plugin.getPluginInfo().name() + " v" + plugin.getPluginInfo().version() + " was activated.");
        }
    }

    public void disablePlugins() {
        for (Plugin plugin : this.plugins) {
            System.out.println("[" + this.getPrefix() + "] " + plugin.getPluginInfo().name() + " v" + plugin.getPluginInfo().version() + " is deactivated.");
            plugin.onDisable();
            System.out.println("[" + this.getPrefix() + "] " + plugin.getPluginInfo().name() + " v" + plugin.getPluginInfo().version() + " was deactivated.");
        }
    }
}

