/*
 * Decompiled with CFR 0.152.
 */
package tk.ccbluex.LiquidBounce.file;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import tk.ccbluex.LiquidBounce.LiquidBounce;
import tk.ccbluex.LiquidBounce.file.FileList;
import tk.ccbluex.LiquidBounce.file.Settings;
import tk.ccbluex.LiquidBounce.gui.GuiError;
import tk.ccbluex.LiquidBounce.gui.oldclickgui.OldClickGui;
import tk.ccbluex.LiquidBounce.module.Module;
import tk.ccbluex.LiquidBounce.module.modules.XRay;
import tk.ccbluex.LiquidBounce.utils.JsonUtils;

public class FileManager {
    public File dir;
    public File friends;
    public File modules;
    public File xray;
    public File accounts;
    public File oldClickGui;
    private Settings settings;

    public FileManager() {
        File oldaccounts;
        this.dir = new File(Minecraft.getMinecraft().mcDataDir, "LiquidBounce-" + LiquidBounce.MCVERSION);
        this.friends = new File(this.dir, "friends.json");
        this.modules = new File(this.dir, "modules.json");
        this.xray = new File(this.dir, "xray.li");
        this.accounts = new File(this.dir, "accounts.li");
        this.oldClickGui = new File(this.dir, "oldclickgui.json");
        if (!this.dir.exists()) {
            this.dir.mkdir();
        }
        if ((oldaccounts = new File(this.dir, "accounts.list")).exists()) {
            oldaccounts.renameTo(this.xray);
        }
    }

    public void init() throws Exception {
        this.loadModules();
        this.saveModules();
        this.loadFriends();
        this.saveFriends();
        this.loadOldClickGui();
        this.saveOldClickGui();
        this.loadXray();
        this.saveXray();
    }

    public Settings getSettings() {
        if (this.settings == null) {
            this.settings = new Settings();
        }
        return this.settings;
    }

    public void saveModules() {
        try {
            JsonObject json = new JsonObject();
            for (Module mod : LiquidBounce.INSTANCE.moduleManager.modules) {
                JsonObject jsonMod = new JsonObject();
                jsonMod.addProperty("toggle", mod.isToggled());
                jsonMod.addProperty("key", mod.getKeyCode());
                json.add(mod.getName(), jsonMod);
            }
            PrintWriter save = new PrintWriter(new FileWriter(this.modules));
            save.println(JsonUtils.prettyGson.toJson(json));
            save.close();
        }
        catch (Exception e) {
            Minecraft mc = Minecraft.getMinecraft();
            mc.displayGuiScreen(new GuiError(mc.currentScreen, e));
            e.printStackTrace();
        }
    }

    public void loadModules() {
        try {
            if (!this.modules.exists()) {
                this.modules.createNewFile();
            }
            BufferedReader load = new BufferedReader(new FileReader(this.modules));
            JsonObject json = (JsonObject)JsonUtils.jsonParser.parse(load);
            load.close();
            for (Map.Entry<String, JsonElement> entry : json.entrySet()) {
                Module module = LiquidBounce.INSTANCE.moduleManager.getModule(entry.getKey());
                if (module == null) continue;
                JsonObject jsonModule = (JsonObject)entry.getValue();
                boolean enabled = jsonModule.get("toggle").getAsBoolean();
                module.setToggled(enabled);
                int keycode = jsonModule.get("key").getAsInt();
                module.setKeyCode(keycode);
            }
        }
        catch (Exception e) {
            Minecraft mc = Minecraft.getMinecraft();
            mc.displayGuiScreen(new GuiError(mc.currentScreen, e));
            e.printStackTrace();
        }
    }

    public void saveFriends() {
        try {
            PrintWriter save = new PrintWriter(new FileWriter(this.friends));
            save.println(JsonUtils.prettyGson.toJson(LiquidBounce.INSTANCE.friendManager.getFriends()));
            save.close();
        }
        catch (Exception e) {
            Minecraft mc = Minecraft.getMinecraft();
            mc.displayGuiScreen(new GuiError(mc.currentScreen, e));
            e.printStackTrace();
        }
    }

    public void loadFriends() {
        try {
            BufferedReader load;
            ArrayList friends;
            if (!this.friends.exists()) {
                this.friends.createNewFile();
            }
            if ((friends = JsonUtils.gson.fromJson((Reader)(load = new BufferedReader(new FileReader(this.friends))), ArrayList.class)) != null) {
                LiquidBounce.INSTANCE.friendManager.setFriends(JsonUtils.gson.fromJson((Reader)load, ArrayList.class));
            }
            load.close();
        }
        catch (Exception e) {
            Minecraft mc = Minecraft.getMinecraft();
            mc.displayGuiScreen(new GuiError(mc.currentScreen, e));
            e.printStackTrace();
        }
    }

    public void saveOldClickGui() {
        try {
            JsonObject json = new JsonObject();
            for (OldClickGui.Panel panel : LiquidBounce.INSTANCE.oldClickGui.getPanels()) {
                JsonObject jsonFrame = new JsonObject();
                jsonFrame.addProperty("open", panel.getOpen());
                jsonFrame.addProperty("posX", panel.getX());
                jsonFrame.addProperty("posY", panel.getY());
                json.add(panel.getTitle(), jsonFrame);
            }
            PrintWriter save = new PrintWriter(new FileWriter(this.oldClickGui));
            save.println(JsonUtils.prettyGson.toJson(json));
            save.close();
        }
        catch (Exception e) {
            Minecraft mc = Minecraft.getMinecraft();
            mc.displayGuiScreen(new GuiError(mc.currentScreen, e));
            e.printStackTrace();
        }
    }

    public void loadOldClickGui() {
        try {
            if (!this.oldClickGui.exists()) {
                this.oldClickGui.createNewFile();
            }
            BufferedReader load = new BufferedReader(new FileReader(this.oldClickGui));
            JsonObject json = (JsonObject)JsonUtils.jsonParser.parse(load);
            load.close();
            for (Map.Entry<String, JsonElement> entry : json.entrySet()) {
                for (OldClickGui.Panel panel : LiquidBounce.INSTANCE.oldClickGui.getPanels()) {
                    if (!panel.getTitle().equals(entry.getKey())) continue;
                    JsonObject jsonFrame = (JsonObject)entry.getValue();
                    panel.setOpen(jsonFrame.get("open").getAsBoolean());
                    panel.setX(jsonFrame.get("posX").getAsInt());
                    panel.setY(jsonFrame.get("posY").getAsInt());
                }
            }
        }
        catch (Exception e) {
            Minecraft mc = Minecraft.getMinecraft();
            mc.displayGuiScreen(new GuiError(mc.currentScreen, e));
            e.printStackTrace();
        }
    }

    public void saveXray() {
        try {
            FileList list = new FileList(this.xray);
            list.clear();
            for (Block block : ((XRay)LiquidBounce.INSTANCE.moduleManager.getModule(XRay.class)).xrayBlocks) {
                list.add(String.valueOf(Block.getIdFromBlock(block)));
            }
        }
        catch (Exception e) {
            Minecraft mc = Minecraft.getMinecraft();
            mc.displayGuiScreen(new GuiError(mc.currentScreen, e));
            e.printStackTrace();
        }
    }

    public void loadXray() {
        try {
            if (!this.xray.exists()) {
                this.xray.createNewFile();
                return;
            }
            FileList list = new FileList(this.xray);
            for (String value : list.read()) {
                ((XRay)LiquidBounce.INSTANCE.moduleManager.getModule(XRay.class)).xrayBlocks.add(Block.getBlockById(Integer.parseInt(value)));
            }
        }
        catch (Exception e) {
            Minecraft mc = Minecraft.getMinecraft();
            mc.displayGuiScreen(new GuiError(mc.currentScreen, e));
            e.printStackTrace();
        }
    }

    public FileList getAccounts() throws Exception {
        return new FileList(this.accounts);
    }
}

