/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import java.util.List;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.network.play.server.S21PacketChunkData;
import net.minecraft.world.chunk.Chunk;

public class S26PacketMapChunkBulk
implements Packet<INetHandlerPlayClient> {
    private int[] xPositions;
    private int[] zPositions;
    private S21PacketChunkData.Extracted[] chunksData;
    private boolean isOverworld;

    public S26PacketMapChunkBulk() {
    }

    public S26PacketMapChunkBulk(List<Chunk> chunks) {
        int i = chunks.size();
        this.xPositions = new int[i];
        this.zPositions = new int[i];
        this.chunksData = new S21PacketChunkData.Extracted[i];
        this.isOverworld = !chunks.get((int)0).getWorld().provider.getHasNoSky();
        int j = 0;
        while (j < i) {
            Chunk chunk = chunks.get(j);
            S21PacketChunkData.Extracted s21packetchunkdata$extracted = S21PacketChunkData.func_179756_a(chunk, true, this.isOverworld, 65535);
            this.xPositions[j] = chunk.xPosition;
            this.zPositions[j] = chunk.zPosition;
            this.chunksData[j] = s21packetchunkdata$extracted;
            ++j;
        }
    }

    @Override
    public void readPacketData(PacketBuffer buf) throws IOException {
        this.isOverworld = buf.readBoolean();
        int i = buf.readVarIntFromBuffer();
        this.xPositions = new int[i];
        this.zPositions = new int[i];
        this.chunksData = new S21PacketChunkData.Extracted[i];
        int j = 0;
        while (j < i) {
            this.xPositions[j] = buf.readInt();
            this.zPositions[j] = buf.readInt();
            this.chunksData[j] = new S21PacketChunkData.Extracted();
            this.chunksData[j].dataSize = buf.readShort() & 0xFFFF;
            this.chunksData[j].data = new byte[S21PacketChunkData.func_180737_a(Integer.bitCount(this.chunksData[j].dataSize), this.isOverworld, true)];
            ++j;
        }
        int k = 0;
        while (k < i) {
            buf.readBytes(this.chunksData[k].data);
            ++k;
        }
    }

    @Override
    public void writePacketData(PacketBuffer buf) throws IOException {
        buf.writeBoolean(this.isOverworld);
        buf.writeVarIntToBuffer(this.chunksData.length);
        int i = 0;
        while (i < this.xPositions.length) {
            buf.writeInt(this.xPositions[i]);
            buf.writeInt(this.zPositions[i]);
            buf.writeShort((short)(this.chunksData[i].dataSize & 0xFFFF));
            ++i;
        }
        int j = 0;
        while (j < this.xPositions.length) {
            buf.writeBytes(this.chunksData[j].data);
            ++j;
        }
    }

    @Override
    public void processPacket(INetHandlerPlayClient handler) {
        handler.handleMapChunkBulk(this);
    }

    public int getChunkX(int p_149255_1_) {
        return this.xPositions[p_149255_1_];
    }

    public int getChunkZ(int p_149253_1_) {
        return this.zPositions[p_149253_1_];
    }

    public int getChunkCount() {
        return this.xPositions.length;
    }

    public byte[] getChunkBytes(int p_149256_1_) {
        return this.chunksData[p_149256_1_].data;
    }

    public int getChunkSize(int p_179754_1_) {
        return this.chunksData[p_179754_1_].dataSize;
    }
}

