/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;

public class GuiButton
extends Gui {
    protected static final ResourceLocation BUTTON_TEXTURES = new ResourceLocation("textures/gui/widgets.png");
    protected int width = 200;
    protected int height = 20;
    public int xPosition;
    public int yPosition;
    public String displayString;
    public int id;
    public boolean enabled = true;
    public boolean visible = true;
    protected boolean hovered;
    public int cs;
    public int alpha;

    public GuiButton(int buttonId, int x, int y, String buttonText) {
        this(buttonId, x, y, 200, 20, buttonText);
    }

    public GuiButton(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText) {
        this.id = buttonId;
        this.xPosition = x;
        this.yPosition = y;
        this.width = widthIn;
        this.height = heightIn;
        this.displayString = buttonText;
    }

    protected int getHoverState(boolean mouseOver) {
        int i = 1;
        if (!this.enabled) {
            i = 0;
        } else if (mouseOver) {
            i = 2;
        }
        return i;
    }

    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        Color color1 = new Color(0.0f, 0.0f, 0.0f, (float)this.alpha / 255.0f);
        int col1 = color1.getRGB();
        if (this.visible) {
            FontRenderer var4 = mc.fontRendererObj;
            this.hovered = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
            this.updatefade();
            if (this.hovered) {
                if (this.cs >= 4) {
                    this.cs = 4;
                }
                ++this.cs;
            } else {
                if (this.cs <= 0) {
                    this.cs = 0;
                }
                --this.cs;
            }
            if (this.enabled) {
                Gui.drawRect(this.xPosition + this.cs, this.yPosition, this.xPosition + this.width - this.cs, this.yPosition + this.height, col1);
            } else {
                Gui.drawRect(this.xPosition, this.yPosition, this.xPosition + this.width, this.yPosition + this.height, new Color(0.5f, 0.5f, 0.5f, 0.5f).hashCode());
            }
            this.mouseDragged(mc, mouseX, mouseY);
            int var5 = 0xE0E0E0;
            this.drawCenteredString(var4, StringUtils.stripControlCodes(this.displayString), this.xPosition + this.width / 2, this.yPosition + (this.height - 5) / 2, var5);
        }
    }

    protected void mouseDragged(Minecraft mc, int mouseX, int mouseY) {
    }

    public void mouseReleased(int mouseX, int mouseY) {
    }

    public boolean mousePressed(Minecraft mc, int mouseX, int mouseY) {
        return this.enabled && this.visible && mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
    }

    public boolean isMouseOver() {
        return this.hovered;
    }

    public void drawButtonForegroundLayer(int mouseX, int mouseY) {
    }

    public void playPressSound(SoundHandler soundHandlerIn) {
        soundHandlerIn.playSound(PositionedSoundRecord.create(new ResourceLocation("gui.button.press"), 1.0f));
    }

    public int getButtonWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    private void updatefade() {
        if (this.enabled) {
            if (this.hovered) {
                this.alpha += 25;
                if (this.alpha >= 210) {
                    this.alpha = 210;
                }
            } else {
                this.alpha -= 25;
                if (this.alpha <= 120) {
                    this.alpha = 120;
                }
            }
        }
    }
}

