/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.connection;

import io.sentry.connection.AbstractConnection;
import io.sentry.connection.ConnectionException;
import io.sentry.connection.EventSampler;
import io.sentry.environment.SentryEnvironment;
import io.sentry.event.Event;
import io.sentry.marshaller.Marshaller;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnection
extends AbstractConnection {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Logger logger = LoggerFactory.getLogger(HttpConnection.class);
    private static final String USER_AGENT = "User-Agent";
    private static final String SENTRY_AUTH = "X-Sentry-Auth";
    private static final int DEFAULT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(1L);
    private static final HostnameVerifier NAIVE_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession sslSession) {
            return true;
        }
    };
    private final URL sentryUrl;
    private final Proxy proxy;
    private EventSampler eventSampler;
    private Marshaller marshaller;
    private int timeout = DEFAULT_TIMEOUT;
    private boolean bypassSecurity = false;

    public HttpConnection(URL sentryUrl, String publicKey, String secretKey, Proxy proxy, EventSampler eventSampler) {
        super(publicKey, secretKey);
        this.sentryUrl = sentryUrl;
        this.proxy = proxy;
        this.eventSampler = eventSampler;
    }

    public static URL getSentryApiUrl(URI sentryUri, String projectId) {
        try {
            String url = sentryUri.toString() + "api/" + projectId + "/store/";
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Couldn't build a valid URL from the Sentry API.", e);
        }
    }

    protected HttpURLConnection getConnection() {
        try {
            HttpURLConnection connection = this.proxy != null ? (HttpURLConnection)this.sentryUrl.openConnection(this.proxy) : (HttpURLConnection)this.sentryUrl.openConnection();
            if (this.bypassSecurity && connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).setHostnameVerifier(NAIVE_VERIFIER);
            }
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setConnectTimeout(this.timeout);
            connection.setRequestProperty(USER_AGENT, SentryEnvironment.getSentryName());
            connection.setRequestProperty(SENTRY_AUTH, this.getAuthHeader());
            if (this.marshaller.getContentType() != null) {
                connection.setRequestProperty("Content-Type", this.marshaller.getContentType());
            }
            if (this.marshaller.getContentEncoding() != null) {
                connection.setRequestProperty("Content-Encoding", this.marshaller.getContentEncoding());
            }
            return connection;
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't set up a connection to the Sentry server.", e);
        }
    }

    @Override
    protected void doSend(Event event) throws ConnectionException {
        if (this.eventSampler != null && !this.eventSampler.shouldSendEvent(event)) {
            return;
        }
        HttpURLConnection connection = this.getConnection();
        try {
            connection.connect();
            OutputStream outputStream = connection.getOutputStream();
            this.marshaller.marshall(event, outputStream);
            outputStream.close();
            connection.getInputStream().close();
        }
        catch (IOException e) {
            String errorMessage = null;
            InputStream errorStream = connection.getErrorStream();
            if (errorStream != null) {
                errorMessage = this.getErrorMessageFromStream(errorStream);
            }
            if (null == errorMessage || errorMessage.isEmpty()) {
                errorMessage = "An exception occurred while submitting the event to the Sentry server.";
            }
            Long retryAfterMs = null;
            String retryAfterHeader = connection.getHeaderField("Retry-After");
            if (retryAfterHeader != null) {
                try {
                    retryAfterMs = Long.parseLong(retryAfterHeader) * 1000L;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new ConnectionException(errorMessage, e, retryAfterMs);
        }
        finally {
            connection.disconnect();
        }
    }

    private String getErrorMessageFromStream(InputStream errorStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream, UTF_8));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            boolean first = true;
            while ((line = reader.readLine()) != null) {
                if (!first) {
                    sb.append("\n");
                }
                sb.append(line);
                first = false;
            }
        }
        catch (Exception e2) {
            logger.error("Exception while reading the error message from the connection.", e2);
        }
        return sb.toString();
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void setBypassSecurity(boolean bypassSecurity) {
        this.bypassSecurity = bypassSecurity;
    }

    @Override
    public void close() throws IOException {
    }
}

