/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.vfx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.vfx.AbstractGameEffect;

public class TrailRelicParticle
extends AbstractGameEffect {
    private static final float DURATION = 1.0f;
    private float scale = 0.01f;
    private static final int IMG_W = 128;
    private Texture img;
    private float x;
    private float y;

    public TrailRelicParticle(Texture img, float x, float y) {
        this.duration = 1.0f;
        this.img = img;
        this.x = x;
        this.y = y;
        this.renderBehind = true;
    }

    @Override
    public void update() {
        this.scale = Interpolation.linear.apply(0.0f, Settings.scale, this.duration);
        this.duration -= Gdx.graphics.getDeltaTime();
        if (this.duration < 0.0f) {
            this.isDone = true;
        }
    }

    @Override
    public void render(SpriteBatch sb) {
        sb.setColor(new Color(0.6f, 1.0f, 1.0f, this.duration / 2.0f));
        sb.draw(this.img, this.x - 64.0f, this.y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, this.scale, this.scale, 0.0f, 0, 0, 128, 128, false, false);
    }
}

