/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.vfx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.vfx.AbstractGameEffect;

public class PotionTrailEffect
extends AbstractGameEffect {
    private static final int W = 64;
    private static final float DURATION = 1.0f;
    private float scale;
    private float x;
    private float y;
    private float angle;

    public PotionTrailEffect(float x, float y, float angle) {
        this.x = x;
        this.y = y;
        this.angle = angle;
        this.color = Color.WHITE.cpy();
        this.duration = 1.0f;
        this.renderBehind = true;
    }

    @Override
    public void update() {
        this.duration -= Gdx.graphics.getDeltaTime();
        if (this.duration < 0.0f) {
            this.isDone = true;
        }
        this.scale = this.duration;
        this.color.a = this.duration / 2.0f;
    }

    @Override
    public void render(SpriteBatch sb) {
        sb.setColor(this.color);
        sb.draw(ImageMaster.WHITE_SQUARE_IMG, this.x - 32.0f, this.y - 32.0f, 32.0f, 32.0f, 64.0f, 64.0f, this.scale * Settings.scale / 2.0f, this.scale * Settings.scale / 2.0f, this.angle, 0, 0, 64, 64, false, false);
    }
}

