/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.ui.panels;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Bezier;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.megacrit.cardcrawl.actions.common.HealAction;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.GameCursor;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.TipHelper;
import com.megacrit.cardcrawl.localization.TutorialStrings;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.potions.AbstractPotion;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.vfx.ThoughtBubble;

public class PotionPopUp {
    private static final TutorialStrings tutorialStrings = CardCrawlGame.languagePack.getTutorialString("Potion Panel Tip");
    public static final String[] MSG = PotionPopUp.tutorialStrings.TEXT;
    public static final String[] LABEL = PotionPopUp.tutorialStrings.LABEL;
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("PotionPopUp");
    public static final String[] TEXT = PotionPopUp.uiStrings.TEXT;
    private int slot;
    private AbstractPotion potion;
    public boolean isHidden = true;
    public boolean targetMode = false;
    private static final int RAW_W = 282;
    private static final int RAW_H = 286;
    private static final float HB_W = 184.0f;
    private static final float HB_H = 52.0f;
    private Hitbox hbTop;
    private Hitbox hbBot;
    private float x;
    private float y;
    private static final int SEGMENTS = 20;
    private Vector2[] points = new Vector2[20];
    private Vector2 controlPoint;
    private float arrowScale;
    private float arrowScaleTimer = 0.0f;
    private static final float ARROW_TARGET_SCALE = 1.2f;
    private static final int TARGET_ARROW_W = 256;
    private AbstractMonster hoveredMonster = null;
    private static final String THROW_LABEL = TEXT[0];
    private static final String DRINK_LABEL = TEXT[1];
    private static final String DISCARD_LABEL = TEXT[2];

    public PotionPopUp() {
        this.hbTop = new Hitbox(184.0f, 52.0f);
        this.hbBot = new Hitbox(184.0f, 52.0f);
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = new Vector2();
        }
    }

    public void open(int slot, AbstractPotion potion) {
        this.slot = slot;
        this.potion = potion;
        this.x = potion.currentX;
        this.y = (float)Settings.HEIGHT - 186.0f * Settings.scale;
        this.isHidden = false;
        this.hbTop.move(this.x, this.y + 44.0f * Settings.scale);
        this.hbBot.move(this.x, this.y - 14.0f * Settings.scale);
        this.hbTop.clickStarted = false;
        this.hbBot.clickStarted = false;
        this.hbTop.clicked = false;
        this.hbBot.clicked = false;
    }

    public void close() {
        this.isHidden = true;
    }

    public void update() {
        if (!this.isHidden) {
            this.hbTop.update();
            this.hbBot.update();
            this.updateInput();
        } else if (this.targetMode) {
            this.updateTargetMode();
        }
    }

    private void updateTargetMode() {
        if (InputHelper.justClickedRight || AbstractDungeon.isScreenUp || (float)InputHelper.mY > (float)Settings.HEIGHT - 80.0f * Settings.scale || AbstractDungeon.player.hoveredCard != null || (float)InputHelper.mY < 140.0f * Settings.scale) {
            this.targetMode = false;
            GameCursor.hidden = false;
        }
        this.hoveredMonster = null;
        for (AbstractMonster m : AbstractDungeon.getMonsters().monsters) {
            if (!m.hb.hovered || m.isDying) continue;
            this.hoveredMonster = m;
            break;
        }
        if (InputHelper.justClickedLeft) {
            InputHelper.justClickedLeft = false;
            if (this.hoveredMonster != null) {
                CardCrawlGame.metricData.potions_floor_usage.add(AbstractDungeon.floorNum);
                this.potion.use(this.hoveredMonster);
                this.ornithopter();
                AbstractDungeon.topPanel.destroyPotion(this.slot);
            }
            this.targetMode = false;
            GameCursor.hidden = false;
        }
    }

    private void ornithopter() {
        if (AbstractDungeon.player.hasRelic("Toy Ornithopter")) {
            AbstractDungeon.player.getRelic("Toy Ornithopter").flash();
            AbstractDungeon.actionManager.addToBottom(new HealAction(AbstractDungeon.player, AbstractDungeon.player, 3));
        }
    }

    private void updateInput() {
        if (InputHelper.justClickedLeft) {
            InputHelper.justClickedLeft = false;
            if (this.hbTop.hovered) {
                this.hbTop.clickStarted = true;
            } else if (this.hbBot.hovered) {
                this.hbBot.clickStarted = true;
            } else {
                this.close();
            }
        }
        if (this.hbTop.clicked && !AbstractDungeon.isScreenUp) {
            this.hbTop.clicked = false;
            if (this.potion.canUse()) {
                if (!this.potion.targetRequired) {
                    CardCrawlGame.metricData.potions_floor_usage.add(AbstractDungeon.floorNum);
                    this.potion.use(null);
                    this.ornithopter();
                    CardCrawlGame.sound.play("POTION_1");
                    AbstractDungeon.topPanel.destroyPotion(this.slot);
                } else {
                    this.targetMode = true;
                    GameCursor.hidden = true;
                }
                this.close();
            } else if (AbstractDungeon.player.hasRelic("Sozu")) {
                AbstractDungeon.effectList.add(new ThoughtBubble(AbstractDungeon.player.dialogX, AbstractDungeon.player.dialogY, 3.0f, TEXT[3], true));
                AbstractDungeon.player.getRelic("Sozu").flash();
            }
        } else if (this.hbBot.clicked && AbstractDungeon.getCurrRoom().phase != AbstractRoom.RoomPhase.COMBAT) {
            this.hbBot.clicked = false;
            CardCrawlGame.sound.play("POTION_DROP_2");
            AbstractDungeon.topPanel.destroyPotion(this.slot);
            this.slot = -1;
            this.potion = null;
            this.close();
        } else if (this.hbBot.clicked && AbstractDungeon.getCurrRoom().phase == AbstractRoom.RoomPhase.COMBAT) {
            this.hbBot.clicked = false;
            AbstractDungeon.effectList.add(new ThoughtBubble(AbstractDungeon.player.dialogX, AbstractDungeon.player.dialogY, 3.0f, TEXT[4], true));
        }
    }

    public void render(SpriteBatch sb) {
        if (!this.isHidden) {
            sb.setColor(Color.WHITE);
            sb.draw(ImageMaster.POTION_UI_SHADOW, this.x - 141.0f, this.y - 143.0f, 141.0f, 143.0f, 282.0f, 286.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 282, 286, false, false);
            sb.draw(ImageMaster.POTION_UI_BG, this.x - 141.0f, this.y - 143.0f, 141.0f, 143.0f, 282.0f, 286.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 282, 286, false, false);
            if (this.hbTop.hovered) {
                sb.draw(ImageMaster.POTION_UI_TOP, this.x - 141.0f, this.y - 143.0f, 141.0f, 143.0f, 282.0f, 286.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 282, 286, false, false);
            } else if (this.hbBot.hovered) {
                sb.draw(ImageMaster.POTION_UI_MID, this.x - 141.0f, this.y - 143.0f, 141.0f, 143.0f, 282.0f, 286.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 282, 286, false, false);
            }
            sb.draw(ImageMaster.POTION_UI_OVERLAY, this.x - 141.0f, this.y - 143.0f, 141.0f, 143.0f, 282.0f, 286.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 282, 286, false, false);
            Color c = Settings.CREAM_COLOR;
            if (!this.potion.canUse() || AbstractDungeon.isScreenUp) {
                c = Color.GRAY;
            }
            String label = DRINK_LABEL;
            if (this.potion.isThrown) {
                label = THROW_LABEL;
            }
            FontHelper.renderFontCenteredWidth(sb, FontHelper.topPanelInfoFont, label, this.x, this.y + 55.0f * Settings.scale, c);
            FontHelper.renderFontCenteredWidth(sb, FontHelper.topPanelInfoFont, DISCARD_LABEL, this.x, this.y - 2.0f * Settings.scale, Color.SALMON);
            this.hbTop.render(sb);
            this.hbBot.render(sb);
            if (this.hbTop.hovered) {
                if (this.potion.isThrown) {
                    TipHelper.renderGenericTip(this.x + 124.0f * Settings.scale, this.y + 50.0f * Settings.scale, LABEL[0], MSG[0]);
                } else {
                    TipHelper.renderGenericTip(this.x + 124.0f * Settings.scale, this.y + 50.0f * Settings.scale, LABEL[1], MSG[1]);
                }
            } else if (this.hbBot.hovered) {
                TipHelper.renderGenericTip(this.x + 124.0f * Settings.scale, this.y + 50.0f * Settings.scale, LABEL[2], MSG[2]);
            }
        }
        if (this.targetMode) {
            if (this.hoveredMonster != null) {
                this.hoveredMonster.renderReticle(sb);
            }
            this.renderTargetingUi(sb);
        }
    }

    private void renderTargetingUi(SpriteBatch sb) {
        float x = InputHelper.mX;
        float y = InputHelper.mY;
        this.controlPoint = new Vector2(this.potion.currentX - (x - this.potion.currentX) / 4.0f, y + (y - this.potion.currentY - 40.0f * Settings.scale) / 2.0f);
        if (this.hoveredMonster == null) {
            this.arrowScale = Settings.scale;
            this.arrowScaleTimer = 0.0f;
            sb.setColor(new Color(1.0f, 1.0f, 1.0f, 1.0f));
        } else {
            this.arrowScaleTimer += Gdx.graphics.getDeltaTime();
            if (this.arrowScaleTimer > 1.0f) {
                this.arrowScaleTimer = 1.0f;
            }
            this.arrowScale = Interpolation.elasticOut.apply(Settings.scale, Settings.scale * 1.2f, this.arrowScaleTimer);
            sb.setColor(new Color(1.0f, 0.2f, 0.3f, 1.0f));
        }
        Vector2 tmp = new Vector2(this.controlPoint.x - x, this.controlPoint.y - y);
        tmp.nor();
        this.drawCurvedLine(sb, new Vector2(this.potion.currentX, this.potion.currentY - 40.0f * Settings.scale), new Vector2(x, y), this.controlPoint);
        sb.draw(ImageMaster.TARGET_UI_ARROW, x - 128.0f, y - 128.0f, 128.0f, 128.0f, 256.0f, 256.0f, this.arrowScale, this.arrowScale, tmp.angle() + 90.0f, 0, 0, 256, 256, false, false);
    }

    private void drawCurvedLine(SpriteBatch sb, Vector2 start, Vector2 end, Vector2 control) {
        float radius = 7.0f * Settings.scale;
        for (int i = 0; i < this.points.length - 1; ++i) {
            float angle;
            Vector2 tmp;
            this.points[i] = Bezier.quadratic(this.points[i], (float)i / 20.0f, start, control, end, new Vector2());
            radius += 0.4f * Settings.scale;
            if (i != 0) {
                tmp = new Vector2(this.points[i - 1].x - this.points[i].x, this.points[i - 1].y - this.points[i].y);
                angle = tmp.nor().angle() + 90.0f;
            } else {
                tmp = new Vector2(this.controlPoint.x - this.points[i].x, this.controlPoint.y - this.points[i].y);
                angle = tmp.nor().angle() + 270.0f;
            }
            sb.draw(ImageMaster.TARGET_UI_CIRCLE, this.points[i].x - 64.0f, this.points[i].y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, radius / 18.0f, radius / 18.0f, angle, 0, 0, 128, 128, false, false);
        }
    }
}

