/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.ui.campfire;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.rooms.RestRoom;

public abstract class AbstractCampfireOption {
    protected String label;
    protected String description;
    protected Texture img;
    private static final int W = 256;
    private static final float SHDW_X = 11.0f * Settings.scale;
    private static final float SHDW_Y = -8.0f * Settings.scale;
    private Color color = Color.WHITE.cpy();
    private static final float NORM_SCALE = 0.9f * Settings.scale;
    private static final float HOVER_SCALE = Settings.scale;
    private float scale = NORM_SCALE;
    protected Hitbox hb = new Hitbox(216.0f * Settings.scale, 140.0f * Settings.scale);
    public boolean useable = true;

    public void setPosition(float x, float y) {
        this.hb.move(x, y);
    }

    public void update() {
        this.hb.update();
        if (this.hb.hovered && !((RestRoom)AbstractDungeon.getCurrRoom()).campfireUI.somethingSelected && this.useable) {
            if (this.hb.justHovered) {
                CardCrawlGame.sound.play("UI_HOVER");
            }
            if (InputHelper.justClickedLeft) {
                CardCrawlGame.sound.play("UI_CLICK_1");
                this.hb.clickStarted = true;
            }
            if (!this.hb.clickStarted) {
                this.scale = MathHelper.scaleLerpSnap(this.scale, HOVER_SCALE);
                this.scale = MathHelper.scaleLerpSnap(this.scale, HOVER_SCALE);
            } else {
                this.scale = MathHelper.scaleLerpSnap(this.scale, NORM_SCALE);
            }
        } else {
            this.scale = MathHelper.scaleLerpSnap(this.scale, NORM_SCALE);
        }
        if (this.hb.clicked) {
            this.hb.clicked = false;
            this.useOption();
            ((RestRoom)AbstractDungeon.getCurrRoom()).campfireUI.somethingSelected = true;
        }
    }

    public abstract void useOption();

    public void render(SpriteBatch sb) {
        sb.setColor(new Color(0.0f, 0.0f, 0.0f, this.color.a / 5.0f));
        sb.draw(this.img, this.hb.cX - 128.0f + SHDW_X, this.hb.cY - 128.0f + SHDW_Y, 128.0f, 128.0f, 256.0f, 256.0f, this.scale, this.scale, 0.0f, 0, 0, 256, 256, false, false);
        sb.setColor(this.color);
        sb.draw(this.img, this.hb.cX - 128.0f, this.hb.cY - 128.0f, 128.0f, 128.0f, 256.0f, 256.0f, this.scale, this.scale, 0.0f, 0, 0, 256, 256, false, false);
        FontHelper.renderFontCenteredTopAligned(sb, FontHelper.topPanelInfoFont, this.label, this.hb.cX, this.hb.cY - 60.0f * Settings.scale - 50.0f * Settings.scale * this.scale, Settings.GOLD_COLOR);
        if (this.hb.hovered) {
            FontHelper.renderFontCenteredTopAligned(sb, FontHelper.topPanelInfoFont, this.description, 950.0f * Settings.scale, 560.0f * Settings.scale, Settings.CREAM_COLOR);
        }
        this.hb.render(sb);
    }
}

