/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.ui.buttons;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;

public class ConfirmButton {
    private static final int W = 512;
    private static final int H = 256;
    private static final Color HOVER_BLEND_COLOR = new Color(1.0f, 1.0f, 1.0f, 0.3f);
    private static final Color TEXT_DISABLED_COLOR = new Color(0.6f, 0.6f, 0.6f, 1.0f);
    private static final float SHOW_X = (float)Settings.WIDTH - 256.0f * Settings.scale;
    private static final float DRAW_Y = 128.0f * Settings.scale;
    private static final float HIDE_X = SHOW_X + 400.0f * Settings.scale;
    private float current_x;
    private float target_x;
    private boolean isHidden;
    public boolean isDisabled;
    public boolean isHovered;
    private float glowAlpha;
    private Color glowColor;
    private String buttonText;
    private static final float TEXT_OFFSET_X = 136.0f * Settings.scale;
    private static final float TEXT_OFFSET_Y = 57.0f * Settings.scale;
    private static final float HITBOX_W = 300.0f * Settings.scale;
    private static final float HITBOX_H = 100.0f * Settings.scale;
    public Hitbox hitbox;

    public ConfirmButton(String label) {
        this.target_x = this.current_x = HIDE_X;
        this.isHidden = true;
        this.isDisabled = true;
        this.isHovered = false;
        this.glowAlpha = 0.0f;
        this.glowColor = Color.WHITE.cpy();
        this.buttonText = "NOT_SET";
        this.hitbox = new Hitbox(0.0f, 0.0f, HITBOX_W, HITBOX_H);
        this.buttonText = label;
        this.hitbox.move(SHOW_X + 106.0f * Settings.scale, DRAW_Y + 60.0f * Settings.scale);
    }

    public void updateText(String label) {
        this.buttonText = label;
    }

    public void update() {
        if (!this.isHidden) {
            this.updateGlow();
            this.hitbox.update();
            if (InputHelper.justClickedLeft && this.hitbox.hovered && !this.isDisabled) {
                this.hitbox.clickStarted = true;
                CardCrawlGame.sound.play("UI_CLICK_1");
            }
            if (this.hitbox.justHovered && !this.isDisabled) {
                CardCrawlGame.sound.play("UI_HOVER");
            }
            this.isHovered = this.hitbox.hovered;
        }
        if (this.current_x != this.target_x) {
            this.current_x = MathUtils.lerp(this.current_x, this.target_x, Gdx.graphics.getDeltaTime() * 9.0f);
            if (Math.abs(this.current_x - this.target_x) < Settings.UI_SNAP_THRESHOLD) {
                this.current_x = this.target_x;
            }
        }
    }

    private void updateGlow() {
        float tmp;
        this.glowAlpha += Gdx.graphics.getDeltaTime() * 3.0f;
        if (this.glowAlpha < 0.0f) {
            this.glowAlpha *= -1.0f;
        }
        this.glowColor.a = (tmp = MathUtils.cos(this.glowAlpha)) < 0.0f ? -tmp / 2.0f + 0.3f : tmp / 2.0f + 0.3f;
    }

    public void hideInstantly() {
        this.current_x = HIDE_X;
        this.target_x = HIDE_X;
        this.isHidden = true;
    }

    public void hide() {
        if (!this.isHidden) {
            this.target_x = HIDE_X;
            this.isHidden = true;
        }
    }

    public void show() {
        if (this.isHidden) {
            this.glowAlpha = 0.0f;
            this.target_x = SHOW_X;
            this.isHidden = false;
        }
    }

    public void render(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        this.renderShadow(sb);
        sb.setColor(this.glowColor);
        this.renderOutline(sb);
        sb.setColor(Color.WHITE);
        this.renderButton(sb);
        if (this.hitbox.hovered && !this.isDisabled && !this.hitbox.clickStarted) {
            sb.setBlendFunction(770, 1);
            sb.setColor(HOVER_BLEND_COLOR);
            this.renderButton(sb);
            sb.setBlendFunction(770, 771);
        }
        if (this.isDisabled) {
            FontHelper.renderFontCentered(sb, FontHelper.buttonLabelFont, this.buttonText, this.current_x + TEXT_OFFSET_X, DRAW_Y + TEXT_OFFSET_Y, TEXT_DISABLED_COLOR);
        } else if (this.hitbox.clickStarted) {
            FontHelper.renderFontCentered(sb, FontHelper.buttonLabelFont, this.buttonText, this.current_x + TEXT_OFFSET_X, DRAW_Y + TEXT_OFFSET_Y, Color.LIGHT_GRAY);
        } else if (this.hitbox.hovered) {
            FontHelper.renderFontCentered(sb, FontHelper.buttonLabelFont, this.buttonText, this.current_x + TEXT_OFFSET_X, DRAW_Y + TEXT_OFFSET_Y, Settings.LIGHT_YELLOW_COLOR);
        } else {
            FontHelper.renderFontCentered(sb, FontHelper.buttonLabelFont, this.buttonText, this.current_x + TEXT_OFFSET_X, DRAW_Y + TEXT_OFFSET_Y, Settings.LIGHT_YELLOW_COLOR);
        }
        if (!this.isHidden) {
            this.hitbox.render(sb);
        }
    }

    private void renderShadow(SpriteBatch sb) {
        sb.draw(ImageMaster.CONFIRM_BUTTON_SHADOW, this.current_x - 256.0f, DRAW_Y - 128.0f, 256.0f, 128.0f, 512.0f, 256.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 512, 256, false, false);
    }

    private void renderOutline(SpriteBatch sb) {
        sb.draw(ImageMaster.CONFIRM_BUTTON_OUTLINE, this.current_x - 256.0f, DRAW_Y - 128.0f, 256.0f, 128.0f, 512.0f, 256.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 512, 256, false, false);
    }

    private void renderButton(SpriteBatch sb) {
        sb.draw(ImageMaster.CONFIRM_BUTTON, this.current_x - 256.0f, DRAW_Y - 128.0f, 256.0f, 128.0f, 512.0f, 256.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 512, 256, false, false);
    }
}

