/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.ui.buttons;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.rooms.RestRoom;
import com.megacrit.cardcrawl.rooms.TreasureRoomBoss;
import com.megacrit.cardcrawl.screens.mainMenu.MainMenuScreen;

public class CancelButton {
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("Cancel Button");
    public static final String[] TEXT = CancelButton.uiStrings.TEXT;
    private static final int W = 512;
    private static final int H = 256;
    private static final Color HOVER_BLEND_COLOR = new Color(1.0f, 1.0f, 1.0f, 0.4f);
    private static final float SHOW_X = 256.0f * Settings.scale;
    private static final float DRAW_Y = 128.0f * Settings.scale;
    public static final float HIDE_X = SHOW_X - 400.0f * Settings.scale;
    public float current_x;
    private float target_x;
    public boolean isHidden;
    private float glowAlpha;
    private Color glowColor;
    public String buttonText;
    private static final float TEXT_OFFSET_X = -136.0f * Settings.scale;
    private static final float TEXT_OFFSET_Y = 57.0f * Settings.scale;
    private static final float HITBOX_W = 300.0f * Settings.scale;
    private static final float HITBOX_H = 100.0f * Settings.scale;
    public Hitbox hitbox;

    public CancelButton() {
        this.target_x = this.current_x = HIDE_X;
        this.isHidden = true;
        this.glowAlpha = 0.0f;
        this.glowColor = Settings.GOLD_COLOR.cpy();
        this.buttonText = "NOT_SET";
        this.hitbox = new Hitbox(0.0f, 0.0f, HITBOX_W, HITBOX_H);
        this.hitbox.move(SHOW_X - 106.0f * Settings.scale, DRAW_Y + 60.0f * Settings.scale);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void update() {
        block17: {
            if (!this.isHidden) {
                this.updateGlow();
                this.hitbox.update();
                if (InputHelper.justClickedLeft && this.hitbox.hovered) {
                    this.hitbox.clickStarted = true;
                    CardCrawlGame.sound.play("UI_CLICK_1");
                }
                if (this.hitbox.justHovered) {
                    CardCrawlGame.sound.play("UI_HOVER");
                }
                if (this.hitbox.clicked || InputHelper.pressedEscape && this.current_x != HIDE_X) {
                    InputHelper.pressedEscape = false;
                    this.hitbox.clicked = false;
                    this.hide();
                    if (CardCrawlGame.mode == CardCrawlGame.GameMode.CHAR_SELECT) {
                        this.hitbox.clicked = false;
                        if (CardCrawlGame.mainMenuScreen.statsScreen.screenUp) {
                            CardCrawlGame.mainMenuScreen.statsScreen.hide();
                            return;
                        }
                        if (CardCrawlGame.mainMenuScreen.trial.screenUp) {
                            CardCrawlGame.mainMenuScreen.trial.hide();
                            return;
                        }
                        if (CardCrawlGame.mainMenuScreen.isSettingsUp) {
                            CardCrawlGame.mainMenuScreen.isSettingsUp = false;
                            CardCrawlGame.mainMenuScreen.screen = MainMenuScreen.CurScreen.MAIN_MENU;
                            this.hide();
                            return;
                        }
                        if (this.buttonText.equals(TEXT[0])) {
                            return;
                        }
                    }
                    if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.MAP) {
                        CardCrawlGame.sound.play("MAP_CLOSE", 0.05f);
                    }
                    if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.GRID && (AbstractDungeon.gridSelectScreen.forUpgrade || AbstractDungeon.gridSelectScreen.forTransform || AbstractDungeon.gridSelectScreen.forPurge)) {
                        if (AbstractDungeon.gridSelectScreen.confirmScreenUp) {
                            AbstractDungeon.gridSelectScreen.cancelUpgrade();
                            break block17;
                        } else {
                            AbstractDungeon.closeCurrentScreen();
                            if (AbstractDungeon.getCurrRoom() instanceof RestRoom) {
                                RestRoom r = (RestRoom)AbstractDungeon.getCurrRoom();
                                r.campfireUI.reopen();
                            }
                            return;
                        }
                    }
                    if (AbstractDungeon.getCurrRoom() instanceof TreasureRoomBoss && AbstractDungeon.screen == AbstractDungeon.CurrentScreen.BOSS_REWARD) {
                        TreasureRoomBoss r = (TreasureRoomBoss)AbstractDungeon.getCurrRoom();
                        r.chest.close();
                    }
                    AbstractDungeon.closeCurrentScreen();
                }
            }
        }
        if (this.current_x != this.target_x) {
            this.current_x = MathUtils.lerp(this.current_x, this.target_x, Gdx.graphics.getDeltaTime() * 9.0f);
            if (Math.abs(this.current_x - this.target_x) < Settings.UI_SNAP_THRESHOLD) {
                this.current_x = this.target_x;
            }
        }
    }

    private void updateGlow() {
        float tmp;
        this.glowAlpha += Gdx.graphics.getDeltaTime() * 3.0f;
        if (this.glowAlpha < 0.0f) {
            this.glowAlpha *= -1.0f;
        }
        this.glowColor.a = (tmp = MathUtils.cos(this.glowAlpha)) < 0.0f ? -tmp / 2.0f + 0.3f : tmp / 2.0f + 0.3f;
    }

    public boolean hovered() {
        return this.hitbox.hovered;
    }

    public void hide() {
        if (!this.isHidden) {
            this.hitbox.hovered = false;
            InputHelper.justClickedLeft = false;
            this.target_x = HIDE_X;
            this.isHidden = true;
        }
    }

    public void hideInstantly() {
        if (!this.isHidden) {
            this.hitbox.hovered = false;
            InputHelper.justClickedLeft = false;
            this.current_x = this.target_x = HIDE_X;
            this.isHidden = true;
        }
    }

    public void show(String buttonText) {
        if (this.isHidden) {
            this.glowAlpha = 0.0f;
            this.current_x = HIDE_X;
            this.target_x = SHOW_X;
            this.isHidden = false;
            this.buttonText = buttonText;
        } else {
            this.current_x = HIDE_X;
            this.buttonText = buttonText;
        }
        this.hitbox.hovered = false;
    }

    public void render(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        this.renderShadow(sb);
        sb.setColor(this.glowColor);
        this.renderOutline(sb);
        sb.setColor(Color.WHITE);
        this.renderButton(sb);
        if (this.hitbox.hovered && !this.hitbox.clickStarted) {
            sb.setBlendFunction(770, 1);
            sb.setColor(HOVER_BLEND_COLOR);
            this.renderButton(sb);
            sb.setBlendFunction(770, 771);
        }
        if (this.hitbox.clickStarted) {
            FontHelper.renderFontCentered(sb, FontHelper.buttonLabelFont, this.buttonText, this.current_x + TEXT_OFFSET_X, DRAW_Y + TEXT_OFFSET_Y, Color.LIGHT_GRAY);
        } else {
            FontHelper.renderFontCentered(sb, FontHelper.buttonLabelFont, this.buttonText, this.current_x + TEXT_OFFSET_X, DRAW_Y + TEXT_OFFSET_Y, Settings.LIGHT_YELLOW_COLOR);
        }
        if (!this.isHidden) {
            this.hitbox.render(sb);
        }
    }

    private void renderShadow(SpriteBatch sb) {
        sb.draw(ImageMaster.CANCEL_BUTTON_SHADOW, this.current_x - 256.0f, DRAW_Y - 128.0f, 256.0f, 128.0f, 512.0f, 256.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 512, 256, false, false);
    }

    private void renderOutline(SpriteBatch sb) {
        sb.draw(ImageMaster.CANCEL_BUTTON_OUTLINE, this.current_x - 256.0f, DRAW_Y - 128.0f, 256.0f, 128.0f, 512.0f, 256.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 512, 256, false, false);
    }

    private void renderButton(SpriteBatch sb) {
        sb.draw(ImageMaster.CANCEL_BUTTON, this.current_x - 256.0f, DRAW_Y - 128.0f, 256.0f, 128.0f, 512.0f, 256.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 512, 256, false, false);
    }
}

