/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.shop;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.potions.AbstractPotion;
import com.megacrit.cardcrawl.potions.PotionPlaceholder;
import com.megacrit.cardcrawl.shop.ShopScreen;

public class StorePotion {
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("StorePotion");
    public static final String[] TEXT = StorePotion.uiStrings.TEXT;
    private AbstractPotion potion;
    private ShopScreen shopScreen;
    public int price;
    private int slot;
    private Hitbox hb = new Hitbox(120.0f * Settings.scale, 120.0f * Settings.scale);
    private static final float RELIC_GOLD_OFFSET_X = -56.0f * Settings.scale;
    private static final float RELIC_GOLD_OFFSET_Y = -100.0f * Settings.scale;
    private static final float RELIC_PRICE_OFFSET_X = 14.0f * Settings.scale;
    private static final float RELIC_PRICE_OFFSET_Y = -62.0f * Settings.scale;
    private static final float GOLD_IMG_WIDTH = (float)ImageMaster.UI_GOLD.getWidth() * Settings.scale;

    public StorePotion(AbstractPotion potion, int slot, ShopScreen screenRef) {
        this.potion = potion;
        this.price = potion.getPrice();
        this.slot = slot;
        this.shopScreen = screenRef;
    }

    public void update(float rugY) {
        if (this.potion != null) {
            this.potion.currentX = 1000.0f * Settings.scale + 150.0f * (float)this.slot * Settings.scale;
            this.potion.currentY = rugY + 200.0f * Settings.scale;
            this.potion.hb.move(this.potion.currentX, this.potion.currentY);
            this.potion.hb.update();
            if (this.potion.hb.hovered) {
                this.shopScreen.moveHand(this.potion.currentX - 190.0f * Settings.scale, this.potion.currentY - 70.0f * Settings.scale);
                if (InputHelper.justClickedLeft) {
                    this.potion.hb.clickStarted = true;
                }
            }
            if (this.potion.hb.clicked) {
                this.potion.hb.clicked = false;
                if (AbstractDungeon.player.gold >= this.price) {
                    for (int i = 0; i < 3; ++i) {
                        if (!(AbstractDungeon.player.potions[i] instanceof PotionPlaceholder)) continue;
                        CardCrawlGame.sound.play("POTION_1");
                        this.potion.moveInstantly(AbstractDungeon.player.potions[i].currentX, AbstractDungeon.player.potions[i].currentY);
                        this.potion.isObtained = true;
                        this.potion.isDone = true;
                        this.potion.isAnimating = false;
                        this.potion.flash();
                        AbstractDungeon.player.potions[i] = this.potion;
                        AbstractDungeon.player.loseGold(this.price);
                        CardCrawlGame.sound.play("SHOP_PURCHASE", 0.1f);
                        CardCrawlGame.metricData.items_purchased.add(this.potion.ID);
                        this.potion.hb.hovered = false;
                        this.shopScreen.playBuySfx();
                        this.shopScreen.createSpeech(ShopScreen.getBuyMsg());
                        if (AbstractDungeon.player.hasRelic("The Courier")) {
                            this.potion = AbstractDungeon.returnRandomPotion(15);
                            this.shopScreen.getNewPrice(this);
                        } else {
                            this.potion = null;
                        }
                        return;
                    }
                    this.shopScreen.createSpeech(TEXT[0]);
                    AbstractDungeon.topPanel.flashRed();
                } else {
                    this.shopScreen.playCantBuySfx();
                    this.shopScreen.createSpeech(ShopScreen.getCantBuyMsg());
                }
            }
        }
    }

    public void hide() {
        if (this.potion != null) {
            this.potion.currentY = (float)Settings.HEIGHT + 200.0f * Settings.scale;
        }
    }

    public void render(SpriteBatch sb) {
        if (this.potion != null) {
            this.potion.shopRender(sb);
            sb.setColor(Color.WHITE);
            sb.draw(ImageMaster.UI_GOLD, this.potion.currentX + RELIC_GOLD_OFFSET_X, this.potion.currentY + RELIC_GOLD_OFFSET_Y, GOLD_IMG_WIDTH, GOLD_IMG_WIDTH);
            Color color = Color.WHITE;
            if (this.price > AbstractDungeon.player.gold) {
                color = Color.SALMON;
            }
            FontHelper.renderFontLeftTopAligned(sb, FontHelper.tipHeaderFont, Integer.toString(this.price), this.potion.currentX + RELIC_PRICE_OFFSET_X, this.potion.currentY + RELIC_PRICE_OFFSET_Y, color);
            this.hb.render(sb);
        }
    }
}

