/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.stats;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.TipHelper;

public class AchievementItem {
    private Texture img;
    private static final String IMG_DIR = "images/achievements/";
    private static final String LOCKED_DIR = "locked/";
    private static final String UNLOCKED_DIR = "unlocked/";
    private static final int W = 160;
    private Hitbox hb = new Hitbox(160.0f * Settings.scale, 160.0f * Settings.scale);
    private String title;
    private String desc;
    private boolean isUnlocked;
    private static final Color LOCKED_COLOR = new Color(1.0f, 1.0f, 1.0f, 0.8f);

    public AchievementItem(String title, String desc, String imgUrl, boolean isUnlocked) {
        this.title = title;
        this.desc = desc;
        this.isUnlocked = isUnlocked;
        this.img = isUnlocked ? ImageMaster.loadImage("images/achievements/unlocked/" + imgUrl) : ImageMaster.loadImage("images/achievements/locked/" + imgUrl);
    }

    public void update() {
        this.hb.update();
        if (this.hb.hovered) {
            TipHelper.renderGenericTip((float)InputHelper.mX + 100.0f * Settings.scale, InputHelper.mY, this.title, this.desc);
        }
    }

    public void render(SpriteBatch sb, float x, float y) {
        if (!this.isUnlocked) {
            sb.setColor(LOCKED_COLOR);
        } else {
            sb.setColor(Color.WHITE);
        }
        if (this.hb.hovered) {
            sb.draw(this.img, x - 80.0f, y - 80.0f, 80.0f, 80.0f, 160.0f, 160.0f, Settings.scale * 1.1f, Settings.scale * 1.1f, 0.0f, 0, 0, 160, 160, false, false);
        } else {
            sb.draw(this.img, x - 80.0f, y - 80.0f, 80.0f, 80.0f, 160.0f, 160.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 160, 160, false, false);
        }
        this.hb.move(x, y);
        this.hb.render(sb);
    }
}

