/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.options;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.screens.options.ConfirmPopup;
import com.megacrit.cardcrawl.screens.options.OptionsPanel;
import com.megacrit.cardcrawl.screens.saveAndContinue.SaveAndContinue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SettingsScreen {
    private static final Logger logger = LogManager.getLogger(SettingsScreen.class.getName());
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("SettingsScreen");
    public static final String[] TEXT = SettingsScreen.uiStrings.TEXT;
    public OptionsPanel panel = new OptionsPanel();
    public ConfirmPopup exitPopup = new ConfirmPopup(TEXT[0], TEXT[1], ConfirmPopup.ConfirmType.EXIT);
    public ConfirmPopup abandonPopup = new ConfirmPopup(TEXT[0], TEXT[2], ConfirmPopup.ConfirmType.ABANDON);
    private static final String NOT_SAVED_MSG = TEXT[3];

    public void update() {
        if (!this.exitPopup.shown && !this.abandonPopup.shown) {
            this.panel.update();
        }
        this.exitPopup.update();
        this.abandonPopup.update();
    }

    public void open() {
        AbstractDungeon.player.releaseCard();
        this.panel.refresh();
        AbstractDungeon.overlayMenu.cancelButton.show(TEXT[4]);
        CardCrawlGame.sound.play("UI_CLICK_1");
        AbstractDungeon.isScreenUp = true;
        AbstractDungeon.overlayMenu.showBlackScreen();
        AbstractDungeon.overlayMenu.proceedButton.hide();
        AbstractDungeon.overlayMenu.hideCombatPanels();
        AbstractDungeon.screen = AbstractDungeon.CurrentScreen.SETTINGS;
    }

    public void render(SpriteBatch sb) {
        this.panel.render(sb);
        this.exitPopup.render(sb);
        this.abandonPopup.render(sb);
    }

    public void popup(ConfirmPopup.ConfirmType type) {
        if (AbstractDungeon.overlayMenu != null) {
            AbstractDungeon.overlayMenu.cancelButton.hide();
        }
        switch (type) {
            case ABANDON: {
                this.abandonPopup.show();
                break;
            }
            case EXIT: {
                if (Settings.isDailyRun) {
                    this.exitPopup.desc = TEXT[5];
                } else {
                    this.exitPopup.desc = TEXT[1];
                    switch (AbstractDungeon.player.chosenClass) {
                        case IRONCLAD: {
                            if (Gdx.files.local(SaveAndContinue.IRONCLAD_FILE).exists()) break;
                            this.exitPopup.desc = NOT_SAVED_MSG;
                            break;
                        }
                        case THE_SILENT: {
                            if (Gdx.files.local(SaveAndContinue.THE_SILENT_FILE).exists()) break;
                            this.exitPopup.desc = NOT_SAVED_MSG;
                            break;
                        }
                        case CROWBOT: {
                            if (Gdx.files.local(SaveAndContinue.CROWBOT_FILE).exists()) break;
                            this.exitPopup.desc = NOT_SAVED_MSG;
                            break;
                        }
                        default: {
                            System.out.print(AbstractDungeon.player.chosenClass.toString() + " NOT FOUND IN CONFIRMPOPUP()");
                        }
                    }
                }
                this.exitPopup.show();
                break;
            }
            default: {
                logger.info("Unspecified case: " + type.name());
            }
        }
    }
}

