/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.mainMenu;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.GameCursor;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.CardLibrary;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.screens.SingleCardViewPopup;
import com.megacrit.cardcrawl.screens.mainMenu.CardLibSortHeader;
import com.megacrit.cardcrawl.screens.mainMenu.MainMenuScreen;
import com.megacrit.cardcrawl.screens.mainMenu.MenuCancelButton;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CardLibraryScreen {
    private static final Logger logger = LogManager.getLogger(CardLibraryScreen.class.getName());
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("CardLibraryScreen");
    public static final String[] TEXT = CardLibraryScreen.uiStrings.TEXT;
    private static float drawStartX;
    private static float drawStartY;
    private static float padX;
    private static float padY;
    private static final int CARDS_PER_LINE = 5;
    private boolean grabbedScreen = false;
    private float grabStartY = 0.0f;
    private float currentDiffY = 0.0f;
    private float scrollLowerBound = -Settings.DEFAULT_SCROLL_LIMIT;
    private float scrollUpperBound = Settings.DEFAULT_SCROLL_LIMIT;
    private AbstractCard hoveredCard = null;
    private AbstractCard clickStartedCard = null;
    public MenuCancelButton button = new MenuCancelButton();
    private CardGroup redCards = new CardGroup(CardGroup.CardGroupType.UNSPECIFIED);
    private CardGroup greenCards = new CardGroup(CardGroup.CardGroupType.UNSPECIFIED);
    private CardGroup blueCards = new CardGroup(CardGroup.CardGroupType.UNSPECIFIED);
    private CardGroup colorlessCards = new CardGroup(CardGroup.CardGroupType.UNSPECIFIED);
    private CardGroup curseCards = new CardGroup(CardGroup.CardGroupType.UNSPECIFIED);
    private CardGroup statusCards = new CardGroup(CardGroup.CardGroupType.UNSPECIFIED);
    private ArrayList<CardLibSortHeader> headers = new ArrayList();
    private CardLibSortHeader redHeader;
    private CardLibSortHeader greenHeader;
    private CardLibSortHeader blueHeader;
    private CardLibSortHeader colorlessHeader;
    private CardLibSortHeader curseHeader;
    private CardLibSortHeader statusHeader;
    private Hitbox upgradeHb = new Hitbox(250.0f * Settings.scale, 80.0f * Settings.scale);

    public CardLibraryScreen() {
        drawStartX = Settings.WIDTH;
        drawStartX -= 5.0f * AbstractCard.IMG_WIDTH * 0.75f;
        drawStartX -= 4.0f * Settings.CARD_VIEW_PAD_X;
        drawStartX /= 2.0f;
        drawStartX += AbstractCard.IMG_WIDTH * 0.75f / 2.0f;
        padX = AbstractCard.IMG_WIDTH * 0.75f + Settings.CARD_VIEW_PAD_X;
        padY = AbstractCard.IMG_HEIGHT * 0.75f + Settings.CARD_VIEW_PAD_Y;
    }

    public void initialize() {
        logger.info("Initializing card library screen.");
        this.redCards.group = CardLibrary.getCardList(CardLibrary.LibraryType.RED);
        this.redHeader = new CardLibSortHeader(this.redCards);
        this.headers.add(this.redHeader);
        if (!UnlockTracker.isCharacterLocked("The Silent")) {
            this.greenCards.group = CardLibrary.getCardList(CardLibrary.LibraryType.GREEN);
            this.greenHeader = new CardLibSortHeader(this.greenCards);
            this.headers.add(this.greenHeader);
        }
        if (!UnlockTracker.isCharacterLocked("Crowbot")) {
            this.blueCards.group = CardLibrary.getCardList(CardLibrary.LibraryType.BLUE);
            this.blueHeader = new CardLibSortHeader(this.blueCards);
            this.headers.add(this.blueHeader);
        }
        this.colorlessCards.group = CardLibrary.getCardList(CardLibrary.LibraryType.COLORLESS);
        this.colorlessHeader = new CardLibSortHeader(this.colorlessCards);
        this.headers.add(this.colorlessHeader);
        this.curseCards.group = CardLibrary.getCardList(CardLibrary.LibraryType.CURSE);
        this.curseHeader = new CardLibSortHeader(this.curseCards);
        this.headers.add(this.curseHeader);
        this.statusCards.group = CardLibrary.getCardList(CardLibrary.LibraryType.STATUS);
        this.statusHeader = new CardLibSortHeader(this.statusCards);
        this.headers.add(this.statusHeader);
        this.calculateScrollBounds();
    }

    private void setLockStatus() {
        this.lockStatusHelper(this.redCards);
        this.lockStatusHelper(this.greenCards);
        this.lockStatusHelper(this.colorlessCards);
        this.lockStatusHelper(this.curseCards);
    }

    private void lockStatusHelper(CardGroup group) {
        ArrayList<AbstractCard> toAdd = new ArrayList<AbstractCard>();
        Iterator<AbstractCard> i = group.group.iterator();
        while (i.hasNext()) {
            AbstractCard c = i.next();
            if (!UnlockTracker.isCardLocked(c.cardID)) continue;
            AbstractCard tmp = CardLibrary.getCopy(c.cardID);
            tmp.setLocked();
            toAdd.add(tmp);
            i.remove();
        }
        group.group.addAll(toAdd);
    }

    public void open() {
        if (Settings.isInfo) {
            CardLibrary.unlockAndSeeAllCards();
        }
        CardCrawlGame.sound.play("DECK_OPEN");
        this.setLockStatus();
        this.sortOnOpen();
        this.button.show(TEXT[0]);
        CardCrawlGame.mainMenuScreen.darken();
        this.currentDiffY = -200.0f;
        for (AbstractCard c : this.redCards.group) {
            c.drawScale = MathUtils.random(0.2f, 0.4f);
            c.targetDrawScale = 0.75f;
        }
        for (AbstractCard c : this.greenCards.group) {
            c.drawScale = MathUtils.random(0.2f, 0.4f);
            c.targetDrawScale = 0.75f;
        }
        SingleCardViewPopup.isViewingUpgrade = false;
        this.upgradeHb.move((float)Settings.WIDTH - 160.0f * Settings.scale, 70.0f * Settings.scale);
    }

    private void sortOnOpen() {
        this.redHeader.justSorted = true;
        this.redCards.sortAlphabetically(false);
        this.redCards.sortByRarity(false);
        this.redCards.sortByStatus(false);
        if (this.greenHeader != null) {
            this.greenHeader.justSorted = true;
            this.greenCards.sortAlphabetically(false);
            this.greenCards.sortByRarity(false);
            this.greenCards.sortByStatus(false);
        }
        if (this.blueHeader != null) {
            this.blueHeader.justSorted = true;
            this.blueCards.sortAlphabetically(false);
            this.blueCards.sortByRarity(false);
            this.blueCards.sortByStatus(false);
        }
        this.colorlessHeader.justSorted = true;
        this.colorlessCards.sortAlphabetically(false);
        this.colorlessCards.sortByRarity(false);
        this.colorlessCards.sortByStatus(false);
        this.curseHeader.justSorted = true;
        this.curseCards.sortAlphabetically(false);
        this.curseCards.sortByStatus(false);
        this.statusHeader.justSorted = true;
        this.statusCards.sortAlphabetically(false);
        this.statusCards.sortByRarity(false);
        this.statusCards.sortByStatus(false);
    }

    public void update() {
        for (CardLibSortHeader h : this.headers) {
            if (h == null) continue;
            h.update();
        }
        if (this.hoveredCard != null) {
            CardCrawlGame.cursor.changeType(GameCursor.CursorType.INSPECT);
            if (InputHelper.justClickedLeft) {
                this.clickStartedCard = this.hoveredCard;
            }
            if (InputHelper.justReleasedClickLeft && this.clickStartedCard != null && this.hoveredCard != null) {
                InputHelper.justReleasedClickLeft = false;
                CardGroup tmpGroup = null;
                switch (this.clickStartedCard.color) {
                    case RED: {
                        tmpGroup = this.redCards;
                        break;
                    }
                    case GREEN: {
                        tmpGroup = this.greenCards;
                        break;
                    }
                    case BLUE: {
                        tmpGroup = this.blueCards;
                        break;
                    }
                    case COLORLESS: {
                        if (this.clickStartedCard.type == AbstractCard.CardType.STATUS) {
                            tmpGroup = this.statusCards;
                            break;
                        }
                        tmpGroup = this.colorlessCards;
                        break;
                    }
                    case CURSE: {
                        tmpGroup = this.curseCards;
                    }
                }
                CardCrawlGame.cardPopup.open(this.clickStartedCard, tmpGroup);
                this.clickStartedCard = null;
            }
        } else {
            this.clickStartedCard = null;
        }
        if (!CardCrawlGame.cardPopup.isOpen) {
            this.updateScrolling();
        }
        this.updateCards();
        this.updateUpgradePreview();
        this.button.update();
        if (this.button.hb.clicked || InputHelper.pressedEscape) {
            InputHelper.pressedEscape = false;
            this.button.hb.clicked = false;
            this.button.hide();
            CardCrawlGame.mainMenuScreen.lighten();
            CardCrawlGame.mainMenuScreen.screen = MainMenuScreen.CurScreen.MAIN_MENU;
        }
    }

    private void updateUpgradePreview() {
        this.upgradeHb.update();
        if (this.upgradeHb.hovered && InputHelper.justClickedLeft) {
            this.upgradeHb.clickStarted = true;
        }
        if (this.upgradeHb.clicked) {
            this.upgradeHb.clicked = false;
            SingleCardViewPopup.isViewingUpgrade = !SingleCardViewPopup.isViewingUpgrade;
        }
    }

    private void updateCards() {
        int mod;
        int i;
        this.hoveredCard = null;
        int lineNum = 0;
        ArrayList<AbstractCard> cards = this.redCards.group;
        for (i = 0; i < cards.size(); ++i) {
            mod = i % 5;
            if (mod == 0 && i != 0) {
                ++lineNum;
            }
            cards.get((int)i).target_x = drawStartX + (float)mod * padX;
            cards.get((int)i).target_y = drawStartY + this.currentDiffY - (float)lineNum * padY;
            cards.get(i).update();
            cards.get(i).updateHoverLogic();
            if (!cards.get((int)i).hb.hovered) continue;
            this.hoveredCard = cards.get(i);
        }
        if (this.redHeader.justSorted) {
            for (AbstractCard c : cards) {
                c.current_x = c.target_x;
                c.current_y = c.target_y;
            }
            this.redHeader.justSorted = false;
        }
        if (this.greenHeader != null) {
            lineNum += 2;
            cards = this.greenCards.group;
            for (i = 0; i < cards.size(); ++i) {
                mod = i % 5;
                if (mod == 0 && i != 0) {
                    ++lineNum;
                }
                cards.get((int)i).target_x = drawStartX + (float)mod * padX;
                cards.get((int)i).target_y = drawStartY + this.currentDiffY - (float)lineNum * padY;
                cards.get(i).update();
                cards.get(i).updateHoverLogic();
                if (!cards.get((int)i).hb.hovered) continue;
                this.hoveredCard = cards.get(i);
            }
            if (this.greenHeader != null && this.greenHeader.justSorted) {
                for (AbstractCard c : cards) {
                    c.current_x = c.target_x;
                    c.current_y = c.target_y;
                }
                this.greenHeader.justSorted = false;
            }
        }
        if (this.blueHeader != null) {
            lineNum += 2;
            cards = this.blueCards.group;
            for (int i2 = 0; i2 < cards.size(); ++i2) {
                int mod2 = i2 % 5;
                if (mod2 == 0 && i2 != 0) {
                    ++lineNum;
                }
                cards.get((int)i2).target_x = drawStartX + (float)mod2 * padX;
                cards.get((int)i2).target_y = drawStartY + this.currentDiffY - (float)lineNum * padY;
                cards.get(i2).update();
                cards.get(i2).updateHoverLogic();
                if (!cards.get((int)i2).hb.hovered) continue;
                this.hoveredCard = cards.get(i2);
            }
            if (this.blueHeader != null && this.blueHeader.justSorted) {
                for (AbstractCard c : cards) {
                    c.current_x = c.target_x;
                    c.current_y = c.target_y;
                }
                this.blueHeader.justSorted = false;
            }
        }
        lineNum += 2;
        cards = this.colorlessCards.group;
        for (int i3 = 0; i3 < cards.size(); ++i3) {
            int mod3 = i3 % 5;
            if (mod3 == 0 && i3 != 0) {
                ++lineNum;
            }
            cards.get((int)i3).target_x = drawStartX + (float)mod3 * padX;
            cards.get((int)i3).target_y = drawStartY + this.currentDiffY - (float)lineNum * padY;
            cards.get(i3).update();
            cards.get(i3).updateHoverLogic();
            if (!cards.get((int)i3).hb.hovered) continue;
            this.hoveredCard = cards.get(i3);
        }
        if (this.colorlessHeader.justSorted) {
            for (AbstractCard c : cards) {
                c.current_x = c.target_x;
                c.current_y = c.target_y;
            }
            this.colorlessHeader.justSorted = false;
        }
        lineNum += 2;
        cards = this.curseCards.group;
        for (int i4 = 0; i4 < cards.size(); ++i4) {
            int mod4 = i4 % 5;
            if (mod4 == 0 && i4 != 0) {
                ++lineNum;
            }
            cards.get((int)i4).target_x = drawStartX + (float)mod4 * padX;
            cards.get((int)i4).target_y = drawStartY + this.currentDiffY - (float)lineNum * padY;
            cards.get(i4).update();
            cards.get(i4).updateHoverLogic();
            if (!cards.get((int)i4).hb.hovered) continue;
            this.hoveredCard = cards.get(i4);
        }
        if (this.curseHeader.justSorted) {
            for (AbstractCard c : cards) {
                c.current_x = c.target_x;
                c.current_y = c.target_y;
            }
            this.curseHeader.justSorted = false;
        }
        lineNum += 2;
        cards = this.statusCards.group;
        for (int i5 = 0; i5 < cards.size(); ++i5) {
            int mod5 = i5 % 5;
            if (mod5 == 0 && i5 != 0) {
                ++lineNum;
            }
            cards.get((int)i5).target_x = drawStartX + (float)mod5 * padX;
            cards.get((int)i5).target_y = drawStartY + this.currentDiffY - (float)lineNum * padY;
            cards.get(i5).update();
            cards.get(i5).updateHoverLogic();
            if (!cards.get((int)i5).hb.hovered) continue;
            this.hoveredCard = cards.get(i5);
        }
        if (this.statusHeader.justSorted) {
            for (AbstractCard c : cards) {
                c.current_x = c.target_x;
                c.current_y = c.target_y;
            }
            this.statusHeader.justSorted = false;
        }
    }

    private void updateScrolling() {
        int y = InputHelper.mY;
        if (!this.grabbedScreen) {
            if (InputHelper.scrolledDown) {
                this.currentDiffY += Settings.SCROLL_SPEED;
            } else if (InputHelper.scrolledUp) {
                this.currentDiffY -= Settings.SCROLL_SPEED;
            }
            if (InputHelper.justClickedLeft) {
                this.grabbedScreen = true;
                this.grabStartY = (float)y - this.currentDiffY;
            }
        } else if (InputHelper.isMouseDown) {
            this.currentDiffY = (float)y - this.grabStartY;
        } else {
            this.grabbedScreen = false;
        }
        this.resetScrolling();
    }

    private void calculateScrollBounds() {
        int size = this.redCards.size() + this.greenCards.size() + this.blueCards.size() + this.colorlessCards.size() + this.curseCards.size() + this.statusCards.size() + 25;
        if (this.greenCards.size() != 0) {
            size += 5;
        }
        if (this.blueCards.size() != 0) {
            size += 5;
        }
        int scrollTmp = 0;
        if (size > 10) {
            scrollTmp = size / 5 - 2;
            if (size % 5 != 0) {
                ++scrollTmp;
            }
            this.scrollUpperBound = Settings.DEFAULT_SCROLL_LIMIT + (float)scrollTmp * padY;
        } else {
            this.scrollUpperBound = Settings.DEFAULT_SCROLL_LIMIT;
        }
    }

    private void resetScrolling() {
        if (this.currentDiffY < this.scrollLowerBound) {
            this.currentDiffY = MathHelper.scrollSnapLerpSpeed(this.currentDiffY, this.scrollLowerBound);
        } else if (this.currentDiffY > this.scrollUpperBound) {
            this.currentDiffY = MathHelper.scrollSnapLerpSpeed(this.currentDiffY, this.scrollUpperBound);
        }
    }

    public void render(SpriteBatch sb) {
        for (CardLibSortHeader h : this.headers) {
            h.render(sb);
        }
        this.renderGroup(sb, this.redCards, TEXT[1], "");
        if (this.greenHeader != null) {
            this.renderGroup(sb, this.greenCards, TEXT[2], "");
        }
        if (this.blueHeader != null) {
            this.renderGroup(sb, this.blueCards, TEXT[3], "");
        }
        this.renderGroup(sb, this.colorlessCards, TEXT[4], "");
        this.renderGroup(sb, this.curseCards, TEXT[5], "");
        this.renderGroup(sb, this.statusCards, TEXT[6], "");
        if (this.hoveredCard != null) {
            this.hoveredCard.renderHoverShadow(sb);
            this.hoveredCard.renderInLibrary(sb);
        }
        this.renderUpgradeViewToggle(sb);
        this.button.render(sb);
    }

    private void renderUpgradeViewToggle(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        sb.draw(ImageMaster.OPTION_TOGGLE, 1670.0f * Settings.scale - 16.0f, 70.0f * Settings.scale - 16.0f, 16.0f, 16.0f, 32.0f, 32.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 32, 32, false, false);
        if (this.upgradeHb.hovered && !SingleCardViewPopup.isViewingUpgrade) {
            FontHelper.renderFont(sb, FontHelper.cardTitleFont_N, TEXT[7], 1700.0f * Settings.scale, 80.0f * Settings.scale, Settings.BLUE_TEXT_COLOR);
        } else {
            FontHelper.renderFont(sb, FontHelper.cardTitleFont_N, TEXT[7], 1700.0f * Settings.scale, 80.0f * Settings.scale, Settings.GOLD_COLOR);
        }
        if (SingleCardViewPopup.isViewingUpgrade) {
            sb.setColor(Color.WHITE);
            sb.draw(ImageMaster.OPTION_TOGGLE_ON, 1670.0f * Settings.scale - 16.0f, 70.0f * Settings.scale - 16.0f, 16.0f, 16.0f, 32.0f, 32.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 32, 32, false, false);
        }
        this.upgradeHb.render(sb);
    }

    private void renderGroup(SpriteBatch sb, CardGroup group, String header, String desc) {
        group.renderInLibrary(sb);
        group.renderTip(sb);
        this.renderHeader(sb, header, desc, group.getBottomCard().current_y);
    }

    private void renderHeader(SpriteBatch sb, String msg, String desc, float y) {
        FontHelper.renderSmartText(sb, FontHelper.bannerFont, msg, 320.0f * Settings.scale, y + 240.0f * Settings.scale, 99999.0f, 0.0f, Settings.GOLD_COLOR);
        FontHelper.renderSmartText(sb, FontHelper.cardDescFont_N, desc, 320.0f * Settings.scale + FontHelper.getSmartWidth(FontHelper.buttonLabelFont, msg, 99999.0f, 0.0f), y + 236.0f * Settings.scale, 99999.0f, 0.0f, Settings.CREAM_COLOR);
    }

    static {
        drawStartY = (float)Settings.HEIGHT * 0.66f;
    }
}

