/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.charSelect;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.characters.Crowbot;
import com.megacrit.cardcrawl.characters.Ironclad;
import com.megacrit.cardcrawl.characters.TheSilent;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.helpers.RelicLibrary;
import com.megacrit.cardcrawl.helpers.ScreenShake;
import com.megacrit.cardcrawl.helpers.TipHelper;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.screens.CharSelectInfo;
import com.megacrit.cardcrawl.unlock.UnlockTracker;

public class CharacterOption {
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("CharacterOption");
    public static final String[] TEXT = CharacterOption.uiStrings.TEXT;
    private Texture buttonImg;
    private String portraitUrl;
    public AbstractPlayer.PlayerClass c;
    public boolean selected = false;
    public boolean locked = false;
    public Hitbox hb;
    private static final float HB_W = 150.0f * Settings.scale;
    private static final int BUTTON_W = 220;
    private static final String ASSETS_DIR = "images/ui/charSelect/";
    private static final Color BLACK_OUTLINE_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.5f);
    private static final int ICON_W = 64;
    private static final float DEST_INFO_X = 200.0f * Settings.scale;
    private static final float START_INFO_X = -600.0f * Settings.scale;
    private static final float START_INFO_Y = (float)Settings.HEIGHT / 2.0f;
    private float infoX = START_INFO_X;
    private float infoY = START_INFO_Y;
    public String name = "";
    private static final float NAME_OFFSET_Y = 200.0f * Settings.scale;
    private String hp;
    private int gold;
    private String flavorText;
    private CharSelectInfo charInfo;
    private int unlocksRemaining;

    public CharacterOption(String optionName, AbstractPlayer.PlayerClass c, String buttonUrl, String portraitImg) {
        this.name = optionName;
        this.hb = new Hitbox(HB_W, HB_W);
        this.buttonImg = ImageMaster.loadImage(ASSETS_DIR + buttonUrl);
        this.portraitUrl = portraitImg;
        this.c = c;
        this.charInfo = null;
        switch (c) {
            case IRONCLAD: {
                this.charInfo = Ironclad.getLoadout();
                break;
            }
            case THE_SILENT: {
                this.charInfo = TheSilent.getLoadout();
                break;
            }
            case CROWBOT: {
                this.charInfo = Crowbot.getLoadout();
                break;
            }
        }
        this.hp = this.charInfo.hp;
        this.gold = this.charInfo.gold;
        this.flavorText = this.charInfo.flavorText;
        this.unlocksRemaining = 6 - UnlockTracker.getUnlockLevel(c);
    }

    public CharacterOption(AbstractPlayer.PlayerClass c) {
        this.hb = new Hitbox(HB_W, HB_W);
        this.buttonImg = ImageMaster.loadImage("images/ui/charSelect/lockedButton.png");
        this.locked = true;
        this.c = c;
    }

    public void move(float x, float y) {
        this.hb.move(x, y);
    }

    public void update() {
        this.updateHitbox();
        this.updateInfoPosition();
    }

    private void updateHitbox() {
        this.hb.update();
        if (this.hb.justHovered) {
            CardCrawlGame.sound.playA("UI_HOVER", -0.3f);
        }
        if (this.hb.hovered && this.locked) {
            if (this.c == AbstractPlayer.PlayerClass.THE_SILENT) {
                TipHelper.renderGenericTip((float)InputHelper.mX + 70.0f * Settings.scale, (float)InputHelper.mY - 10.0f * Settings.scale, TEXT[0], TEXT[1]);
            } else if (this.c == AbstractPlayer.PlayerClass.CROWBOT) {
                if (!Settings.isBeta) {
                    TipHelper.renderGenericTip((float)InputHelper.mX + 70.0f * Settings.scale, (float)InputHelper.mY - 10.0f * Settings.scale, TEXT[0], TEXT[2]);
                } else {
                    TipHelper.renderGenericTip((float)InputHelper.mX + 70.0f * Settings.scale, (float)InputHelper.mY - 10.0f * Settings.scale, TEXT[0], TEXT[2]);
                }
            }
        }
        if (InputHelper.justClickedLeft && !this.locked && this.hb.hovered) {
            CardCrawlGame.sound.playA("UI_CLICK_1", -0.4f);
            this.hb.clickStarted = true;
        }
        if (this.hb.clicked) {
            this.hb.clicked = false;
            if (!this.selected) {
                CardCrawlGame.mainMenuScreen.charSelectScreen.deselectOtherOptions(this);
                this.selected = true;
                CardCrawlGame.mainMenuScreen.charSelectScreen.justSelected();
                CardCrawlGame.chosenCharacter = this.c;
                CardCrawlGame.mainMenuScreen.charSelectScreen.confirmButton.isDisabled = false;
                CardCrawlGame.mainMenuScreen.charSelectScreen.confirmButton.show();
                CardCrawlGame.mainMenuScreen.charSelectScreen.bgCharImg = ImageMaster.loadImage(ASSETS_DIR + this.portraitUrl);
                switch (this.c) {
                    case IRONCLAD: {
                        CardCrawlGame.sound.playA("ATTACK_HEAVY", MathUtils.random(-0.2f, 0.2f));
                        CardCrawlGame.screenShake.shake(ScreenShake.ShakeIntensity.MED, ScreenShake.ShakeDur.SHORT, true);
                        break;
                    }
                    case THE_SILENT: {
                        CardCrawlGame.sound.playA("ATTACK_DAGGER_2", MathUtils.random(-0.2f, 0.2f));
                        CardCrawlGame.screenShake.shake(ScreenShake.ShakeIntensity.MED, ScreenShake.ShakeDur.SHORT, false);
                        break;
                    }
                    case CROWBOT: {
                        CardCrawlGame.sound.playA("ATTACK_HEAVY", MathUtils.random(-0.2f, 0.2f));
                        break;
                    }
                }
            }
        }
    }

    private void updateInfoPosition() {
        this.infoX = this.selected ? MathHelper.uiLerpSnap(this.infoX, DEST_INFO_X) : MathHelper.uiLerpSnap(this.infoX, START_INFO_X);
    }

    public void render(SpriteBatch sb) {
        this.renderOptionButton(sb);
        this.renderInfo(sb);
        this.hb.render(sb);
    }

    private void renderOptionButton(SpriteBatch sb) {
        if (this.selected) {
            sb.setColor(new Color(1.0f, 0.8f, 0.2f, 0.25f + (MathUtils.cosDeg(System.currentTimeMillis() / 4L % 360L) + 1.25f) / 3.5f));
        } else {
            sb.setColor(BLACK_OUTLINE_COLOR);
        }
        sb.draw(ImageMaster.CHAR_OPT_HIGHLIGHT, this.hb.cX - 110.0f, this.hb.cY - 110.0f, 110.0f, 110.0f, 220.0f, 220.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 220, 220, false, false);
        if (this.selected || this.hb.hovered) {
            sb.setColor(Color.WHITE);
        } else {
            sb.setColor(Color.LIGHT_GRAY);
        }
        sb.draw(this.buttonImg, this.hb.cX - 110.0f, this.hb.cY - 110.0f, 110.0f, 110.0f, 220.0f, 220.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 220, 220, false, false);
    }

    private void renderInfo(SpriteBatch sb) {
        if (!this.name.equals("")) {
            FontHelper.renderSmartText(sb, FontHelper.bannerNameFont, this.name, this.infoX - 35.0f * Settings.scale, this.infoY + NAME_OFFSET_Y, 99999.0f, 38.0f * Settings.scale, Settings.GOLD_COLOR.cpy());
            sb.draw(ImageMaster.TP_HP, this.infoX - 10.0f * Settings.scale - 32.0f, this.infoY + 95.0f * Settings.scale - 32.0f, 32.0f, 32.0f, 64.0f, 64.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 64, 64, false, false);
            FontHelper.renderSmartText(sb, FontHelper.tipHeaderFont, TEXT[4] + this.hp, this.infoX + 18.0f * Settings.scale, this.infoY + 102.0f * Settings.scale, 10000.0f, 10000.0f, Settings.RED_TEXT_COLOR);
            sb.draw(ImageMaster.TP_GOLD, this.infoX + 190.0f * Settings.scale - 32.0f, this.infoY + 95.0f * Settings.scale - 32.0f, 32.0f, 32.0f, 64.0f, 64.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 64, 64, false, false);
            FontHelper.renderSmartText(sb, FontHelper.tipHeaderFont, TEXT[5] + Integer.toString(this.gold), this.infoX + 220.0f * Settings.scale, this.infoY + 102.0f * Settings.scale, 10000.0f, 10000.0f, Settings.GOLD_COLOR);
            FontHelper.renderSmartText(sb, FontHelper.tipHeaderFont, this.flavorText, this.infoX - 26.0f * Settings.scale, this.infoY + 40.0f * Settings.scale, 10000.0f, 30.0f * Settings.scale, Settings.CREAM_COLOR);
            if (this.unlocksRemaining > 0) {
                FontHelper.renderSmartText(sb, FontHelper.tipHeaderFont, Integer.toString(this.unlocksRemaining) + TEXT[6], this.infoX - 26.0f * Settings.scale, this.infoY - 112.0f * Settings.scale, 10000.0f, 10000.0f, Settings.CREAM_COLOR);
            }
            this.renderRelics(sb);
        }
    }

    private void renderRelics(SpriteBatch sb) {
        if (this.charInfo.relics.size() == 1) {
            sb.setColor(new Color(0.0f, 0.0f, 0.0f, 0.25f));
            sb.draw(RelicLibrary.getRelic((String)this.charInfo.relics.get((int)0)).outlineImg, this.infoX - 64.0f, this.infoY - 60.0f * Settings.scale - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 128, 128, false, false);
            sb.setColor(Color.WHITE);
            sb.draw(RelicLibrary.getRelic((String)this.charInfo.relics.get((int)0)).img, this.infoX - 64.0f, this.infoY - 60.0f * Settings.scale - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 128, 128, false, false);
            FontHelper.renderSmartText(sb, FontHelper.tipHeaderFont, this.charInfo.relics.get(0), this.infoX + 44.0f * Settings.scale, this.infoY - 40.0f * Settings.scale, 10000.0f, 10000.0f, Settings.GOLD_COLOR);
            String relicString = RelicLibrary.getRelic((String)this.charInfo.relics.get((int)0)).description;
            if (this.charInfo.name.equals(TEXT[7])) {
                relicString = TEXT[8];
            }
            FontHelper.renderSmartText(sb, FontHelper.tipBodyFont, relicString, this.infoX + 44.0f * Settings.scale, this.infoY - 66.0f * Settings.scale, 10000.0f, 10000.0f, Settings.CREAM_COLOR);
        } else {
            for (int i = 0; i < this.charInfo.relics.size(); ++i) {
                AbstractRelic r = RelicLibrary.getRelic(this.charInfo.relics.get(i));
                r.updateDescription(this.charInfo.color);
                Hitbox relicHitbox = new Hitbox(-1000.0f, -1000.0f, 80.0f * Settings.scale * (0.01f + (1.0f - 0.019f * (float)this.charInfo.relics.size())), 80.0f * Settings.scale);
                relicHitbox.move(this.infoX + (float)i * 72.0f * Settings.scale * (0.01f + (1.0f - 0.019f * (float)this.charInfo.relics.size())), this.infoY - 60.0f * Settings.scale);
                relicHitbox.render(sb);
                relicHitbox.update();
                if (relicHitbox.hovered) {
                    if ((float)InputHelper.mX < 1400.0f * Settings.scale) {
                        TipHelper.queuePowerTips((float)InputHelper.mX + 60.0f * Settings.scale, (float)InputHelper.mY - 50.0f * Settings.scale, r.tips);
                    } else {
                        TipHelper.queuePowerTips((float)InputHelper.mX - 350.0f * Settings.scale, (float)InputHelper.mY - 50.0f * Settings.scale, r.tips);
                    }
                }
                sb.setColor(new Color(0.0f, 0.0f, 0.0f, 0.25f));
                sb.draw(r.outlineImg, this.infoX - 64.0f + (float)i * 72.0f * Settings.scale * (0.01f + (1.0f - 0.019f * (float)this.charInfo.relics.size())), this.infoY - 60.0f * Settings.scale - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, Settings.scale * (0.01f + (1.0f - 0.019f * (float)this.charInfo.relics.size())), Settings.scale * (0.01f + (1.0f - 0.019f * (float)this.charInfo.relics.size())), 0.0f, 0, 0, 128, 128, false, false);
                sb.setColor(Color.WHITE);
                sb.draw(r.img, this.infoX - 64.0f + (float)i * 72.0f * Settings.scale * (0.01f + (1.0f - 0.019f * (float)this.charInfo.relics.size())), this.infoY - 60.0f * Settings.scale - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, Settings.scale * (0.01f + (1.0f - 0.019f * (float)this.charInfo.relics.size())), Settings.scale * (0.01f + (1.0f - 0.019f * (float)this.charInfo.relics.size())), 0.0f, 0, 0, 128, 128, false, false);
            }
        }
    }
}

