/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.map.DungeonMap;
import com.megacrit.cardcrawl.map.MapRoomNode;
import com.megacrit.cardcrawl.vfx.AbstractGameEffect;
import com.megacrit.cardcrawl.vfx.MapCircleEffect;
import com.megacrit.cardcrawl.vfx.scene.LevelTransitionTextOverlayEffect;
import java.util.ArrayList;

public class DungeonMapScreen {
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("DungeonMapScreen");
    public static final String[] TEXT = DungeonMapScreen.uiStrings.TEXT;
    public DungeonMap map = new DungeonMap();
    private ArrayList<MapRoomNode> visibleMapNodes = new ArrayList();
    public boolean dismissable = false;
    private static final float MAP_SCROLL_UPPER = -2290.0f * Settings.scale;
    private static final float MAP_SCROLL_LOWER = 190.0f * Settings.scale;
    public static final float ICON_SPACING_Y = 120.0f * Settings.scale;
    public static float offsetY = -100.0f * Settings.scale;
    private float targetOffsetY = offsetY;
    private float grabStartY = 0.0f;
    private boolean grabbedScreen = false;
    public boolean clicked = false;
    public float clickTimer = 0.0f;
    private float clickStartX;
    private float clickStartY;
    private float scrollWaitTimer = 0.0f;
    private static final float SCROLL_WAIT_TIME = 1.0f;
    private static final float SPECIAL_ANIMATE_TIME = 3.0f;
    private static final float FAST_ANIM_TIME = 0.5f;
    private float oscillatingTimer = 0.0f;
    private float oscillatingFader = 0.0f;
    private Color oscillatingColor = Settings.GOLD_COLOR.cpy();

    public DungeonMapScreen() {
        this.oscillatingColor.a = 0.0f;
    }

    public void update() {
        this.map.update();
        if (AbstractDungeon.isScreenUp) {
            for (MapRoomNode n : this.visibleMapNodes) {
                n.update();
            }
        }
        if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.MAP && !this.dismissable && this.scrollWaitTimer < 0.0f) {
            this.oscillateColor();
        }
        for (AbstractGameEffect e : AbstractDungeon.topLevelEffects) {
            if (!(e instanceof MapCircleEffect)) continue;
            return;
        }
        if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.MAP) {
            this.updateYOffset();
        }
        this.updateMouse();
    }

    private void updateMouse() {
        if (this.clicked) {
            this.clicked = false;
        }
        if (InputHelper.justReleasedClickLeft && this.clickTimer < 0.4f && Vector2.dst(this.clickStartX, this.clickStartY, InputHelper.mX, InputHelper.mY) < Settings.CLICK_DIST_THRESHOLD) {
            this.clicked = true;
        }
        if (InputHelper.justClickedLeft) {
            this.clickTimer = 0.0f;
            this.clickStartX = InputHelper.mX;
            this.clickStartY = InputHelper.mY;
        } else if (InputHelper.isMouseDown) {
            this.clickTimer += Gdx.graphics.getDeltaTime();
        }
    }

    private void updateYOffset() {
        if (this.grabbedScreen) {
            if (InputHelper.isMouseDown) {
                this.targetOffsetY = (float)InputHelper.mY - this.grabStartY;
            } else {
                this.grabbedScreen = false;
            }
        } else if (this.scrollWaitTimer < 0.0f) {
            if (InputHelper.scrolledDown) {
                this.targetOffsetY += Settings.MAP_SCROLL_SPEED;
            } else if (InputHelper.scrolledUp) {
                this.targetOffsetY -= Settings.MAP_SCROLL_SPEED;
            }
            if (InputHelper.justClickedLeft && this.scrollWaitTimer < 0.0f) {
                this.grabbedScreen = true;
                this.grabStartY = (float)InputHelper.mY - this.targetOffsetY;
            }
        }
        this.resetScrolling();
        this.updateAnimation();
    }

    private void resetScrolling() {
        if (this.targetOffsetY < MAP_SCROLL_UPPER) {
            this.targetOffsetY = MathHelper.scrollSnapLerpSpeed(this.targetOffsetY, MAP_SCROLL_UPPER);
        } else if (this.targetOffsetY > MAP_SCROLL_LOWER) {
            this.targetOffsetY = MathHelper.scrollSnapLerpSpeed(this.targetOffsetY, MAP_SCROLL_LOWER);
        }
    }

    private void updateAnimation() {
        this.scrollWaitTimer -= Gdx.graphics.getDeltaTime();
        if (this.scrollWaitTimer < 0.0f) {
            offsetY = MathUtils.lerp(offsetY, this.targetOffsetY, Gdx.graphics.getDeltaTime() * 12.0f);
        } else if (this.scrollWaitTimer < 3.0f) {
            offsetY = Interpolation.exp10.apply(MAP_SCROLL_LOWER, MAP_SCROLL_UPPER, this.scrollWaitTimer / 3.0f);
        }
    }

    public void updateImage() {
        this.visibleMapNodes.clear();
        for (ArrayList<MapRoomNode> rows : CardCrawlGame.dungeon.getMap()) {
            for (MapRoomNode node : rows) {
                if (!node.hasEdges()) continue;
                this.visibleMapNodes.add(node);
            }
        }
    }

    public void render(SpriteBatch sb) {
        this.map.render(sb);
        if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.MAP) {
            for (MapRoomNode n : this.visibleMapNodes) {
                n.render(sb);
            }
        }
        if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.MAP && !this.dismissable && this.scrollWaitTimer < 0.0f) {
            FontHelper.renderDeckViewTip(sb, TEXT[0], 80.0f * Settings.scale, this.oscillatingColor);
        }
    }

    private void oscillateColor() {
        this.oscillatingFader += Gdx.graphics.getDeltaTime();
        if (this.oscillatingFader > 1.0f) {
            this.oscillatingFader = 1.0f;
            this.oscillatingTimer += Gdx.graphics.getDeltaTime() * 5.0f;
        }
        this.oscillatingColor.a = (0.33f + (MathUtils.cos(this.oscillatingTimer) + 1.0f) / 3.0f) * this.oscillatingFader;
    }

    public void open(boolean doScrollingAnimation) {
        AbstractDungeon.player.releaseCard();
        if (Settings.isDebug) {
            doScrollingAnimation = false;
        }
        InputHelper.justClickedLeft = false;
        this.clicked = false;
        this.clickTimer = 999.0f;
        this.grabbedScreen = false;
        AbstractDungeon.topPanel.unhoverHitboxes();
        this.map.show();
        boolean bl = this.dismissable = !doScrollingAnimation;
        if (MathUtils.randomBoolean()) {
            CardCrawlGame.sound.play("MAP_OPEN", 0.1f);
        } else {
            CardCrawlGame.sound.play("MAP_OPEN_2", 0.1f);
        }
        if (doScrollingAnimation) {
            AbstractDungeon.topLevelEffects.add(new LevelTransitionTextOverlayEffect(AbstractDungeon.name, AbstractDungeon.levelNum));
            this.scrollWaitTimer = CardCrawlGame.fastMode ? 1.0f : 4.0f;
            offsetY = MAP_SCROLL_UPPER;
            this.targetOffsetY = MAP_SCROLL_LOWER;
        } else {
            this.scrollWaitTimer = 0.0f;
            AbstractDungeon.overlayMenu.cancelButton.show(TEXT[1]);
            offsetY = AbstractDungeon.getCurrMapNode() == null ? MAP_SCROLL_UPPER : -50.0f * Settings.scale + (float)AbstractDungeon.getCurrMapNode().y * -ICON_SPACING_Y;
            this.targetOffsetY = offsetY;
        }
        AbstractDungeon.dynamicBanner.hide();
        AbstractDungeon.screen = AbstractDungeon.CurrentScreen.MAP;
        AbstractDungeon.isScreenUp = true;
        this.grabStartY = 0.0f;
        AbstractDungeon.overlayMenu.proceedButton.hide();
        AbstractDungeon.overlayMenu.hideCombatPanels();
        AbstractDungeon.overlayMenu.endTurnButton.hide();
        AbstractDungeon.overlayMenu.showBlackScreen();
        this.updateImage();
    }

    public void close() {
        this.map.hide();
        AbstractDungeon.overlayMenu.cancelButton.hide();
        this.clicked = false;
    }

    public void closeInstantly() {
        this.map.hideInstantly();
        AbstractDungeon.overlayMenu.cancelButton.hideInstantly();
        this.clicked = false;
    }
}

