/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.characters.Crowbot;
import com.megacrit.cardcrawl.characters.Ironclad;
import com.megacrit.cardcrawl.characters.TheSilent;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.CardLibrary;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.screens.CharSelectInfo;
import java.util.ArrayList;

public class CharSelectDeckViewScreen {
    private static float drawStartX;
    private static float drawStartY;
    private static float padX;
    private static float padY;
    private static final int CARDS_PER_LINE = 5;
    private boolean grabbedScreen = false;
    private float grabStartY = 0.0f;
    private float currentDiffY = 0.0f;
    public ArrayList<AbstractCard> cards = null;
    public boolean screenUp = false;

    public CharSelectDeckViewScreen() {
        drawStartX = Settings.WIDTH;
        drawStartX -= 5.0f * AbstractCard.IMG_WIDTH * 0.75f;
        drawStartX -= 4.0f * Settings.CARD_VIEW_PAD_X;
        drawStartX /= 2.0f;
        drawStartX += AbstractCard.IMG_WIDTH * 0.75f / 2.0f;
        padX = AbstractCard.IMG_WIDTH * 0.75f + Settings.CARD_VIEW_PAD_X;
        padY = AbstractCard.IMG_HEIGHT * 0.75f + Settings.CARD_VIEW_PAD_Y;
    }

    public void update() {
        this.updateScrolling();
        this.updatePositions();
    }

    public void open(ArrayList<AbstractCard> allCards) {
        CardCrawlGame.cancelButton.show("Back");
        CardCrawlGame.mainMenuScreen.darken();
        this.currentDiffY = 0.0f;
        this.grabStartY = 0.0f;
        this.grabbedScreen = false;
        this.cards = allCards;
        this.hideCards();
        this.screenUp = true;
    }

    public void open(AbstractPlayer.PlayerClass selection) {
        CardCrawlGame.cancelButton.show("Back");
        CardCrawlGame.mainMenuScreen.darken();
        this.currentDiffY = 0.0f;
        this.grabStartY = 0.0f;
        this.grabbedScreen = false;
        switch (selection) {
            case IRONCLAD: {
                ArrayList<String> cardNames = Ironclad.getStartingDeck();
                this.cards = this.turnStringIntoCards(selection, cardNames);
                break;
            }
            case THE_SILENT: {
                ArrayList<String> cardNames = TheSilent.getStartingDeck();
                this.cards = this.turnStringIntoCards(selection, cardNames);
                break;
            }
            case CROWBOT: {
                ArrayList<String> cardNames = Crowbot.getStartingDeck();
                this.cards = this.turnStringIntoCards(selection, cardNames);
            }
        }
        this.hideCards();
        this.screenUp = true;
    }

    public void open(CharSelectInfo info, AbstractPlayer.PlayerClass selection) {
        CardCrawlGame.cancelButton.show("Back");
        CardCrawlGame.mainMenuScreen.darken();
        this.currentDiffY = 0.0f;
        this.grabStartY = 0.0f;
        this.grabbedScreen = false;
        this.cards = this.turnStringIntoCards(selection, info.deck);
        this.hideCards();
        this.screenUp = true;
    }

    private ArrayList<AbstractCard> turnStringIntoCards(AbstractPlayer.PlayerClass selection, ArrayList<String> collection) {
        ArrayList<AbstractCard> returnList = new ArrayList<AbstractCard>();
        for (String c : collection) {
            returnList.add(CardLibrary.getCopy(c));
        }
        return returnList;
    }

    private void updatePositions() {
        int lineNum = 0;
        for (int i = 0; i < this.cards.size(); ++i) {
            int mod = i % 5;
            if (mod == 0 && i != 0) {
                ++lineNum;
            }
            this.cards.get((int)i).target_x = drawStartX + (float)mod * padX;
            this.cards.get((int)i).target_y = drawStartY + this.currentDiffY - (float)lineNum * padY;
            this.cards.get(i).update();
            this.cards.get(i).updateHoverLogic();
        }
    }

    private void updateScrolling() {
        int y = InputHelper.mY;
        if (!this.grabbedScreen) {
            if (InputHelper.scrolledDown) {
                this.currentDiffY += Settings.SCROLL_SPEED;
            } else if (InputHelper.scrolledUp) {
                this.currentDiffY -= Settings.SCROLL_SPEED;
            }
            if (InputHelper.justClickedLeft) {
                this.grabbedScreen = true;
                this.grabStartY = (float)y - this.currentDiffY;
            }
        } else if (InputHelper.isMouseDown) {
            this.currentDiffY = (float)y - this.grabStartY;
        } else {
            this.grabbedScreen = false;
        }
    }

    private void hideCards() {
        int lineNum = 0;
        for (int i = 0; i < this.cards.size(); ++i) {
            int mod = i % 5;
            if (mod == 0 && i != 0) {
                ++lineNum;
            }
            this.cards.get((int)i).current_x = drawStartX + (float)mod * padX;
            this.cards.get((int)i).current_y = drawStartY + this.currentDiffY - (float)lineNum * padY - MathUtils.random(100.0f * Settings.scale, 200.0f * Settings.scale);
            this.cards.get((int)i).targetDrawScale = 0.75f;
            this.cards.get((int)i).drawScale = 0.75f;
            this.cards.get(i).setAngle(0.0f, true);
        }
    }

    public void render(SpriteBatch sb) {
        for (AbstractCard c : this.cards) {
            c.render(sb);
        }
        for (AbstractCard c : this.cards) {
            c.renderCardTip(sb);
        }
        CardCrawlGame.cancelButton.render(sb);
    }

    static {
        drawStartY = (float)Settings.HEIGHT * 0.66f;
    }
}

