/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.rooms;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.shop.Merchant;

public class ShopRoom
extends AbstractRoom {
    public int shopRarityBonus = 6;
    public Merchant merchant;

    public ShopRoom() {
        this.phase = AbstractRoom.RoomPhase.COMPLETE;
        this.description = "You come across a wandering merchant...";
        this.merchant = null;
        this.mapSymbol = "$";
        this.mapImg = ImageMaster.MAP_NODE_MERCHANT;
        this.mapImgOutline = ImageMaster.MAP_NODE_MERCHANT_OUTLINE;
    }

    public void setMerchant(Merchant merc) {
        this.merchant = merc;
    }

    @Override
    public void onPlayerEntry() {
        this.playBGM("SHOP");
        AbstractDungeon.overlayMenu.proceedButton.setLabel("Skip Merchant");
        this.setMerchant(new Merchant());
    }

    @Override
    public AbstractCard.CardRarity getCardRarity(int roll) {
        if (roll < 3 + this.shopRarityBonus) {
            return AbstractCard.CardRarity.RARE;
        }
        if (roll < 40 + this.shopRarityBonus) {
            return AbstractCard.CardRarity.UNCOMMON;
        }
        return AbstractCard.CardRarity.COMMON;
    }

    @Override
    public void update() {
        super.update();
        if (this.merchant != null) {
            this.merchant.update();
        }
    }

    @Override
    public void render(SpriteBatch sb) {
        if (this.merchant != null) {
            this.merchant.render(sb);
        }
        super.render(sb);
        this.renderTips(sb);
    }
}

