/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.rooms;

import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.rooms.MonsterRoom;

public class MonsterRoomElite
extends MonsterRoom {
    public MonsterRoomElite() {
        this.mapSymbol = "E";
        this.mapImg = ImageMaster.MAP_NODE_ELITE;
        this.mapImgOutline = ImageMaster.MAP_NODE_ELITE_OUTLINE;
        this.eliteTrigger = true;
    }

    @Override
    public void onPlayerEntry() {
        this.playBGM(null);
        if (this.monsters == null) {
            this.monsters = AbstractDungeon.getEliteMonsterForRoomCreation();
            this.monsters.init();
        }
        waitTimer = 0.1f;
    }

    @Override
    public void dropReward() {
        AbstractRelic.RelicTier tier = this.returnRandomRelicTier();
        this.addRelicToRewards(tier);
        if (AbstractDungeon.player.hasRelic("Test 7")) {
            this.addRelicToRewards(tier);
        }
    }

    private AbstractRelic.RelicTier returnRandomRelicTier() {
        int roll = AbstractDungeon.relicRng.random(0, 99);
        if (roll < 50) {
            return AbstractRelic.RelicTier.COMMON;
        }
        if (roll > 82) {
            return AbstractRelic.RelicTier.RARE;
        }
        return AbstractRelic.RelicTier.UNCOMMON;
    }

    @Override
    public AbstractCard.CardRarity getCardRarity(int roll) {
        int rareRate = AbstractDungeon.player.hasRelic("Nloth's Gift") ? 30 : 10;
        if (roll < rareRate) {
            if (AbstractDungeon.player.hasRelic("Nloth's Gift") && roll > 3) {
                AbstractDungeon.player.getRelic("Nloth's Gift").flash();
            }
            return AbstractCard.CardRarity.RARE;
        }
        if (roll < 50) {
            return AbstractCard.CardRarity.UNCOMMON;
        }
        return AbstractCard.CardRarity.COMMON;
    }
}

