/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.rooms;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.monsters.MonsterGroup;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.screens.DiscardPileViewScreen;

public class MonsterRoom
extends AbstractRoom {
    public DiscardPileViewScreen discardPileViewScreen;
    public static final float COMBAT_WAIT_TIME = 0.1f;

    public MonsterRoom() {
        this.phase = AbstractRoom.RoomPhase.COMBAT;
        this.description = "You encounter a monster";
        this.mapSymbol = "M";
        this.mapImg = ImageMaster.MAP_NODE_ENEMY;
        this.mapImgOutline = ImageMaster.MAP_NODE_ENEMY_OUTLINE;
        this.discardPileViewScreen = new DiscardPileViewScreen();
    }

    @Override
    public AbstractCard.CardRarity getCardRarity(int roll) {
        int rareRate = AbstractDungeon.player.hasRelic("Nloth's Gift") ? 9 : 3;
        if (roll < rareRate) {
            if (AbstractDungeon.player.hasRelic("Nloth's Gift") && roll > 3) {
                AbstractDungeon.player.getRelic("Nloth's Gift").flash();
            }
            return AbstractCard.CardRarity.RARE;
        }
        if (roll < 40) {
            return AbstractCard.CardRarity.UNCOMMON;
        }
        return AbstractCard.CardRarity.COMMON;
    }

    @Override
    public void onPlayerEntry() {
        this.playBGM(null);
        if (this.monsters == null) {
            this.monsters = AbstractDungeon.getMonsterForRoomCreation();
            this.monsters.init();
        }
        waitTimer = 0.1f;
    }

    public void setMonster(MonsterGroup m) {
        this.monsters = m;
    }

    @Override
    public void render(SpriteBatch sb) {
        super.render(sb);
    }
}

