/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.relics;

import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.PowerTip;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.relics.AbstractRelic;

public class VelvetChoker
extends AbstractRelic {
    public static final String ID = "Velvet Choker";
    private static final int PLAY_LIMIT = 6;

    public VelvetChoker() {
        this(null);
    }

    public VelvetChoker(AbstractPlayer.PlayerClass c) {
        super(ID, "redChoker.png", AbstractRelic.RelicTier.BOSS, AbstractRelic.LandingSound.FLAT);
    }

    @Override
    public String getUpdatedDescription() {
        if (AbstractDungeon.player != null) {
            return this.setDescription(AbstractDungeon.player.chosenClass);
        }
        return this.setDescription(null);
    }

    private String setDescription(AbstractPlayer.PlayerClass c) {
        if (c == null) {
            return this.DESCRIPTIONS[2] + this.DESCRIPTIONS[0] + 6 + this.DESCRIPTIONS[1];
        }
        switch (c) {
            case IRONCLAD: {
                return this.DESCRIPTIONS[2] + this.DESCRIPTIONS[0] + 6 + this.DESCRIPTIONS[1];
            }
            case THE_SILENT: {
                return this.DESCRIPTIONS[3] + this.DESCRIPTIONS[0] + 6 + this.DESCRIPTIONS[1];
            }
            case CROWBOT: {
                return this.DESCRIPTIONS[4] + this.DESCRIPTIONS[0] + 6 + this.DESCRIPTIONS[1];
            }
        }
        return this.DESCRIPTIONS[2] + this.DESCRIPTIONS[0] + 6 + this.DESCRIPTIONS[1];
    }

    @Override
    public void updateDescription(AbstractPlayer.PlayerClass c) {
        this.description = this.setDescription(c);
        this.tips.clear();
        this.tips.add(new PowerTip(this.name, this.description));
        this.initializeTips();
    }

    @Override
    public void onEquip() {
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                ++AbstractDungeon.player.energy.redMaster;
                break;
            }
            case THE_SILENT: {
                ++AbstractDungeon.player.energy.greenMaster;
                break;
            }
            case CROWBOT: {
                ++AbstractDungeon.player.energy.blueMaster;
                break;
            }
        }
    }

    @Override
    public void onUnequip() {
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                --AbstractDungeon.player.energy.redMaster;
                break;
            }
            case THE_SILENT: {
                --AbstractDungeon.player.energy.greenMaster;
                break;
            }
            case CROWBOT: {
                --AbstractDungeon.player.energy.blueMaster;
                break;
            }
        }
    }

    @Override
    public void atBattleStart() {
        this.counter = 0;
    }

    @Override
    public void atTurnStart() {
        this.counter = 0;
    }

    @Override
    public void onPlayCard(AbstractCard card, AbstractMonster m) {
        if (this.counter < 6 && card.type != AbstractCard.CardType.CURSE) {
            ++this.counter;
            if (this.counter >= 6) {
                this.flash();
            }
        }
    }

    @Override
    public boolean canPlay(AbstractCard card) {
        if (this.counter >= 6 && card.type != AbstractCard.CardType.CURSE) {
            card.cantUseMessage = this.DESCRIPTIONS[5] + 6 + this.DESCRIPTIONS[1];
            return false;
        }
        return true;
    }

    @Override
    public void onVictory() {
        this.counter = -1;
    }

    @Override
    public AbstractRelic makeCopy() {
        return new VelvetChoker(AbstractDungeon.player.chosenClass);
    }

    @Override
    public AbstractRelic makeCopy(AbstractPlayer.PlayerClass chosenClass) {
        return new VelvetChoker(chosenClass);
    }
}

