/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.powers;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.localization.PowerStrings;
import com.megacrit.cardcrawl.powers.AbstractPower;

public class SystemsPower
extends AbstractPower {
    public static final String POWER_ID = "Systems";
    private static final PowerStrings powerStrings = CardCrawlGame.languagePack.getPowerStrings("Systems");
    public static final String NAME = SystemsPower.powerStrings.NAME;
    public static final String[] DESCRIPTIONS = SystemsPower.powerStrings.DESCRIPTIONS;

    public SystemsPower(AbstractCreature owner, int newAmount) {
        this.name = NAME;
        this.ID = POWER_ID;
        this.owner = owner;
        this.amount = -1;
        this.updateDescription();
        this.img = ImageMaster.loadImage("images/powers/32/systems.png");
    }

    @Override
    public void updateDescription() {
        this.description = DESCRIPTIONS[0];
    }

    @Override
    public void onGainCharge(int amount) {
        if (amount > 0) {
            this.flash();
            AbstractDungeon.actionManager.addToTop(new DamageAction((AbstractCreature)AbstractDungeon.getRandomMonster(), new DamageInfo(this.owner, amount, DamageInfo.DamageType.THORNS), AbstractGameAction.AttackEffect.BLUNT_HEAVY));
        }
    }
}

