/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.powers;

import com.megacrit.cardcrawl.actions.unique.RetainCardsAction;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.PowerStrings;
import com.megacrit.cardcrawl.powers.AbstractPower;

public class RetainCardPower
extends AbstractPower {
    public static final String POWER_ID = "Retain Cards";
    private static final PowerStrings powerStrings = CardCrawlGame.languagePack.getPowerStrings("Retain Cards");
    public static final String NAME = RetainCardPower.powerStrings.NAME;
    public static final String[] DESCRIPTIONS = RetainCardPower.powerStrings.DESCRIPTIONS;

    public RetainCardPower(AbstractCreature owner, int numCards) {
        this.name = NAME;
        this.ID = POWER_ID;
        this.owner = owner;
        this.amount = numCards;
        this.updateDescription();
        this.loadRegion("retain");
    }

    @Override
    public void updateDescription() {
        this.description = this.amount == 1 ? DESCRIPTIONS[0] + this.amount + DESCRIPTIONS[1] : DESCRIPTIONS[0] + this.amount + DESCRIPTIONS[2];
    }

    @Override
    public void atEndOfTurn(boolean isPlayer) {
        if (isPlayer && !AbstractDungeon.player.hand.isEmpty()) {
            AbstractDungeon.actionManager.addToBottom(new RetainCardsAction(this.owner, this.amount));
        }
    }
}

