/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.powers;

import com.megacrit.cardcrawl.actions.common.LoseChargeAction;
import com.megacrit.cardcrawl.actions.common.RemoveSpecificPowerAction;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.localization.PowerStrings;
import com.megacrit.cardcrawl.powers.AbstractPower;

public class ImpulsePower
extends AbstractPower {
    public static final String POWER_ID = "Impulse";
    private static final PowerStrings powerStrings = CardCrawlGame.languagePack.getPowerStrings("Impulse");
    public static final String NAME = ImpulsePower.powerStrings.NAME;
    public static final String[] DESCRIPTIONS = ImpulsePower.powerStrings.DESCRIPTIONS;

    public ImpulsePower(AbstractCreature owner, int amount) {
        this.name = NAME;
        this.ID = POWER_ID;
        this.owner = owner;
        this.amount = amount;
        this.updateDescription();
        this.img = ImageMaster.loadImage("images/powers/32/impulse.png");
        this.type = AbstractPower.PowerType.BUFF;
    }

    @Override
    public void atEndOfTurn(boolean isPlayer) {
        if (isPlayer) {
            AbstractDungeon.actionManager.addToBottom(new RemoveSpecificPowerAction(this.owner, this.owner, POWER_ID));
        }
    }

    @Override
    public void updateDescription() {
        this.description = DESCRIPTIONS[0] + this.amount + DESCRIPTIONS[1];
    }

    @Override
    public void onRemove() {
        this.flash();
        AbstractDungeon.actionManager.addToTop(new LoseChargeAction(this.amount));
    }
}

